/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class AtsObjects {
    public static String toUuidsString(String separator, Collection<? extends IAtsObject> atsObjects) {
        return Collections.toString((String)separator, AtsObjects.toUuids(atsObjects));
    }

    public static List<Long> toUuids(Collection<? extends IAtsObject> atsObjects) {
        ArrayList<Long> uuids = new ArrayList<Long>(atsObjects.size());
        for (IAtsObject iAtsObject : atsObjects) {
            uuids.add(iAtsObject.getId());
        }
        return uuids;
    }

    public static List<String> toGuids(Collection<? extends IAtsObject> atsObjects) {
        ArrayList<String> guids = new ArrayList<String>(atsObjects.size());
        for (IAtsObject iAtsObject : atsObjects) {
            guids.add(AtsUtilCore.getGuid(iAtsObject));
        }
        return guids;
    }

    public static List<String> toAtsIds(Collection<? extends IAtsWorkItem> workItem) {
        ArrayList<String> guids = new ArrayList<String>(workItem.size());
        for (IAtsWorkItem iAtsWorkItem : workItem) {
            guids.add(iAtsWorkItem.getAtsId());
        }
        return guids;
    }

    public static String toString(String separator, Collection<? extends Object> objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            if (object instanceof IAtsObject) {
                sb.append(((IAtsObject)object).getName());
            } else {
                sb.append(object.toString());
            }
            sb.append(separator);
        }
        if (sb.length() > separator.length()) {
            return sb.substring(0, sb.length() - separator.length());
        }
        return "";
    }

    public static Collection<String> getNames(Collection<? extends IAtsObject> atsObjects) {
        ArrayList<String> names = new ArrayList<String>();
        for (IAtsObject iAtsObject : atsObjects) {
            names.add(iAtsObject.getName());
        }
        return names;
    }

    public static String toAtsIdsFromActions(Collection<IAtsAction> actions) {
        ArrayList<String> guids = new ArrayList<String>(actions.size());
        for (IAtsAction action : actions) {
            guids.add(action.getAtsId());
        }
        return Collections.toString((String)", ", guids);
    }

    public static Collection<ArtifactId> getArtifacts(Collection<?> objects) {
        LinkedList<ArtifactId> artifacts = new LinkedList<ArtifactId>();
        for (Object object : objects) {
            if (object instanceof ArtifactId) {
                artifacts.add((ArtifactId)object);
                continue;
            }
            if (!(object instanceof IAtsObject)) continue;
            artifacts.add((ArtifactId)((IAtsObject)object).getStoreObject());
        }
        return artifacts;
    }

    public static Collection<ArtifactId> getTeamWfArtifacts(Collection<?> objects, IAtsServices services) {
        LinkedList<ArtifactId> artifacts = new LinkedList<ArtifactId>();
        for (Object object : objects) {
            if (object instanceof ArtifactId) {
                ArtifactId artId = (ArtifactId)object;
                if (services.getStoreService().isOfType(artId, new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                    artifacts.addAll(AtsObjects.getArtifacts(services.getWorkItemService().getTeams((Object)services.getWorkItemFactory().getAction(artId))));
                }
            }
            if (!(object instanceof IAtsTeamWorkflow)) continue;
            artifacts.add((ArtifactId)((IAtsTeamWorkflow)object).getStoreObject());
        }
        return artifacts;
    }

    public static <T> Collection<T> getActive(Collection<? extends IAtsConfigObject> objects) {
        LinkedList<IAtsConfigObject> active = new LinkedList<IAtsConfigObject>();
        for (IAtsConfigObject iAtsConfigObject : objects) {
            if (!iAtsConfigObject.isActive()) continue;
            active.add(iAtsConfigObject);
        }
        return active;
    }
}

