/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.column.IAtsColumnService;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.IAtsCache;
import org.eclipse.osee.ats.api.config.IAtsConfigurationProvider;
import org.eclipse.osee.ats.api.config.IWorkDefinitionStringProvider;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueService;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.program.IAtsProgramService;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.query.IAtsSearchDataProvider;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.task.IAtsTaskService;
import org.eclipse.osee.ats.api.team.IAtsConfigItemFactory;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinitionService;
import org.eclipse.osee.ats.api.team.IAtsWorkItemFactory;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.IArtifactResolver;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.util.ISequenceProvider;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.version.IVersionFactory;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionAdmin;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinitionService;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.ats.api.workflow.IAtsActionFactory;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsImplementerService;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.IAttribute;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.config.AtsCache;
import org.eclipse.osee.ats.core.config.TeamDefinitionService;
import org.eclipse.osee.ats.core.program.AtsProgramService;
import org.eclipse.osee.ats.core.review.AtsReviewServiceImpl;
import org.eclipse.osee.ats.core.util.AtsCoreFactory;
import org.eclipse.osee.ats.core.util.AtsPreferencesService;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.ats.core.version.AtsVersionServiceImpl;
import org.eclipse.osee.ats.core.workdef.AtsWorkDefinitionAdminImpl;
import org.eclipse.osee.ats.core.workdef.AtsWorkDefinitionCache;
import org.eclipse.osee.ats.core.workflow.AtsImplementersService;
import org.eclipse.osee.ats.core.workflow.AtsWorkItemServiceImpl;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.osgi.service.event.EventAdmin;

public abstract class AtsCoreServiceImpl
implements IAtsServices {
    private static final Object lock = new Object();
    private static volatile IOseeBranch atsBranch;
    private static final String ATS_BRANCH_NAME = "ats.branch.name";
    private static final String ATS_BRANCH_UUID = "ats.branch.uuid";
    private final List<IAtsSearchDataProvider> searchDataProviders = new ArrayList<IAtsSearchDataProvider>();
    protected Log logger;
    protected IAtsCache atsCache;
    protected JdbcService jdbcService;
    protected IAtsWorkDefinitionAdmin workDefAdmin;
    protected IAtsWorkDefinitionService workDefService;
    protected IAtsUserService userService;
    protected IAtsConfigurationProvider configProvider;
    protected IAtsEarnedValueService earnedValueService;
    protected TeamWorkflowProviders teamWorkflowProvidersLazy;
    protected AtsWorkDefinitionCache workDefCache;
    protected IAttributeResolver attributeResolverService;
    protected IAtsActionFactory actionFactory;
    protected IAtsImplementerService implementerService;
    protected IAtsWorkItemService workItemService;
    protected ISequenceProvider sequenceProvider;
    protected IAtsProgramService programService;
    protected IAtsStateFactory stateFactory;
    protected IArtifactResolver artifactResolver;
    protected IVersionFactory versionFactory;
    protected IAtsBranchService branchService;
    protected IAtsReviewService reviewService;
    protected IAtsWorkStateFactory workStateFactory;
    protected IAtsLogFactory logFactory;
    protected IAtsColumnService columnServices;
    protected IAtsWorkItemFactory workItemFactory;
    protected IAtsConfigItemFactory configItemFactory;
    protected IAtsActionableItemService actionableItemManager;
    protected IRelationResolver relationResolver;
    protected IAtsVersionService versionService;
    protected IAtsTaskService taskService;
    protected IAtsTeamDefinitionService teamDefinitionService;
    protected IAtsQueryService queryService;
    protected IAtsStoreService storeService;
    private EventAdmin eventAdmin;
    private static String ATS_ID_QUERY;

    static {
        ATS_ID_QUERY = "SELECT art.art_id FROM osee_artifact art, osee_txs txs, OSEE_ATTRIBUTE attr WHERE art.gamma_id = txs.gamma_id AND txs.tx_current = 1 AND txs.branch_id = ? and attr.ART_ID = art.ART_ID and attr.ATTR_TYPE_ID = 1152921504606847877 and attr.VALUE = ?";
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setAtsWorkDefinitionService(IAtsWorkDefinitionService workDefService) {
        this.workDefService = workDefService;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setConfigurationsService(IAtsConfigurationProvider configProvider) {
        this.configProvider = configProvider;
    }

    public void setAtsUserService(IAtsUserService userServiceClient) {
        this.userService = userServiceClient;
    }

    public void addSearchDataProvider(IAtsSearchDataProvider provider) {
        this.searchDataProviders.add(provider);
    }

    public void removeSearchDataProvider(IAtsSearchDataProvider provider) {
        this.searchDataProviders.remove(provider);
    }

    public void start() throws OseeCoreException {
        Conditions.checkNotNull((Object)this.workDefService, (String)"IAtsWorkDefinitionService");
        this.atsCache = new AtsCache(this);
        this.workDefService.setWorkDefinitionStringProvider((IWorkDefinitionStringProvider)this);
        this.teamWorkflowProvidersLazy = new TeamWorkflowProviders();
        this.workDefCache = new AtsWorkDefinitionCache();
        this.workDefAdmin = new AtsWorkDefinitionAdminImpl(this.workDefCache, this.workDefService, this.attributeResolverService, this.teamWorkflowProvidersLazy);
        this.workItemService = new AtsWorkItemServiceImpl(this, this.teamWorkflowProvidersLazy);
        this.programService = new AtsProgramService(this);
        this.teamDefinitionService = new TeamDefinitionService(this);
        this.versionService = new AtsVersionServiceImpl(this, this.eventAdmin);
        this.reviewService = new AtsReviewServiceImpl(this);
    }

    public void stop() {
        if (this.workDefAdmin != null) {
            this.workDefAdmin.clearCaches();
        }
        this.workDefAdmin = null;
        this.atsCache = null;
        this.workDefCache = null;
        this.jdbcService = null;
        this.versionFactory = null;
    }

    public void invalidateAllCaches() {
        this.atsCache.invalidate();
    }

    public void invalidateWorkDefinitionCache() {
        this.workDefCache.invalidate();
    }

    public String getAtsId(ArtifactId artifact) {
        return AtsCoreServiceImpl.getAtsId(this.getAttributeResolver(), artifact);
    }

    public String getAtsId(IAtsObject atsObject) {
        return AtsCoreServiceImpl.getAtsId(this.getAttributeResolver(), (ArtifactId)atsObject.getStoreObject());
    }

    protected static String getAtsId(IAttributeResolver attrResolver, IAtsObject atsObject) {
        return AtsCoreServiceImpl.getAtsId(attrResolver, (ArtifactId)atsObject.getStoreObject());
    }

    protected static String getAtsId(IAttributeResolver attrResolver, ArtifactId artifact) {
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        String toReturn = (String)attrResolver.getSoleAttributeValue(artifact, (AttributeTypeId)AtsAttributeTypes.AtsId, null);
        if (toReturn == null) {
            toReturn = (String)artifact.getGuid();
        }
        return toReturn;
    }

    public IAtsWorkDefinitionAdmin getWorkDefAdmin() {
        return this.workDefAdmin;
    }

    public <T> T getConfigItem(ArtifactId artifact) {
        return this.getConfigItem(artifact.getId());
    }

    public <T> T getConfigItem(String guid) {
        ArtifactToken artifact;
        IAtsObject atsObject = this.getCache().getAtsObjectByGuid(guid);
        if (atsObject == null && (artifact = this.getArtifactByGuid(guid)) != null && artifact instanceof IAtsConfigObject) {
            atsObject = this.getConfigItemFactory().getConfigObject((ArtifactId)artifact);
        }
        return (T)atsObject;
    }

    public <T> T getConfigItem(Long uuid) {
        ArtifactToken artifact;
        IAtsObject atsObject = this.getCache().getAtsObject(uuid);
        if (atsObject == null && (artifact = this.getArtifact(uuid)) != null && artifact instanceof IAtsConfigObject) {
            atsObject = this.getConfigItemFactory().getConfigObject((ArtifactId)artifact);
        }
        return (T)atsObject;
    }

    public void setConfigValue(String key, String value) {
        ArtifactToken atsConfig = this.getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        IAtsChangeSet changes = this.getStoreService().createAtsChangeSet("Set AtsConfig Value", this.getUserService().getCurrentUser());
        if (atsConfig != null) {
            String keyValue = String.format("%s=%s", key, value);
            boolean found = false;
            Collection attributes = this.getAttributeResolver().getAttributes((ArtifactId)atsConfig, (AttributeTypeId)CoreAttributeTypes.GeneralStringData);
            for (IAttribute attr : attributes) {
                String str = (String)attr.getValue();
                if (!str.startsWith(key)) continue;
                changes.setAttribute((ArtifactId)atsConfig, (AttributeId)attr, (Object)keyValue);
                found = true;
                break;
            }
            if (!found) {
                changes.addAttribute((ArtifactId)atsConfig, (AttributeTypeId)CoreAttributeTypes.GeneralStringData, (Object)keyValue);
            }
            changes.executeIfNeeded();
        }
    }

    public Map<String, String> getWorkDefIdToWorkDef() {
        return this.getConfigurations().getWorkDefIdToWorkDef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOseeBranch getAtsBranch() {
        Object object = lock;
        synchronized (object) {
            if (atsBranch == null) {
                String atsBranchUuid;
                if (AtsPreferencesService.isAvailable()) {
                    try {
                        atsBranchUuid = AtsPreferencesService.get(ATS_BRANCH_UUID);
                        this.setConfig(atsBranchUuid, AtsPreferencesService.get(ATS_BRANCH_NAME));
                    }
                    catch (Exception ex) {
                        OseeLog.log(AtsUtilCore.class, (Level)Level.SEVERE, (String)"Error processing stored ATS Branch.", (Throwable)ex);
                    }
                }
                if (atsBranch == null && Strings.isValid((String)(atsBranchUuid = System.getProperty(ATS_BRANCH_UUID)))) {
                    this.setConfig(atsBranchUuid, System.getProperty(ATS_BRANCH_NAME));
                }
                if (atsBranch == null) {
                    atsBranch = CoreBranches.COMMON;
                }
            }
        }
        return atsBranch;
    }

    private void setConfig(String branchUuid, String name) {
        if (!Strings.isValid((String)name)) {
            name = "unknown";
        }
        if (Strings.isValid((String)branchUuid) && branchUuid.matches("\\d+")) {
            atsBranch = IOseeBranch.create((Long)Long.valueOf(branchUuid), (String)name);
        }
    }

    public void storeAtsBranch(BranchId branch, String name) {
        AtsPreferencesService.get().put(ATS_BRANCH_UUID, branch.getIdString());
        AtsPreferencesService.get().put(ATS_BRANCH_NAME, name);
    }

    public IAtsCache getCache() {
        return this.atsCache;
    }

    public List<IAtsSearchDataProvider> getSearchDataProviders() {
        return this.searchDataProviders;
    }

    public Log getLogger() {
        return this.logger;
    }

    public IAtsEarnedValueService getEarnedValueService() throws OseeStateException {
        return this.earnedValueService;
    }

    public IAtsWorkDefinitionService getWorkDefService() {
        return this.workDefService;
    }

    public IAtsWorkDefinitionAdmin getWorkDefinitionAdmin() throws OseeStateException {
        return this.workDefAdmin;
    }

    public IAtsUserService getUserService() throws OseeStateException {
        return this.userService;
    }

    public IAttributeResolver getAttributeResolver() {
        return this.attributeResolverService;
    }

    public IAtsEarnedValueServiceProvider getEarnedValueServiceProvider() {
        return this;
    }

    public AtsConfigurations getConfigurations() {
        return this.configProvider.getConfigurations();
    }

    public void clearConfigurationsCaches() {
        this.configProvider.clearConfigurationsCaches();
    }

    public ITeamWorkflowProvidersLazy getTeamWorkflowProviders() {
        return this.teamWorkflowProvidersLazy;
    }

    public IAtsActionFactory getActionFactory() {
        return this.actionFactory;
    }

    public IAtsImplementerService getImplementerService() {
        if (this.implementerService == null) {
            this.implementerService = new AtsImplementersService(this);
        }
        return this.implementerService;
    }

    public IAtsWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public void setWorkItemService(IAtsWorkItemService workItemService) {
        this.workItemService = workItemService;
    }

    public ISequenceProvider getSequenceProvider() {
        if (this.sequenceProvider == null) {
            this.sequenceProvider = new ISequenceProvider(){

                public long getNext(String sequenceName) {
                    return AtsCoreServiceImpl.this.jdbcService.getClient().getNextSequence(sequenceName, false);
                }
            };
        }
        return this.sequenceProvider;
    }

    public IAtsProgramService getProgramService() {
        return this.programService;
    }

    public IAtsReviewService getReviewService() throws OseeCoreException {
        return this.reviewService;
    }

    public IAtsStateFactory getStateFactory() {
        if (this.stateFactory == null) {
            this.stateFactory = AtsCoreFactory.newStateFactory(this, this.getLogFactory());
        }
        return this.stateFactory;
    }

    public IAtsWorkStateFactory getWorkStateFactory() {
        if (this.workStateFactory == null) {
            this.workStateFactory = AtsCoreFactory.getWorkStateFactory(this.getUserService());
        }
        return this.workStateFactory;
    }

    public IAtsLogFactory getLogFactory() {
        if (this.logFactory == null) {
            this.logFactory = AtsCoreFactory.getLogFactory();
        }
        return this.logFactory;
    }

    public IArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public IAtsWorkItemFactory getWorkItemFactory() {
        return this.workItemFactory;
    }

    public IAtsConfigItemFactory getConfigItemFactory() {
        return this.configItemFactory;
    }

    public IRelationResolver getRelationResolver() {
        return this.relationResolver;
    }

    public IAtsBranchService getBranchService() throws OseeCoreException {
        return this.branchService;
    }

    public IVersionFactory getVersionFactory() {
        return this.versionFactory;
    }

    public IAtsColumnService getColumnService() {
        if (this.columnServices == null) {
            this.columnServices = AtsCoreFactory.getColumnService(this);
        }
        return this.columnServices;
    }

    public IAtsVersionService getVersionService() {
        return this.versionService;
    }

    public void setVersionService(IAtsVersionService versionService) {
        this.versionService = versionService;
    }

    public IAtsTaskService getTaskService() {
        return this.taskService;
    }

    public IAtsTeamDefinitionService getTeamDefinitionService() {
        return this.teamDefinitionService;
    }

    public IAtsQueryService getQueryService() {
        return this.queryService;
    }

    public IAtsStoreService getStoreService() {
        return this.storeService;
    }

    public IAtsChangeSet createChangeSet(String comment, IAtsUser user) {
        return this.getStoreService().createAtsChangeSet(comment, user);
    }

    public ArtifactId getArtifactByAtsId(String id) {
        ArtifactId artifact = null;
        try {
            Collection workItems = this.getQueryService().getArtifactsFromQuery(ATS_ID_QUERY, new Object[]{this.getAtsBranch().getId(), id});
            if (!workItems.isEmpty()) {
                artifact = (ArtifactId)workItems.iterator().next();
            }
        }
        catch (ItemDoesNotExist itemDoesNotExist) {}
        return artifact;
    }
}

