/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueService;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.model.WorkPackage;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public abstract class AtsAbstractEarnedValueImpl
implements IAtsEarnedValueService {
    protected final Log logger;
    protected final IAtsServices services;

    public AtsAbstractEarnedValueImpl(Log logger, IAtsServices services) {
        this.logger = logger;
        this.services = services;
    }

    public String getWorkPackageId(IAtsWorkItem workItem) {
        ArtifactToken artifact = this.services.getArtifact((IAtsObject)workItem);
        Conditions.checkNotNull((Object)artifact, (String)"workItem", (String)"Can't Find Work Package matching %s", (Object[])new Object[]{workItem.toStringWithId()});
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, null);
    }

    public IAtsWorkPackage getWorkPackage(IAtsWorkItem workItem) throws OseeCoreException {
        WorkPackage wpa = null;
        String workPackageGuid = this.getWorkPackageId(workItem);
        if (Strings.isValid((String)workPackageGuid)) {
            ArtifactToken workPkgArt = this.services.getArtifactById(workPackageGuid);
            wpa = new WorkPackage(this.logger, workPkgArt, this.services);
        }
        return wpa;
    }

    public Collection<IAtsWorkPackage> getWorkPackageOptions(IAtsObject object) throws OseeCoreException {
        ArrayList<IAtsWorkPackage> workPackageOptions = new ArrayList<IAtsWorkPackage>();
        this.getWorkPackageOptions(object, workPackageOptions);
        return workPackageOptions;
    }

    public Collection<IAtsWorkPackage> getWorkPackageOptions(IAtsObject object, List<IAtsWorkPackage> workPackageOptions) throws OseeCoreException {
        block10: {
            block9: {
                if (!(object instanceof IAtsConfigObject)) break block9;
                IAtsConfigObject configObj = (IAtsConfigObject)object;
                ArtifactToken artifact = this.services.getArtifact((IAtsObject)configObj);
                if (artifact == null) break block10;
                for (ArtifactToken workPackageArt : this.services.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.WorkPackage_WorkPackage)) {
                    workPackageOptions.add(new WorkPackage(this.logger, workPackageArt, this.services));
                }
                break block10;
            }
            if (object instanceof IAtsTeamWorkflow) {
                IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)object;
                this.getWorkPackageOptions((IAtsObject)teamWf.getTeamDefinition(), workPackageOptions);
                for (IAtsActionableItem ai : teamWf.getActionableItems()) {
                    this.getWorkPackageOptions((IAtsObject)ai, workPackageOptions);
                }
            } else if (object instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)object;
                IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
                if (teamWf != null) {
                    this.getWorkPackageOptions((IAtsObject)teamWf, workPackageOptions);
                } else if (workItem instanceof IAtsAbstractReview) {
                    IAtsAbstractReview review = (IAtsAbstractReview)workItem;
                    for (IAtsActionableItem ai : review.getActionableItems()) {
                        this.getWorkPackageOptions((IAtsObject)ai, workPackageOptions);
                        if (ai.getTeamDefinition() == null) continue;
                        this.getWorkPackageOptions((IAtsObject)ai.getTeamDefinition(), workPackageOptions);
                    }
                }
            }
        }
        return workPackageOptions;
    }

    public IAtsWorkPackage getWorkPackage(ArtifactToken artifact) {
        return new WorkPackage(this.logger, artifact, this.services);
    }

    public Collection<IAtsWorkPackage> getWorkPackages(IAtsInsertionActivity insertionActivity) {
        ArrayList<IAtsWorkPackage> workPackages = new ArrayList<IAtsWorkPackage>();
        for (ArtifactToken artifact : this.services.getRelationResolver().getRelated((ArtifactId)this.services.getArtifact(insertionActivity.getId()), AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
            workPackages.add(new WorkPackage(this.logger, artifact, this.services));
        }
        return workPackages;
    }

    public double getEstimatedHoursFromArtifact(IAtsWorkItem workItem) {
        return (Double)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.EstimatedHours, (Object)0.0);
    }

    public double getEstimatedHoursFromTasks(IAtsWorkItem workItem, IStateToken relatedToState) {
        if (!(workItem instanceof IAtsTeamWorkflow)) {
            return 0.0;
        }
        return this.getEstimatedHoursFromTasks(workItem, relatedToState);
    }

    public double getEstimatedHoursFromTasks(IAtsWorkItem workItem) {
        if (!(workItem instanceof IAtsTeamWorkflow)) {
            return 0.0;
        }
        double hours = 0.0;
        for (IAtsTask task : this.services.getTaskService().getTask(workItem)) {
            hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)task);
        }
        return hours;
    }

    public double getEstimatedHoursFromReviews(IAtsWorkItem workItem) throws OseeCoreException {
        double hours = 0.0;
        if (workItem.isTeamWorkflow()) {
            for (IAtsAbstractReview review : this.services.getReviewService().getReviews((IAtsTeamWorkflow)workItem)) {
                hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)review);
            }
        }
        return hours;
    }

    public double getEstimatedHoursFromReviews(IAtsWorkItem workItem, IStateToken relatedToState) throws OseeCoreException {
        double hours = 0.0;
        if (workItem.isTeamWorkflow()) {
            IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)workItem;
            for (IAtsAbstractReview review : this.services.getReviewService().getReviews(teamWf)) {
                if (!review.getRelatedToState().equals(relatedToState.getName())) continue;
                hours += this.getEstimatedHoursFromArtifact((IAtsWorkItem)review);
            }
        }
        return hours;
    }

    public double getEstimatedHoursTotal(IAtsWorkItem workItem, IStateToken relatedToState) throws OseeCoreException {
        return this.getEstimatedHoursFromArtifact(workItem) + this.getEstimatedHoursFromTasks(workItem, relatedToState) + this.getEstimatedHoursFromReviews(workItem, relatedToState);
    }

    public double getEstimatedHoursTotal(IAtsWorkItem workItem) throws OseeCoreException {
        return this.getEstimatedHoursFromArtifact(workItem) + this.getEstimatedHoursFromTasks(workItem) + this.getEstimatedHoursFromReviews(workItem);
    }

    public void setWorkPackage(IAtsWorkPackage workPackage, IAtsWorkItem workItem, IAtsChangeSet changes) {
        changes.setSoleAttributeValue(workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, workPackage.getGuid());
    }
}

