/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.util.IValueProvider;
import org.eclipse.osee.ats.api.workdef.IAtsWidgetDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ArtifactValueProvider
implements IValueProvider {
    private final ArtifactToken artifact;
    private final String attributeTypeName;
    private final IAtsServices services;
    private AttributeTypeId attributeType;

    public ArtifactValueProvider(ArtifactToken artifact, IAtsWidgetDefinition widgetDef, IAtsServices services) {
        this.artifact = artifact;
        this.services = services;
        this.attributeTypeName = widgetDef.getAtrributeName();
    }

    public ArtifactValueProvider(ArtifactToken artifact, AttributeTypeToken attributeType, IAtsServices services) {
        this.artifact = artifact;
        this.services = services;
        this.attributeTypeName = attributeType.getName();
    }

    public boolean isEmpty() throws OseeCoreException {
        AttributeTypeId attributeType = this.getAtributeType();
        if (attributeType != null) {
            return this.services.getAttributeResolver().getAttributeCount((ArtifactId)this.artifact, attributeType) == 0;
        }
        return true;
    }

    public Collection<String> getValues() throws OseeCoreException {
        AttributeTypeId attributeType = this.getAtributeType();
        if (attributeType != null) {
            return this.services.getAttributeResolver().getAttributesToStringList((ArtifactId)this.artifact, attributeType);
        }
        return Collections.emptyList();
    }

    public AttributeTypeId getAtributeType() throws OseeCoreException {
        if (this.attributeType == null && Strings.isValid((String)this.attributeTypeName)) {
            this.attributeType = this.services.getStoreService().getAttributeType(this.attributeTypeName);
        }
        return this.attributeType;
    }

    public String getName() {
        return this.artifact.getName();
    }

    public Collection<Date> getDateValues() throws OseeCoreException {
        AttributeTypeId attributeType = this.getAtributeType();
        if (attributeType != null && this.services.getStoreService().isDateType(attributeType)) {
            return this.services.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, attributeType);
        }
        return Collections.emptyList();
    }

    public ArtifactId getArtifact() {
        return this.artifact;
    }

    public Object getObject() {
        return this.artifact;
    }
}

