/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsWorkItemFactory;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsActionFactory;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.config.TeamDefinitions;
import org.eclipse.osee.ats.core.internal.util.AtsIdProvider;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.ats.core.util.ConvertAtsConfigGuidAttributesOperations;
import org.eclipse.osee.ats.core.workflow.state.StateManagerUtility;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ActionFactory
implements IAtsActionFactory {
    private final IAtsWorkItemFactory workItemFactory;
    private final IAtsActionableItemService actionableItemManager;
    private final IAttributeResolver attrResolver;
    private final IAtsStateFactory stateFactory;
    private final IAtsServices services;
    private IAtsTeamDefinition topTeamDefinition;

    public ActionFactory(IAtsWorkItemFactory workItemFactory, IAtsActionableItemService actionableItemManager, IAttributeResolver attrResolver, IAtsStateFactory stateFactory, IAtsServices atsServices) {
        this.workItemFactory = workItemFactory;
        this.actionableItemManager = actionableItemManager;
        this.attrResolver = attrResolver;
        this.stateFactory = stateFactory;
        this.services = atsServices;
    }

    public ActionResult createAction(IAtsUser user, String title, String desc, ChangeType changeType, String priority, boolean validationRequired, Date needByDate, Collection<IAtsActionableItem> actionableItems, Date createdDate, IAtsUser createdBy, INewActionListener newActionListener, IAtsChangeSet changes) throws OseeCoreException {
        Conditions.checkNotNullOrEmptyOrContainNull(actionableItems, (String)"actionableItems");
        ArtifactId actionArt = changes.createArtifact(AtsArtifactTypes.Action, title);
        IAtsAction action = this.workItemFactory.getAction(actionArt);
        IAtsTeamDefinition topTeamDefinition = this.getTopTeamDef();
        this.setAtsId((IAtsObject)action, topTeamDefinition, changes);
        changes.add((Object)action);
        this.setArtifactIdentifyData((IAtsObject)action, title, desc, changeType, priority, validationRequired, needByDate, changes);
        Collection<IAtsTeamDefinition> teamDefs = TeamDefinitions.getImpactedTeamDefs(actionableItems);
        if (teamDefs.isEmpty()) {
            StringBuffer sb = new StringBuffer("No teams returned for Action's selected Actionable Items\n");
            for (IAtsActionableItem aia : actionableItems) {
                sb.append("Selected AI \"" + aia + "\" " + aia.getId() + "\n");
            }
            throw new OseeStateException(sb.toString(), new Object[0]);
        }
        ArrayList<IAtsTeamWorkflow> teamWfs = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamDefinition teamDef : teamDefs) {
            LinkedList<IAtsUser> leads = new LinkedList<IAtsUser>(teamDef.getLeads(actionableItems));
            if (leads.isEmpty()) {
                leads.add(AtsCoreUsers.UNASSIGNED_USER);
            }
            IAtsTeamWorkflow teamWf = this.createTeamWorkflow(action, teamDef, actionableItems, leads, changes, createdDate, createdBy, newActionListener, new CreateTeamOption[0]);
            teamWfs.add(teamWf);
            changes.add((Object)teamWf);
        }
        if (newActionListener != null) {
            newActionListener.actionCreated(action);
        }
        changes.add((Object)action);
        ActionResult result = new ActionResult(action, teamWfs);
        return result;
    }

    private IAtsTeamDefinition getTopTeamDef() {
        if (this.topTeamDefinition == null) {
            this.topTeamDefinition = TeamDefinitions.getTopTeamDefinition(this.services.getQueryService());
        }
        return this.topTeamDefinition;
    }

    public IAtsTeamWorkflow createTeamWorkflow(IAtsAction action, IAtsTeamDefinition teamDef, Collection<IAtsActionableItem> actionableItems, List<IAtsUser> assignees, IAtsChangeSet changes, Date createdDate, IAtsUser createdBy, INewActionListener newActionListener, CreateTeamOption ... createTeamOption) throws OseeCoreException {
        IArtifactType teamWorkflowArtifactType = this.getTeamWorkflowArtifactType(teamDef);
        IAtsTeamWorkflow teamWf = this.createTeamWorkflow(action, teamDef, actionableItems, assignees, createdDate, createdBy, null, teamWorkflowArtifactType, newActionListener, changes, createTeamOption);
        return teamWf;
    }

    public IArtifactType getTeamWorkflowArtifactType(IAtsTeamDefinition teamDef) throws OseeCoreException {
        return ActionFactory.getTeamWorkflowArtifactType(teamDef, this.services);
    }

    public static IArtifactType getTeamWorkflowArtifactType(IAtsTeamDefinition teamDef, IAtsServices services) throws OseeCoreException {
        String artifactTypeName;
        Conditions.checkNotNull((Object)teamDef, (String)"teamDef");
        IArtifactType teamWorkflowArtifactType = AtsArtifactTypes.TeamWorkflow;
        if (teamDef.getStoreObject() != null && Strings.isValid((String)(artifactTypeName = (String)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeId)AtsAttributeTypes.TeamWorkflowArtifactType, null)))) {
            boolean found = false;
            for (IArtifactType type : services.getArtifactTypes()) {
                if (!type.getName().equals(artifactTypeName)) continue;
                teamWorkflowArtifactType = type;
                found = true;
                break;
            }
            if (!found) {
                throw new OseeArgumentException("Team Workflow Artifact Type name [%s] off Team Definition %s could not be found.", new Object[]{artifactTypeName, teamDef.toStringWithId()});
            }
        }
        return teamWorkflowArtifactType;
    }

    public IAtsTeamWorkflow createTeamWorkflow(IAtsAction action, IAtsTeamDefinition teamDef, Collection<IAtsActionableItem> actionableItems, List<? extends IAtsUser> assignees, Date createdDate, IAtsUser createdBy, String guid, IArtifactType artifactType, INewActionListener newActionListener, IAtsChangeSet changes, CreateTeamOption ... createTeamOption) throws OseeCoreException {
        String workDefinitionName;
        String overrideWorkDefId;
        if (!Arrays.asList(createTeamOption).contains(CreateTeamOption.Duplicate_If_Exists)) {
            for (IAtsTeamWorkflow teamArt : action.getTeamWorkflows()) {
                if (!teamArt.getTeamDefinition().equals(teamDef)) continue;
                throw new OseeArgumentException("Team [%s] already exists for Action [%s]", new Object[]{teamDef, this.services.getAtsId((IAtsObject)action)});
            }
        }
        IAtsTeamWorkflow teamWf = null;
        teamWf = guid == null ? this.workItemFactory.getTeamWf(changes.createArtifact(artifactType, "")) : this.workItemFactory.getTeamWf((ArtifactId)changes.createArtifact(artifactType, "", guid));
        this.setArtifactIdentifyData(action, teamWf, changes);
        for (IAtsActionableItem aia : actionableItems) {
            IAtsTeamDefinition teamDefinitionInherited = aia.getTeamDefinitionInherited();
            if (teamDefinitionInherited == null || !teamDef.getId().equals(teamDefinitionInherited.getId())) continue;
            this.actionableItemManager.addActionableItem((IAtsObject)teamWf, aia, changes);
        }
        changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeId)AtsAttributeTypes.TeamDefinition, AtsUtilCore.getGuid((IAtsObject)teamDef));
        this.setAtsId((IAtsObject)teamWf, teamWf.getTeamDefinition(), changes);
        boolean set = false;
        if (newActionListener != null && Strings.isValid((String)(overrideWorkDefId = newActionListener.getOverrideWorkDefinitionId(teamWf)))) {
            changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, overrideWorkDefId);
            set = true;
        }
        if (!set) {
            for (ITeamWorkflowProvider provider : this.services.getWorkItemService().getTeamWorkflowProviders().getProviders()) {
                String overrideWorkDefId2 = provider.getOverrideWorkflowDefinitionId(teamWf);
                if (!Strings.isValid((String)overrideWorkDefId2)) continue;
                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, overrideWorkDefId2);
            }
        }
        if (!Strings.isValid((String)(workDefinitionName = this.getWorkDefinitionName(teamDef)))) {
            throw new OseeStateException("Work Definition for Team Def [%s] does not exist", new Object[]{teamDef});
        }
        this.initializeNewStateMachine((IAtsWorkItem)teamWf, assignees, createdDate, createdBy, changes);
        if (newActionListener != null) {
            newActionListener.teamCreated(action, teamWf, changes);
        }
        changes.relate((Object)action, AtsRelationTypes.ActionToWorkflow_WorkFlow, (Object)teamWf);
        this.addActionToConfiguredGoal(teamDef, teamWf, actionableItems, changes);
        changes.add((Object)teamWf);
        changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((IAtsUser)AtsCoreUsers.SYSTEM_USER, (IAtsWorkItem)teamWf, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.SubscribedTeamOrAi}));
        changes.addWorkflowCreated(teamWf);
        String createGuidAttrs = this.services.getConfigValue("CreateGuidAttrs");
        if (createGuidAttrs != null && createGuidAttrs.equals("true")) {
            ConvertAtsConfigGuidAttributesOperations.convertActionableItemsIfNeeded(changes, teamWf.getStoreObject(), this.services);
            ConvertAtsConfigGuidAttributesOperations.convertTeamDefinitionIfNeeded(changes, teamWf.getStoreObject(), this.services);
        }
        return teamWf;
    }

    public String getWorkDefinitionName(IAtsTeamDefinition teamDef) throws OseeCoreException {
        String workDefName = this.attrResolver.getSoleAttributeValueAsString((IAtsObject)teamDef, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, null);
        if (Strings.isValid((String)workDefName)) {
            return workDefName;
        }
        IAtsTeamDefinition parentTeamDef = teamDef.getParentTeamDef();
        if (parentTeamDef == null) {
            return "WorkDef_Team_Default";
        }
        return this.getWorkDefinitionName(parentTeamDef);
    }

    public void initializeNewStateMachine(IAtsWorkItem workItem, List<? extends IAtsUser> assignees, Date createdDate, IAtsUser createdBy, IAtsChangeSet changes) throws OseeCoreException {
        this.initializeNewStateMachine(workItem, assignees, createdDate, createdBy, null, changes);
    }

    public void initializeNewStateMachine(IAtsWorkItem workItem, List<? extends IAtsUser> assignees, Date createdDate, IAtsUser createdBy, IAtsWorkDefinition workDefinition, IAtsChangeSet changes) {
        Conditions.checkNotNull((Object)createdDate, (String)"createdDate");
        Conditions.checkNotNull((Object)createdBy, (String)"createdBy");
        Conditions.checkNotNull((Object)changes, (String)"changes");
        IAtsStateDefinition startState = null;
        if (workDefinition == null) {
            startState = workItem.getWorkDefinition().getStartState();
        } else {
            startState = workDefinition.getStartState();
            changes.addAttribute((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, (Object)workDefinition.getName());
        }
        IAtsStateManager stateManager = this.stateFactory.getStateManager(workItem);
        workItem.setStateManager(stateManager);
        StateManagerUtility.initializeStateMachine(workItem.getStateMgr(), (IStateToken)startState, assignees, createdBy == null ? changes.getAsUser() : createdBy, changes);
        IAtsUser user = createdBy == null ? changes.getAsUser() : createdBy;
        this.setCreatedBy(workItem, user, true, createdDate, changes);
        TransitionManager.logStateStartedEvent(workItem, (IStateToken)startState, createdDate, user);
    }

    private void logCreatedByChange(IAtsWorkItem workItem, IAtsUser user, Date date, IAtsUser asUser) throws OseeCoreException {
        if (this.attrResolver.getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy, null) == null) {
            workItem.getLog().addLog(LogType.Originated, "", "", date, user.getUserId());
        } else {
            workItem.getLog().addLog(LogType.Originated, "", "Changed by " + asUser.getName(), date, user.getUserId());
        }
    }

    public void setCreatedBy(IAtsWorkItem workItem, IAtsUser user, boolean logChange, Date date, IAtsChangeSet changes) throws OseeCoreException {
        if (logChange) {
            this.logCreatedByChange(workItem, user, date, changes.getAsUser());
        }
        if (this.attrResolver.isAttributeTypeValid(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy)) {
            changes.setSoleAttributeValue(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedBy, user.getUserId());
        }
        if (this.attrResolver.isAttributeTypeValid(workItem, (AttributeTypeId)AtsAttributeTypes.CreatedDate)) {
            changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.CreatedDate, (Object)date);
        }
        changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((IAtsUser)changes.getAsUser(), (IAtsWorkItem)workItem, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Originator}));
    }

    public void addActionToConfiguredGoal(IAtsTeamDefinition teamDef, IAtsTeamWorkflow teamWf, Collection<IAtsActionableItem> actionableItems, IAtsChangeSet changes) throws OseeCoreException {
        IRelationResolver relationResolver = this.services.getRelationResolver();
        for (IAtsGoal goal : relationResolver.getRelated((IAtsObject)teamDef, AtsRelationTypes.AutoAddActionToGoal_Goal, IAtsGoal.class)) {
            if (relationResolver.areRelated((IAtsObject)goal, AtsRelationTypes.Goal_Member, (IAtsObject)teamWf)) continue;
            changes.relate((Object)goal, AtsRelationTypes.Goal_Member, (Object)teamWf);
            changes.add((Object)goal);
        }
        for (IAtsActionableItem aia : actionableItems) {
            for (IAtsGoal goal : relationResolver.getRelated((IAtsObject)aia, AtsRelationTypes.AutoAddActionToGoal_Goal, IAtsGoal.class)) {
                if (relationResolver.areRelated((IAtsObject)goal, AtsRelationTypes.Goal_Member, (IAtsObject)teamWf)) continue;
                changes.relate((Object)goal, AtsRelationTypes.Goal_Member, (Object)teamWf);
                changes.add((Object)goal);
            }
        }
    }

    public void setArtifactIdentifyData(IAtsAction fromAction, IAtsTeamWorkflow toTeam, IAtsChangeSet changes) throws OseeCoreException {
        Conditions.checkNotNull((Object)fromAction, (String)"fromAction");
        Conditions.checkNotNull((Object)toTeam, (String)"toTeam");
        Conditions.checkNotNull((Object)changes, (String)"changes");
        this.setArtifactIdentifyData((IAtsObject)toTeam, fromAction.getName(), (String)this.attrResolver.getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeId)AtsAttributeTypes.Description, (Object)""), this.services.getChangeType(fromAction), (String)this.attrResolver.getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeId)AtsAttributeTypes.PriorityType, (Object)""), (Boolean)this.attrResolver.getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeId)AtsAttributeTypes.ValidationRequired, (Object)false), (Date)this.attrResolver.getSoleAttributeValue((IAtsObject)fromAction, (AttributeTypeId)AtsAttributeTypes.NeedBy, null), changes);
    }

    public void setArtifactIdentifyData(IAtsObject atsObject, String title, String desc, ChangeType changeType, String priority, Boolean validationRequired, Date needByDate, IAtsChangeSet changes) throws OseeCoreException {
        changes.setSoleAttributeValue(atsObject, (AttributeTypeId)CoreAttributeTypes.Name, (Object)title);
        if (Strings.isValid((String)desc)) {
            changes.addAttribute(atsObject, (AttributeTypeId)AtsAttributeTypes.Description, (Object)desc);
        }
        if (changeType != null) {
            this.services.setChangeType(atsObject, changeType, changes);
        }
        if (Strings.isValid((String)priority)) {
            changes.addAttribute(atsObject, (AttributeTypeId)AtsAttributeTypes.PriorityType, (Object)priority);
        }
        if (needByDate != null) {
            changes.addAttribute(atsObject, (AttributeTypeId)AtsAttributeTypes.NeedBy, (Object)needByDate);
        }
        if (validationRequired.booleanValue()) {
            changes.addAttribute(atsObject, (AttributeTypeId)AtsAttributeTypes.ValidationRequired, (Object)true);
        }
    }

    public Collection<IAtsTeamWorkflow> getSiblingTeamWorkflows(IAtsTeamWorkflow teamWf) {
        LinkedList<IAtsTeamWorkflow> teams = new LinkedList<IAtsTeamWorkflow>();
        IAtsAction action = this.getAction(teamWf);
        for (IAtsTeamWorkflow teamChild : this.services.getRelationResolver().getRelated((IAtsObject)action, AtsRelationTypes.ActionToWorkflow_WorkFlow, IAtsTeamWorkflow.class)) {
            if (teamChild.equals(teamWf)) continue;
            teams.add(teamChild);
        }
        return teams;
    }

    public IAtsAction getAction(IAtsTeamWorkflow teamWf) {
        return (IAtsAction)this.services.getRelationResolver().getRelatedOrNull((IAtsObject)teamWf, AtsRelationTypes.ActionToWorkflow_Action, IAtsAction.class);
    }

    public void setAtsId(IAtsObject newObject, IAtsTeamDefinition teamDef, IAtsChangeSet changes) {
        new AtsIdProvider(this.services.getSequenceProvider(), this.services.getAttributeResolver(), newObject, teamDef).setAtsId(changes);
    }
}

