/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.workdef.IRelationResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public abstract class AbstractRelationResolverServiceImpl
implements IRelationResolver {
    public Collection<ArtifactToken> getChildren(ArtifactId artifact, IArtifactType artifactType) {
        return this.getRelated(artifact, CoreRelationTypes.Default_Hierarchical__Child, artifactType);
    }

    public Collection<ArtifactToken> getRelated(IAtsObject atsObject, RelationTypeSide relationTypeSide) {
        return this.getRelated((ArtifactId)atsObject.getStoreObject(), relationTypeSide);
    }

    public abstract ArtifactId getArtifact(Object var1);

    public Collection<ArtifactToken> getRelatedArtifacts(IAtsWorkItem workItem, RelationTypeSide relationTypeSide) {
        ArtifactId artifact = this.getArtifact(workItem);
        return Collections.castAll((Collection)this.getRelated(artifact, relationTypeSide));
    }

    public Collection<ArtifactToken> getChildren(ArtifactId artifact) {
        return this.getRelated(artifact, CoreRelationTypes.Default_Hierarchical__Child);
    }

    public ArtifactToken getParent(ArtifactId artifact) {
        return this.getRelatedOrNull(artifact, CoreRelationTypes.Default_Hierarchical__Parent);
    }
}

