/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IExecuteListener;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsRelationChange;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public abstract class AbstractAtsChangeSet
implements IAtsChangeSet {
    protected String comment;
    protected final Set<AtsRelationChange> relations = new CopyOnWriteArraySet<AtsRelationChange>();
    protected final Set<IAtsObject> atsObjects = new CopyOnWriteArraySet<IAtsObject>();
    protected final Set<ArtifactId> artifacts = new CopyOnWriteArraySet<ArtifactId>();
    protected final Set<IAtsObject> deleteAtsObjects = new CopyOnWriteArraySet<IAtsObject>();
    protected final Set<ArtifactId> deleteArtifacts = new CopyOnWriteArraySet<ArtifactId>();
    protected final Set<IExecuteListener> listeners = new CopyOnWriteArraySet<IExecuteListener>();
    protected final IAtsUser asUser;
    protected final AtsNotificationCollector notifications = new AtsNotificationCollector();
    protected final List<IAtsWorkItem> workItemsCreated = new ArrayList<IAtsWorkItem>();
    protected boolean execptionIfEmpty = true;

    public AbstractAtsChangeSet(String comment, IAtsUser asUser) {
        this.comment = comment;
        this.asUser = asUser;
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        Conditions.checkNotNull((Object)asUser, (String)"user");
    }

    public void add(Object obj) throws OseeCoreException {
        Conditions.checkNotNull((Object)obj, (String)"object");
        if (obj instanceof Collection) {
            for (Object object : (Collection)obj) {
                this.add(object);
            }
        } else if (obj instanceof IAtsObject) {
            this.atsObjects.add((IAtsObject)obj);
        } else if (obj instanceof ArtifactId) {
            this.artifacts.add((ArtifactId)obj);
        } else if (obj instanceof AtsRelationChange) {
            this.relations.add((AtsRelationChange)obj);
        } else {
            throw new OseeArgumentException("Object not supported: " + obj, new Object[0]);
        }
    }

    public void addAll(Object ... objects) throws OseeCoreException {
        Conditions.checkNotNull((Object)objects, (String)"objects");
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.add(obj);
            ++n2;
        }
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void clear() {
        this.relations.clear();
        this.atsObjects.clear();
        this.artifacts.clear();
        this.deleteArtifacts.clear();
        this.deleteAtsObjects.clear();
        this.listeners.clear();
    }

    public void reset(String comment) {
        this.clear();
        this.comment = comment;
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.deleteArtifacts.isEmpty() && this.atsObjects.isEmpty() && this.deleteAtsObjects.isEmpty() && this.relations.isEmpty();
    }

    public void addExecuteListener(IExecuteListener listener) {
        Conditions.checkNotNull((Object)listener, (String)"listener");
        this.listeners.add(listener);
    }

    public void addToDelete(Object obj) throws OseeCoreException {
        Conditions.checkNotNull((Object)obj, (String)"object");
        if (obj instanceof Collection) {
            for (Object object : (Collection)obj) {
                this.add(object);
            }
        } else if (obj instanceof IAtsObject) {
            this.deleteAtsObjects.add((IAtsObject)obj);
        } else if (obj instanceof ArtifactId) {
            this.deleteArtifacts.add((ArtifactId)obj);
        } else {
            throw new OseeArgumentException("Object not supported: " + obj, new Object[0]);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public AtsNotificationCollector getNotifications() {
        return this.notifications;
    }

    public ArtifactId createArtifact(ArtifactToken token) {
        return this.createArtifact(token.getArtifactType(), token.getName(), (String)token.getGuid(), token.getId());
    }

    public void deleteArtifact(IAtsWorkItem task) {
        this.deleteArtifact((ArtifactId)task.getStoreObject());
    }

    public void addWorkflowCreated(IAtsTeamWorkflow teamWf) {
        this.workItemsCreated.add((IAtsWorkItem)teamWf);
    }

    public void executeIfNeeded() {
        this.execptionIfEmpty = false;
        this.execute();
    }

    public IAtsUser getAsUser() {
        return this.asUser;
    }

    public void unrelate(IAtsObject atsObject, RelationTypeSide relationSide, IAtsObject atsObjec2) {
        this.unrelate((ArtifactId)atsObject.getStoreObject(), relationSide, (ArtifactId)atsObjec2.getStoreObject());
    }

    public void unrelate(ArtifactId artifact, RelationTypeSide relationSide, IAtsObject atsObject) {
        this.unrelate(artifact, relationSide, (ArtifactId)atsObject.getStoreObject());
    }

    public void unrelate(IAtsObject atsObject, RelationTypeSide relationSide, ArtifactId artifact) {
        this.unrelate((ArtifactId)atsObject.getStoreObject(), relationSide, artifact);
    }

    public void setSoleAttributeFromString(IAtsObject atsObject, AttributeTypeId attributeType, String value) {
        this.setSoleAttributeFromString((ArtifactId)atsObject.getStoreObject(), attributeType, value);
    }

    public void setRelation(Object object1, RelationTypeSide relationSide, Object object2) {
        this.setRelations(object1, relationSide, Collections.singleton(object2));
    }

    public void addChild(ArtifactId parent, ArtifactId child) {
        this.relate(parent, CoreRelationTypes.Default_Hierarchical__Child, child);
    }

    public void setName(ArtifactToken artifact, String name) {
        this.setSoleAttributeValue((ArtifactId)artifact, (AttributeTypeId)CoreAttributeTypes.Name, name);
    }

    public void setName(IAtsObject atsObject, String name) {
        this.setSoleAttributeValue(atsObject, (AttributeTypeId)CoreAttributeTypes.Name, name);
    }

    public void addWorkItemNotificationEvent(AtsWorkItemNotificationEvent workItemNotificationEvent) {
        this.notifications.getWorkItemNotificationEvents().add(workItemNotificationEvent);
    }

    public void addNotificationEvent(AtsNotificationEvent notifyEvent) {
        this.notifications.getNotificationEvents().add(notifyEvent);
    }

    public List<IAtsWorkItem> getWorkItemsCreated() {
        return this.workItemsCreated;
    }
}

