/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.commit.CommitStatus;
import org.eclipse.osee.ats.api.commit.ICommitConfigItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.workflow.IAtsBranchService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.config.Versions;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IOseeBranch;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsBranchService
implements IAtsBranchService {
    protected static Map<String, IOseeBranch> idToWorkingBranchCache = new HashMap<String, IOseeBranch>();
    protected static Map<String, Long> idToWorkingBranchCacheUpdated = new HashMap<String, Long>(50);
    protected IAtsServices services;
    private static final int SHORT_NAME_LIMIT = 35;
    private static Set<BranchId> branchesInCommit = new HashSet<BranchId>();
    private ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy;

    public AbstractAtsBranchService() {
    }

    public AbstractAtsBranchService(IAtsServices services, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        this.services = services;
        this.teamWorkflowProvidersLazy = teamWorkflowProvidersLazy;
    }

    public boolean isWorkingBranchEverCommitted(IAtsTeamWorkflow teamWf) {
        return this.getBranchesCommittedTo(teamWf).size() > 0;
    }

    public Collection<BranchId> getBranchesToCommitTo(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        HashSet<BranchId> branches = new HashSet<BranchId>();
        for (ICommitConfigItem obj : this.getConfigArtifactsConfiguredToCommitTo(teamWf)) {
            if (!this.isBranchValid(obj)) continue;
            branches.add(this.getBranch(obj));
        }
        return branches;
    }

    public IOseeBranch getWorkingBranch(IAtsTeamWorkflow teamWf, boolean force) {
        boolean notSet;
        long now = new Date().getTime();
        boolean bl = notSet = idToWorkingBranchCacheUpdated.get(teamWf.getAtsId()) == null;
        if (AtsUtilCore.isInTest() || notSet || force || now - idToWorkingBranchCacheUpdated.get(teamWf.getAtsId()) > 1000L) {
            IOseeBranch branch = IOseeBranch.SENTINEL;
            try {
                IOseeBranch workingBranch = this.getWorkingBranchExcludeStates(teamWf, new BranchState[]{BranchState.REBASELINED, BranchState.DELETED, BranchState.PURGED, BranchState.COMMIT_IN_PROGRESS, BranchState.CREATION_IN_PROGRESS, BranchState.DELETE_IN_PROGRESS, BranchState.PURGE_IN_PROGRESS});
                branch = workingBranch == null ? IOseeBranch.SENTINEL : workingBranch;
            }
            catch (ItemDoesNotExist itemDoesNotExist) {}
            idToWorkingBranchCache.put(teamWf.getAtsId(), branch);
            idToWorkingBranchCacheUpdated.put(teamWf.getAtsId(), now);
        }
        return idToWorkingBranchCache.get(teamWf.getAtsId());
    }

    public BranchId getConfiguredBranchForWorkflow(IAtsTeamWorkflow teamWf) {
        IAtsVersion verArt;
        BranchId parentBranch = BranchId.SENTINEL;
        if (teamWf.getTeamDefinition().isTeamUsesVersions() && (verArt = this.services.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf)) != null) {
            parentBranch = this.getBranch((IAtsConfigObject)verArt);
        }
        if (parentBranch.isInvalid() && teamWf.isTeamWorkflow() && this.isBranchValid((ICommitConfigItem)teamWf.getTeamDefinition())) {
            parentBranch = this.getBranch((IAtsConfigObject)teamWf.getTeamDefinition());
        }
        return parentBranch;
    }

    public CommitStatus getCommitStatus(IAtsTeamWorkflow teamWf, BranchId destinationBranch) {
        CommitStatus commitStatus = this.getCommitStatus(teamWf, destinationBranch, null);
        return commitStatus;
    }

    public TransactionRecord getCommitTransactionRecord(IAtsTeamWorkflow teamWf, BranchId branch) {
        if (branch.isInvalid()) {
            return TransactionRecord.SENTINEL;
        }
        Collection transactions = this.getCommittedArtifactTransactionIds(teamWf);
        for (TransactionRecord transId : transactions) {
            if (!transId.isOnBranch(branch)) continue;
            return transId;
        }
        return TransactionRecord.SENTINEL;
    }

    public ICommitConfigItem getParentBranchConfigArtifactConfiguredToCommitTo(IAtsTeamWorkflow teamWf) {
        if (teamWf.getTeamDefinition().isTeamUsesVersions()) {
            if (this.services.getVersionService().hasTargetedVersion((IAtsWorkItem)teamWf)) {
                return this.services.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf);
            }
        } else if (teamWf.isTeamWorkflow() && this.isBranchValid((ICommitConfigItem)teamWf.getTeamDefinition())) {
            return teamWf.getTeamDefinition();
        }
        return null;
    }

    public TransactionToken getEarliestTransactionId(IAtsTeamWorkflow teamWf) {
        TransactionToken earliestTransactionId;
        Collection<TransactionRecord> transactionIds = this.getTransactionIds(teamWf, false);
        if (transactionIds.isEmpty()) {
            earliestTransactionId = TransactionToken.SENTINEL;
        } else {
            earliestTransactionId = (TransactionToken)transactionIds.iterator().next();
            for (TransactionToken transactionToken : transactionIds) {
                if (!transactionToken.isOlderThan((TransactionId)earliestTransactionId)) continue;
                earliestTransactionId = transactionToken;
            }
        }
        return earliestTransactionId;
    }

    public boolean isBranchesAllCommittedExcept(IAtsTeamWorkflow teamWf, BranchId branchToExclude) {
        Collection<BranchId> committedTo = this.getBranchesCommittedTo(teamWf);
        for (BranchId destBranch : this.getBranchesToCommitTo(teamWf)) {
            if (destBranch.equals(branchToExclude) || committedTo.contains(destBranch) || this.isNoCommitNeeded(teamWf, destBranch)) continue;
            return false;
        }
        return true;
    }

    public Collection<BranchId> getBranchesCommittedTo(IAtsTeamWorkflow teamWf) {
        HashSet<BranchId> branches = new HashSet<BranchId>();
        for (TransactionToken transactionToken : this.getTransactionIds(teamWf, false)) {
            branches.add(transactionToken.getBranch());
        }
        return branches;
    }

    public Collection<BranchId> getBranchesLeftToCommit(IAtsTeamWorkflow teamWf) {
        HashSet<BranchId> branchesLeft = new HashSet<BranchId>();
        Collection<BranchId> committedTo = this.getBranchesCommittedTo(teamWf);
        for (BranchId branchToCommit : this.getBranchesToCommitTo(teamWf)) {
            if (committedTo.contains(branchToCommit) || this.isNoCommitNeeded(teamWf, branchToCommit)) continue;
            branchesLeft.add(branchToCommit);
        }
        return branchesLeft;
    }

    public CommitStatus getCommitStatus(IAtsTeamWorkflow teamWf, ICommitConfigItem configArt) {
        return this.getCommitStatus((IAtsTeamWorkflow)teamWf.getStoreObject(), this.getBranch(configArt), null);
    }

    public boolean isBranchInCommit(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        if (!this.isWorkingBranchInWork(teamWf)) {
            return false;
        }
        return branchesInCommit.contains(this.getWorkingBranch(teamWf));
    }

    public Collection<ICommitConfigItem> getConfigArtifactsConfiguredToCommitTo(IAtsTeamWorkflow teamWf) {
        HashSet<ICommitConfigItem> configObjects = new HashSet<ICommitConfigItem>();
        if (teamWf.getTeamDefinition().isTeamUsesVersions()) {
            if (this.services.getVersionService().hasTargetedVersion((IAtsWorkItem)teamWf)) {
                Versions.getParallelVersions(this.services.getVersionService().getTargetedVersion((IAtsWorkItem)teamWf), configObjects, this.services);
            }
        } else if (teamWf.isTeamWorkflow() && this.isBranchValid((ICommitConfigItem)teamWf.getTeamDefinition())) {
            configObjects.add((ICommitConfigItem)teamWf.getTeamDefinition());
        }
        return configObjects;
    }

    public Collection<TransactionRecord> getCommitTransactionsToUnarchivedBaselineBranchs(IAtsTeamWorkflow teamWf) {
        ArrayList<TransactionRecord> transactionIds = new ArrayList<TransactionRecord>();
        for (TransactionRecord transactionId : this.getCommittedArtifactTransactionIds(teamWf)) {
            BranchId branch = transactionId.getBranch();
            if (!this.getBranchType(branch).isBaselineBranch() || this.isArchived(branch)) continue;
            transactionIds.add(transactionId);
        }
        return transactionIds;
    }

    public boolean isNoCommitNeeded(IAtsTeamWorkflow teamWf, BranchId destinationBranch) throws OseeCoreException {
        return this.getCommitStatus(teamWf, destinationBranch) == CommitStatus.No_Commit_Needed;
    }

    public boolean isBranchesAllCommitted(IAtsTeamWorkflow teamWf) {
        Collection<BranchId> committedTo = this.getBranchesCommittedTo(teamWf);
        for (BranchId destBranch : this.getBranchesToCommitTo(teamWf)) {
            if (committedTo.contains(destBranch) || this.isNoCommitNeeded(teamWf, destBranch)) continue;
            return false;
        }
        return true;
    }

    public IOseeBranch getWorkingBranch(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        return this.getWorkingBranch(teamWf, false);
    }

    public boolean isCommittedBranchExists(IAtsTeamWorkflow teamWf) {
        return !this.getBranchesCommittedTo(teamWf).isEmpty();
    }

    public boolean isAllObjectsToCommitToConfigured(IAtsTeamWorkflow teamWf) {
        Collection<ICommitConfigItem> configs = this.getConfigArtifactsConfiguredToCommitTo(teamWf);
        for (ICommitConfigItem config : configs) {
            if (!this.isBranchValid(config)) {
                return false;
            }
            if (this.branchExists(config.getBaselineBranchId())) continue;
            return false;
        }
        return true;
    }

    public String getBranchShortName(ICommitConfigItem commitConfigItem) {
        return Strings.truncate((String)commitConfigItem.getName(), (int)35);
    }

    public boolean isWorkingBranchInWork(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        IOseeBranch branch = this.getWorkingBranch(teamWf);
        return branch.isValid() && !this.getBranchState((BranchId)branch).isCommitted();
    }

    public BranchId getBranch(IAtsConfigObject configObject) {
        IAtsTeamDefinition teamDef;
        IAtsVersion version;
        BranchId branch = BranchId.SENTINEL;
        if (configObject instanceof IAtsVersion && (version = (IAtsVersion)configObject).getBaselineBranchId().isValid()) {
            branch = version.getBaselineBranchId();
        }
        if (branch.isInvalid() && configObject instanceof IAtsTeamDefinition && (teamDef = (IAtsTeamDefinition)configObject).getBaselineBranchId().isValid()) {
            branch = teamDef.getBaselineBranchId();
        }
        if (branch.isInvalid()) {
            branch = BranchId.valueOf((long)((Long)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)configObject, (AttributeTypeId)AtsAttributeTypes.BaselineBranchUuid, (Object)BranchId.SENTINEL.getId())));
        }
        return branch;
    }

    public IOseeBranch getBranch(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        return this.getWorkingBranch(teamWf, false);
    }

    public BranchId getBranch(ICommitConfigItem configObject) {
        return this.getBranch((IAtsConfigObject)configObject);
    }

    public boolean isBranchValid(ICommitConfigItem configObject) {
        boolean validBranch = false;
        if (configObject.getBaselineBranchId().isValid()) {
            validBranch = true;
        }
        return validBranch;
    }

    public Collection<Object> combineCommitTransactionsAndConfigItems(Collection<ICommitConfigItem> configArtSet, Collection<TransactionRecord> commitTxs) throws OseeCoreException {
        HashSet<Object> commitMgrInputObjs = new HashSet<Object>();
        commitMgrInputObjs.addAll(configArtSet);
        for (TransactionToken transactionToken : commitTxs) {
            boolean isCommitAlreadyPresent = false;
            for (ICommitConfigItem configArt : configArtSet) {
                BranchId configArtBranch = this.getBranch(configArt);
                if (!transactionToken.isOnBranch(configArtBranch)) continue;
                isCommitAlreadyPresent = true;
                break;
            }
            if (isCommitAlreadyPresent) continue;
            commitMgrInputObjs.add(transactionToken);
        }
        return commitMgrInputObjs;
    }

    public Collection<Object> getCommitTransactionsAndConfigItemsForTeamWf(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        Collection<ICommitConfigItem> configArtSet = this.getConfigArtifactsConfiguredToCommitTo(teamWf);
        Collection<TransactionRecord> commitTxs = this.getCommitTransactionsToUnarchivedBaselineBranchs(teamWf);
        Collection<Object> commitMgrInputObjs = this.combineCommitTransactionsAndConfigItems(configArtSet, commitTxs);
        return commitMgrInputObjs;
    }

    public Result isCommitBranchAllowed(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        if (!teamWf.isTeamWorkflow()) {
            return Result.FalseResult;
        }
        if (teamWf.getTeamDefinition().isTeamUsesVersions()) {
            IAtsVersionService versionService = this.services.getVersionService();
            if (!versionService.hasTargetedVersion((IAtsWorkItem)teamWf)) {
                return new Result(false, "Workflow not targeted for Version");
            }
            IAtsVersion targetedVersion = versionService.getTargetedVersion((IAtsWorkItem)teamWf);
            Result result = targetedVersion.isAllowCommitBranchInherited();
            if (result.isFalse()) {
                return result;
            }
            if (!this.isBranchValid((ICommitConfigItem)targetedVersion)) {
                return new Result(false, "Parent Branch not configured for Version [" + targetedVersion + "]");
            }
            return Result.TrueResult;
        }
        Result result = teamWf.getTeamDefinition().isAllowCommitBranchInherited();
        if (result.isFalse()) {
            return result;
        }
        if (!this.isBranchValid((ICommitConfigItem)teamWf.getTeamDefinition())) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + teamWf.getTeamDefinition() + "]");
        }
        return Result.TrueResult;
    }

    public Result isCreateBranchAllowed(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        if (!teamWf.isTeamWorkflow()) {
            return Result.FalseResult;
        }
        if (teamWf.getTeamDefinition().isTeamUsesVersions()) {
            IAtsVersionService versionService = this.services.getVersionService();
            if (!versionService.hasTargetedVersion((IAtsWorkItem)teamWf)) {
                return new Result(false, "Workflow not targeted for Version");
            }
            IAtsVersion targetedVersion = versionService.getTargetedVersion((IAtsWorkItem)teamWf);
            Result result = targetedVersion.isAllowCreateBranchInherited();
            if (result.isFalse()) {
                return result;
            }
            if (!this.isBranchValid((ICommitConfigItem)targetedVersion)) {
                return new Result(false, "Parent Branch not configured for Version [" + targetedVersion + "]");
            }
            BranchId baselineBranch = this.getBranch((IAtsConfigObject)targetedVersion);
            if (!this.getBranchType(baselineBranch).isBaselineBranch()) {
                return new Result(false, "Parent Branch must be of Baseline branch type.  See Admin for configuration.");
            }
            return Result.TrueResult;
        }
        Result result = teamWf.getTeamDefinition().isAllowCreateBranchInherited();
        if (result.isFalse()) {
            return result;
        }
        if (!this.isBranchValid((ICommitConfigItem)teamWf.getTeamDefinition())) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + teamWf.getTeamDefinition() + "]");
        }
        BranchId baselineBranch = this.getBranch((IAtsConfigObject)teamWf.getTeamDefinition());
        if (!this.getBranchType(baselineBranch).isBaselineBranch()) {
            return new Result(false, "Parent Branch must be of Baseline branch type.  See Admin for configuration.");
        }
        return Result.TrueResult;
    }

    public CommitStatus getCommitStatus(IAtsTeamWorkflow teamWf, BranchId destinationBranch, ICommitConfigItem configArt) {
        IOseeBranch workingBranch = this.getWorkingBranch(teamWf);
        if (workingBranch.isValid() && this.getBranchState((BranchId)workingBranch).isRebaselineInProgress()) {
            return CommitStatus.Rebaseline_In_Progress;
        }
        if (destinationBranch.isInvalid()) {
            return CommitStatus.Branch_Not_Configured;
        }
        Collection transactions = this.getCommittedArtifactTransactionIds(teamWf);
        boolean mergeBranchExists = this.isMergeBranchExists(teamWf, destinationBranch);
        for (TransactionToken transId : transactions) {
            if (!transId.isOnBranch(destinationBranch)) continue;
            if (mergeBranchExists) {
                return CommitStatus.Committed_With_Merge;
            }
            return CommitStatus.Committed;
        }
        if (this.workingBranchCommittedToDestinationBranchParentPriorToDestinationBranchCreation(teamWf, destinationBranch, transactions)) {
            return CommitStatus.No_Commit_Needed;
        }
        Result result = new Result(false);
        result = configArt == null ? this.isCommitBranchAllowed(teamWf) : configArt.isAllowCommitBranchInherited();
        if (result.isFalse()) {
            return CommitStatus.Branch_Commit_Disabled;
        }
        if (this.getWorkingBranch(teamWf).isInvalid()) {
            return CommitStatus.Working_Branch_Not_Created;
        }
        if (mergeBranchExists) {
            return CommitStatus.Merge_In_Progress;
        }
        return CommitStatus.Commit_Needed;
    }

    public Collection<TransactionRecord> getTransactionIds(IAtsTeamWorkflow teamWf, boolean forMergeBranches) {
        if (forMergeBranches) {
            IOseeBranch workingBranch = this.getWorkingBranch(teamWf);
            ArrayList<TransactionRecord> transactionIds = new ArrayList<TransactionRecord>();
            for (TransactionRecord transactionId : this.getCommitTransactionsToUnarchivedBaselineBranchs(teamWf)) {
                if (!this.isMergeBranchExists(teamWf, (BranchId)workingBranch, transactionId.getBranch())) continue;
                transactionIds.add(transactionId);
            }
            return transactionIds;
        }
        return this.getCommitTransactionsToUnarchivedBaselineBranchs(teamWf);
    }

    public boolean isMergeBranchExists(IAtsTeamWorkflow teamWf, BranchId destinationBranch) throws OseeCoreException {
        return this.isMergeBranchExists(teamWf, (BranchId)this.getWorkingBranch(teamWf), destinationBranch);
    }

    public Set<BranchId> getBranchesInCommit() {
        return branchesInCommit;
    }

    public boolean workingBranchCommittedToDestinationBranchParentPriorToDestinationBranchCreation(IAtsTeamWorkflow teamWf, BranchId destinationBranch, Collection<? extends TransactionToken> commitTransactionIds) throws OseeCoreException {
        BranchId destinationBranchParent = this.getParentBranch(destinationBranch);
        if (this.getBranchType(destinationBranchParent) == BranchType.SYSTEM_ROOT) {
            return false;
        }
        TransactionToken committedToParentTransRecord = null;
        for (TransactionToken transactionToken : commitTransactionIds) {
            if (!transactionToken.isOnBranch(destinationBranchParent)) continue;
            committedToParentTransRecord = transactionToken;
            break;
        }
        if (committedToParentTransRecord != null && committedToParentTransRecord.isOlderThan((TransactionId)this.getBaseTransaction(destinationBranch))) {
            return true;
        }
        return this.workingBranchCommittedToDestinationBranchParentPriorToDestinationBranchCreation(teamWf, destinationBranchParent, commitTransactionIds);
    }

    public String getBranchName(IAtsTeamWorkflow teamWf) {
        String typeName;
        String defaultBranchName = null;
        String smaTitle = teamWf.getName();
        if (smaTitle.length() > 40) {
            smaTitle = String.valueOf(smaTitle.substring(0, 39)) + "...";
        }
        defaultBranchName = Strings.isValid((String)(typeName = this.services.getWorkItemService().getArtifactTypeShortName(teamWf))) ? String.format("%s - %s - %s", teamWf.getAtsId(), typeName, smaTitle) : String.format("%s - %s", teamWf.getAtsId(), smaTitle);
        for (ITeamWorkflowProvider teamExtension : this.teamWorkflowProvidersLazy.getProviders()) {
            String name = teamExtension.getBranchName(teamWf, defaultBranchName);
            if (!Strings.isValid((String)name)) continue;
            defaultBranchName = name;
            break;
        }
        defaultBranchName = Strings.truncate((String)defaultBranchName, (int)195, (boolean)true);
        return defaultBranchName;
    }

    public BranchId getWorkingBranchInWork(IAtsTeamWorkflow teamWf) {
        IOseeBranch branch = this.getWorkingBranch(teamWf);
        if (branch != null && (this.getBranchState((BranchId)branch).isCreated() || this.getBranchState((BranchId)branch).isModified())) {
            return branch;
        }
        return BranchId.SENTINEL;
    }
}

