/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public final class AtsUsersUtility {
    private static final Pattern addressPattern = Pattern.compile(".+?@.+?\\.[a-z]+");

    private AtsUsersUtility() {
    }

    public static Collection<IAtsUser> getValidEmailUsers(Collection<? extends IAtsUser> users) throws OseeCoreException {
        HashSet<IAtsUser> validUsers = new HashSet<IAtsUser>();
        for (IAtsUser iAtsUser : users) {
            if (!AtsUsersUtility.isEmailValid(iAtsUser.getEmail())) continue;
            validUsers.add(iAtsUser);
        }
        return validUsers;
    }

    public static Collection<IAtsUser> getActiveEmailUsers(Collection<? extends IAtsUser> users) throws OseeCoreException {
        HashSet<IAtsUser> activeUsers = new HashSet<IAtsUser>();
        for (IAtsUser iAtsUser : users) {
            if (!iAtsUser.isActive()) continue;
            activeUsers.add(iAtsUser);
        }
        return activeUsers;
    }

    public static boolean isEmailValid(String email) {
        if (Strings.isValid((String)email)) {
            return addressPattern.matcher(email).matches();
        }
        return false;
    }

    public static Collection<? extends IAtsUser> getUsers(Collection<String> userIds, IAtsUserService userService) {
        HashSet<IAtsUser> users = new HashSet<IAtsUser>();
        for (String userId : userIds) {
            users.add(userService.getUserById(userId));
        }
        return users;
    }
}

