/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class AtsUser
extends NamedIdBase
implements IAtsUser {
    private String userId;
    private final String email;
    private final boolean isActive;

    public AtsUser(UserToken user) {
        this(user.getId(), user.getName(), user.getUserId(), user.getEmail(), user.isActive());
    }

    public AtsUser(Long id, String name, String userId, String email, boolean isActive) {
        super(id, name);
        this.userId = userId;
        this.email = email;
        this.isActive = isActive;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String toString() {
        return String.format("User [%s - %s - %s]", this.getName(), this.getUserId(), this.getEmail());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        String objUserId;
        String thisUserId;
        block7: {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IAtsUser)) {
                return false;
            }
            try {
                thisUserId = this.getUserId();
                objUserId = ((IAtsUser)obj).getUserId();
                if (thisUserId != null) break block7;
                if (objUserId != null) {
                    return false;
                }
            }
            catch (OseeCoreException oseeCoreException) {
                return false;
            }
        }
        if (!thisUserId.equals(objUserId)) {
            return false;
        }
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public IArtifactType getArtifactType() {
        return CoreArtifactTypes.User;
    }

    public boolean isOfType(ArtifactTypeId ... artifactTypes) {
        return Collections.asHashSet((Object[])artifactTypes).contains(this.getArtifactType());
    }
}

