/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.core.users.AtsUser;
import org.eclipse.osee.framework.core.enums.SystemUser;

public final class AtsCoreUsers {
    public static final IAtsUser SYSTEM_USER = new AtsUser(SystemUser.OseeSystem);
    public static final IAtsUser ANONYMOUS_USER = new AtsUser(SystemUser.Anonymous);
    public static final IAtsUser UNASSIGNED_USER = new AtsUser(SystemUser.UnAssigned);

    private AtsCoreUsers() {
    }

    public static boolean isSystemUser(IAtsUser user) {
        return SYSTEM_USER.equals(user);
    }

    public static boolean isGuestUser(IAtsUser user) {
        return ANONYMOUS_USER.equals(user);
    }

    public static boolean isUnAssignedUser(IAtsUser user) {
        return UNASSIGNED_USER.equals(user);
    }

    public static boolean isAtsCoreUserId(String userId) {
        return AtsCoreUsers.getAtsCoreUserByUserId(userId) != null;
    }

    public static boolean isAtsCoreUser(IAtsUser user) {
        return SYSTEM_USER.equals(user) || ANONYMOUS_USER.equals(user) || UNASSIGNED_USER.equals(user);
    }

    public static IAtsUser getAtsCoreUserByUserId(String userId) {
        IAtsUser toReturn = null;
        if (SystemUser.OseeSystem.getUserId().equals(userId)) {
            toReturn = SYSTEM_USER;
        } else if (SystemUser.Anonymous.getUserId().equals(userId)) {
            toReturn = ANONYMOUS_USER;
        } else if (SystemUser.UnAssigned.equals(userId)) {
            toReturn = UNASSIGNED_USER;
        }
        return toReturn;
    }
}

