/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.users;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.AtsUserNameComparator;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsUserService
implements IAtsUserService {
    protected final Map<Long, IAtsUser> accountIdToAtsUser = new ConcurrentHashMap<Long, IAtsUser>(300);
    protected final Map<String, IAtsUser> userIdToAtsUser = new ConcurrentHashMap<String, IAtsUser>(300);
    protected final Map<String, IAtsUser> nameToAtsUser = new ConcurrentHashMap<String, IAtsUser>(300);
    protected IAtsUser currentUser = null;

    public IAtsUser getCurrentUser() throws OseeCoreException {
        if (this.currentUser == null) {
            this.currentUser = this.userIdToAtsUser.get(this.getCurrentUserId());
            if (this.currentUser == null) {
                for (IAtsUser user : this.getUsers(Active.Both)) {
                    if (!user.getUserId().equals(this.getCurrentUserId())) continue;
                    this.currentUser = user;
                    break;
                }
            }
            if (this.currentUser == null) {
                this.currentUser = this.loadUserFromDbByUserId(this.getCurrentUserId());
            }
        }
        return this.currentUser;
    }

    public Collection<IAtsUser> getUsersByUserIds(Collection<String> userIds) throws OseeCoreException {
        LinkedList<IAtsUser> users = new LinkedList<IAtsUser>();
        for (String userId : userIds) {
            IAtsUser user = this.getUserById(userId);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public IAtsUser getUserById(String userId) throws OseeCoreException {
        IAtsUser atsUser = null;
        if (Strings.isValid((String)userId) && (atsUser = this.userIdToAtsUser.get(userId)) == null && Strings.isValid((String)userId) && (atsUser = AtsCoreUsers.getAtsCoreUserByUserId(userId)) == null && (atsUser = this.loadUserFromDbByUserId(userId)) != null) {
            this.userIdToAtsUser.put(userId, atsUser);
        }
        return atsUser;
    }

    public IAtsUser getUserByAccountId(Long accountId) throws OseeCoreException {
        IAtsUser atsUser = this.accountIdToAtsUser.get(accountId);
        if (atsUser == null && (atsUser = this.loadUserByAccountId(accountId)) != null) {
            this.accountIdToAtsUser.put(accountId, atsUser);
        }
        return atsUser;
    }

    protected abstract IAtsUser loadUserByAccountId(Long var1);

    protected abstract IAtsUser loadUserFromDbByUserId(String var1);

    public IAtsUser getUserByName(String name) throws OseeCoreException {
        IAtsUser atsUser = this.nameToAtsUser.get(name);
        if (atsUser == null && Strings.isValid((String)name) && (atsUser = this.loadUserFromDbByUserName(name)) != null) {
            this.nameToAtsUser.put(name, atsUser);
        }
        return atsUser;
    }

    protected abstract IAtsUser loadUserFromDbByUserName(String var1);

    public boolean isUserIdValid(String userId) throws OseeCoreException {
        return this.getUserById(userId) != null;
    }

    public boolean isUserNameValid(String name) throws OseeCoreException {
        return this.getUserByName(name) != null;
    }

    public List<IAtsUser> getUsersSortedByName(Active active) {
        List<IAtsUser> users = this.getUsers(active);
        Collections.sort(users, new AtsUserNameComparator(false));
        return users;
    }

    public IAtsUser getUserFromToken(UserToken userToken) {
        return this.getUserById(userToken.getUserId());
    }

    public abstract String getCurrentUserId();

    public abstract boolean isAtsAdmin(IAtsUser var1);

    public abstract List<? extends IAtsUser> getUsers();

    public List<IAtsUser> getUsers(Active active) {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        for (IAtsUser iAtsUser : this.getUsers()) {
            if (active != Active.Both && (active != Active.Active || !iAtsUser.isActive()) && (active != Active.InActive || iAtsUser.isActive())) continue;
            users.add(iAtsUser);
        }
        return users;
    }

    public void reloadCache() {
        this.userIdToAtsUser.clear();
        this.nameToAtsUser.clear();
        this.currentUser = null;
        for (IAtsUser iAtsUser : this.getUsers()) {
            this.userIdToAtsUser.put(iAtsUser.getUserId(), iAtsUser);
            this.nameToAtsUser.put(iAtsUser.getName(), iAtsUser);
        }
    }

    public void releaseUser() {
        this.currentUser = null;
    }
}

