/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.Role;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAttribute;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class UserRoleManager
implements IAtsPeerReviewRoleManager {
    protected static final String ROLE_ITEM_TAG = "Role";
    private final Matcher roleMatcher = Pattern.compile("<Role>(.*?)</Role>", 40).matcher("");
    private List<UserRole> roles;
    protected final IAtsUserService userService;
    protected final IAttributeResolver attrResolver;
    protected final IAtsPeerToPeerReview peerRev;
    protected final IAtsServices services;

    public UserRoleManager(IAtsPeerToPeerReview peerRev, IAtsServices services) {
        this.services = services;
        this.attrResolver = services.getAttributeResolver();
        this.userService = services.getUserService();
        this.peerRev = peerRev;
    }

    public void ensureLoaded() {
        if (this.roles == null) {
            this.roles = new ArrayList<UserRole>();
            if (this.attrResolver != null) {
                for (String xml : this.attrResolver.getAttributesToStringList((IAtsObject)this.peerRev, (AttributeTypeId)AtsAttributeTypes.Role)) {
                    this.roleMatcher.reset(xml);
                    while (this.roleMatcher.find()) {
                        UserRole item = new UserRole(this.roleMatcher.group());
                        this.roles.add(item);
                    }
                }
            }
        }
    }

    public List<UserRole> getUserRoles() {
        this.ensureLoaded();
        return this.roles;
    }

    public List<UserRole> getUserRoles(Role role) {
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        for (UserRole uRole : this.getUserRoles()) {
            if (uRole.getRole() != role) continue;
            roles.add(uRole);
        }
        return roles;
    }

    public List<IAtsUser> getRoleUsers(Role role) {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        for (UserRole uRole : this.getUserRoles()) {
            if (uRole.getRole() != role || users.contains(this.userService.getUserById(uRole.getUserId()))) continue;
            users.add(this.userService.getUserById(uRole.getUserId()));
        }
        return users;
    }

    public List<IAtsUser> getRoleUsers(Collection<UserRole> roles) {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        for (UserRole uRole : roles) {
            if (users.contains(this.userService.getUserById(uRole.getUserId()))) continue;
            users.add(this.userService.getUserById(uRole.getUserId()));
        }
        return users;
    }

    public void addOrUpdateUserRole(UserRole userRole) {
        List<UserRole> roleItems = this.getUserRoles();
        boolean found = false;
        for (UserRole uRole : roleItems) {
            if (!userRole.equals((Object)uRole)) continue;
            uRole.update(userRole);
            found = true;
        }
        if (!found) {
            roleItems.add(userRole);
            if (!this.peerRev.getAssignees().contains(UserRoleManager.getUser(userRole, this.services))) {
                this.peerRev.getStateMgr().addAssignee(UserRoleManager.getUser(userRole, this.services));
            }
        }
    }

    public void removeUserRole(UserRole userRole) {
        List<UserRole> roleItems = this.getUserRoles();
        roleItems.remove(userRole);
    }

    private List<UserRole> getStoredUserRoles() {
        ArrayList<UserRole> storedUserRoles = new ArrayList<UserRole>();
        for (IAttribute attr : this.services.getAttributeResolver().getAttributes((IAtsWorkItem)this.peerRev, (AttributeTypeId)AtsAttributeTypes.Role)) {
            UserRole storedRole = new UserRole((String)attr.getValue());
            storedUserRoles.add(storedRole);
        }
        return storedUserRoles;
    }

    public void saveToArtifact(IAtsChangeSet changes) {
        try {
            List<UserRole> storedUserRoles = this.getStoredUserRoles();
            for (IAttribute attr : this.services.getAttributeResolver().getAttributes((IAtsWorkItem)this.peerRev, (AttributeTypeId)AtsAttributeTypes.Role)) {
                UserRole storedRole = new UserRole((String)attr.getValue());
                for (UserRole pItem : this.getUserRoles()) {
                    if (!pItem.equals((Object)storedRole)) continue;
                    changes.setAttribute((IAtsWorkItem)this.peerRev, attr.getId().intValue(), (Object)AXml.addTagData((String)ROLE_ITEM_TAG, (String)pItem.toXml()));
                }
            }
            List<UserRole> userRoles = this.getUserRoles();
            List<UserRole> updatedStoredUserRoles = this.getStoredUserRoles();
            for (UserRole delUserRole : Collections.setComplement(updatedStoredUserRoles, userRoles)) {
                for (IAttribute attr : this.services.getAttributeResolver().getAttributes((IAtsWorkItem)this.peerRev, (AttributeTypeId)AtsAttributeTypes.Role)) {
                    UserRole storedRole = new UserRole((String)attr.getValue());
                    if (!storedRole.equals((Object)delUserRole)) continue;
                    attr.delete();
                }
            }
            for (UserRole newRole : Collections.setComplement(userRoles, updatedStoredUserRoles)) {
                changes.addAttribute((IAtsObject)this.peerRev, (AttributeTypeId)AtsAttributeTypes.Role, (Object)AXml.addTagData((String)ROLE_ITEM_TAG, (String)newRole.toXml()));
            }
            this.rollupHoursSpentToReviewState(this.peerRev);
            this.validateUserRolesCompleted(storedUserRoles, userRoles, changes);
        }
        catch (OseeCoreException ex) {
            this.services.getLogger().error((Throwable)ex, "Can't create ats review role document", new Object[0]);
        }
    }

    private void rollupHoursSpentToReviewState(IAtsPeerToPeerReview peerRev) {
        double hoursSpent = 0.0;
        for (UserRole role : this.getUserRoles()) {
            hoursSpent += role.getHoursSpent() == null ? 0.0 : role.getHoursSpent();
        }
        peerRev.getStateMgr().setMetrics((IStateToken)peerRev.getStateDefinition(), hoursSpent, peerRev.getStateMgr().getPercentComplete(peerRev.getStateMgr().getCurrentStateName()), true, this.services.getUserService().getCurrentUser(), new Date());
    }

    private void validateUserRolesCompleted(List<UserRole> currentUserRoles, List<UserRole> newUserRoles, IAtsChangeSet changes) {
        int numCurrentCompleted = 0;
        int numNewCompleted = 0;
        for (UserRole role : newUserRoles) {
            if (role.getRole() != Role.Reviewer) continue;
            if (!role.isCompleted()) {
                return;
            }
            ++numNewCompleted;
        }
        for (UserRole role : currentUserRoles) {
            if (role.getRole() != Role.Reviewer || !role.isCompleted()) continue;
            ++numCurrentCompleted;
        }
        if (numNewCompleted != numCurrentCompleted) {
            try {
                changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((IAtsUser)this.services.getUserService().getCurrentUser(), (IAtsWorkItem)this.peerRev, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Peer_Reviewers_Completed}));
            }
            catch (OseeCoreException ex) {
                this.services.getLogger().error((Throwable)ex, "Error adding ATS Notification Event", new Object[0]);
            }
        }
    }

    public static IAtsUser getUser(UserRole item, IAtsServices services) {
        return services.getUserService().getUserById(item.getUserId());
    }
}

