/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.IAtsReviewService;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewOption;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.transition.IAtsTransitionManager;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.review.DecisionReviewState;
import org.eclipse.osee.ats.core.review.UserRoleManager;
import org.eclipse.osee.ats.core.workdef.SimpleDecisionReviewOption;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.core.workflow.transition.TransitionFactory;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsReviewServiceImpl
implements IAtsReviewService {
    private final IAtsServices services;
    private static final String VALIDATE_REVIEW_TITLE = "Is the resolution of this Action valid?";

    public AtsReviewServiceImpl(IAtsServices services) {
        this.services = services;
    }

    public boolean isValidationReviewRequired(IAtsWorkItem workItem) throws OseeCoreException {
        boolean required = false;
        if (workItem.isTeamWorkflow()) {
            required = (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.ValidationRequired, (Object)false);
        }
        return required;
    }

    public IAtsDecisionReview createValidateReview(IAtsTeamWorkflow teamWf, boolean force, Date transitionDate, IAtsUser transitionUser, IAtsChangeSet changes) throws OseeCoreException {
        if (!force && !AtsReviewServiceImpl.isValidatePage(teamWf.getStateDefinition())) {
            return null;
        }
        if (!force && this.getReviewsFromCurrentState(teamWf).size() > 0) {
            for (IAtsAbstractReview review : this.getReviewsFromCurrentState(teamWf)) {
                if (!review.getName().equals(VALIDATE_REVIEW_TITLE)) continue;
                return null;
            }
        }
        try {
            IAtsDecisionReview decRev = this.createNewDecisionReview(teamWf, this.isValidateReviewBlocking(teamWf.getStateDefinition()) ? ReviewBlockType.Transition : ReviewBlockType.None, true, new Date(), this.services.getUserService().getCurrentUser(), changes);
            changes.setName((IAtsObject)decRev, VALIDATE_REVIEW_TITLE);
            changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeId)AtsAttributeTypes.DecisionReviewOptions, "No;Followup;" + this.getValidateReviewFollowupUsersStr(teamWf) + "\n" + "Yes;Completed;");
            TransitionHelper helper = new TransitionHelper("Transition to Decision", Arrays.asList(decRev), DecisionReviewState.Decision.getName(), Arrays.asList(teamWf.getCreatedBy()), null, changes, this.services, TransitionOption.None);
            IAtsTransitionManager transitionMgr = TransitionFactory.getTransitionManager(helper);
            TransitionResults results = transitionMgr.handleAll();
            if (!results.isEmpty()) {
                OseeLog.logf(AtsReviewServiceImpl.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error transitioning Decision review [%s] to Decision %s", (Object[])new Object[]{decRev.toStringWithId(), results});
            }
            return decRev;
        }
        catch (Exception ex) {
            OseeLog.log(AtsReviewServiceImpl.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return null;
        }
    }

    public String getValidateReviewFollowupUsersStr(IAtsTeamWorkflow teamWf) {
        try {
            Collection<IAtsUser> users = this.getValidateReviewFollowupUsers(teamWf);
            return this.services.getWorkStateFactory().getStorageString(users);
        }
        catch (Exception ex) {
            OseeLog.log(AtsReviewServiceImpl.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    public boolean isValidateReviewBlocking(IAtsStateDefinition stateDefinition) {
        return stateDefinition.hasRule(RuleDefinitionOption.AddDecisionValidateBlockingReview.name());
    }

    public Collection<IAtsUser> getValidateReviewFollowupUsers(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        HashSet<IAtsUser> users = new HashSet<IAtsUser>();
        users.addAll(teamWf.getStateMgr().getAssignees((IStateToken)TeamState.Implement));
        if (users.size() > 0) {
            return users;
        }
        users.addAll(teamWf.getTeamDefinition().getLeads());
        return users;
    }

    public IAtsDecisionReview createNewDecisionReviewAndTransitionToDecision(IAtsTeamWorkflow teamWf, String reviewTitle, String description, String againstState, ReviewBlockType reviewBlockType, Collection<IAtsDecisionReviewOption> options, List<? extends IAtsUser> assignees, Date createdDate, IAtsUser createdBy, IAtsChangeSet changes) throws OseeCoreException {
        IAtsDecisionReview decRev = this.createNewDecisionReview(teamWf, reviewBlockType, reviewTitle, againstState, description, options, assignees, createdDate, createdBy, changes);
        changes.add((Object)decRev);
        TransitionHelper helper = new TransitionHelper("Transition to Decision", Arrays.asList(decRev), DecisionReviewState.Decision.getName(), assignees, null, changes, this.services, TransitionOption.OverrideAssigneeCheck);
        IAtsTransitionManager transitionMgr = TransitionFactory.getTransitionManager(helper);
        TransitionResults results = transitionMgr.handleAll();
        if (!results.isEmpty()) {
            throw new OseeStateException("Error auto-transitioning review %s to Decision state. Results [%s]", new Object[]{decRev.toStringWithId(), results.toString()});
        }
        decRev.getStateMgr().setAssignees(assignees);
        changes.add((Object)decRev);
        return decRev;
    }

    public IAtsDecisionReview createNewDecisionReview(IAtsTeamWorkflow teamWf, ReviewBlockType reviewBlockType, boolean againstCurrentState, Date createdDate, IAtsUser createdBy, IAtsChangeSet changes) throws OseeCoreException {
        return this.createNewDecisionReview(teamWf, reviewBlockType, "Should we do this?  Yes will require followup, No will not", againstCurrentState ? teamWf.getStateMgr().getCurrentStateName() : null, "Enter description of the decision, if any", this.getDefaultDecisionReviewOptions(), null, createdDate, createdBy, changes);
    }

    public IAtsDecisionReview createNewDecisionReview(IAtsTeamWorkflow teamWf, ReviewBlockType reviewBlockType, String title, String relatedToState, String description, Collection<IAtsDecisionReviewOption> options, List<? extends IAtsUser> assignees, Date createdDate, IAtsUser createdBy, IAtsChangeSet changes) throws OseeCoreException {
        ArtifactId decRevArt = changes.createArtifact(AtsArtifactTypes.DecisionReview, title);
        IAtsDecisionReview decRev = (IAtsDecisionReview)this.services.getWorkItemFactory().getReview(decRevArt);
        changes.relate((Object)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, (Object)decRev);
        this.services.getActionFactory().setAtsId((IAtsObject)decRev, decRev.getParentTeamWorkflow().getTeamDefinition(), changes);
        this.services.getActionFactory().initializeNewStateMachine((IAtsWorkItem)decRev, assignees, createdDate, createdBy, changes);
        if (Strings.isValid((String)relatedToState)) {
            changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeId)AtsAttributeTypes.RelatedToState, relatedToState);
        }
        if (Strings.isValid((String)description)) {
            changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeId)AtsAttributeTypes.Description, description);
        }
        changes.setSoleAttributeValue((IAtsWorkItem)decRev, (AttributeTypeId)AtsAttributeTypes.DecisionReviewOptions, this.getDecisionReviewOptionsString(options));
        if (reviewBlockType != null) {
            changes.setSoleAttributeFromString((IAtsObject)decRev, (AttributeTypeId)AtsAttributeTypes.ReviewBlocks, reviewBlockType.name());
        }
        changes.add((Object)decRev);
        return decRev;
    }

    public String getDecisionReviewOptionsString(Collection<IAtsDecisionReviewOption> options) {
        StringBuffer sb = new StringBuffer();
        for (IAtsDecisionReviewOption opt : options) {
            sb.append(opt.getName());
            sb.append(";");
            sb.append(opt.isFollowupRequired() ? "Followup" : "Completed");
            sb.append(";");
            for (String userId : opt.getUserIds()) {
                sb.append("<" + userId + ">");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static boolean isValidatePage(IAtsStateDefinition stateDefinition) {
        if (stateDefinition.hasRule(RuleDefinitionOption.AddDecisionValidateBlockingReview.name())) {
            return true;
        }
        return stateDefinition.hasRule(RuleDefinitionOption.AddDecisionValidateNonBlockingReview.name());
    }

    public List<IAtsDecisionReviewOption> getDefaultDecisionReviewOptions() {
        ArrayList<IAtsDecisionReviewOption> options = new ArrayList<IAtsDecisionReviewOption>();
        options.add(new SimpleDecisionReviewOption("Yes", true, Arrays.asList(this.services.getUserService().getCurrentUser().getUserId())));
        options.add(new SimpleDecisionReviewOption("No", false, null));
        return options;
    }

    public Collection<IAtsAbstractReview> getReviewsFromCurrentState(IAtsTeamWorkflow teamWf) throws OseeCoreException {
        return this.services.getWorkItemService().getReviews(teamWf, teamWf.getStateMgr().getCurrentState());
    }

    public ReviewBlockType getReviewBlockType(IAtsAbstractReview review) throws OseeCoreException {
        String blockStr = this.services.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)review, (AttributeTypeId)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
        return ReviewBlockType.valueOf((String)blockStr);
    }

    public boolean isStandAloneReview(IAtsAbstractReview review) {
        return this.services.getAttributeResolver().getAttributeCount((IAtsWorkItem)review, (AttributeTypeId)AtsAttributeTypes.ActionableItem) > 0;
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf) {
        ArrayList<IAtsAbstractReview> reviews = new ArrayList<IAtsAbstractReview>();
        for (ArtifactId reviewArt : this.services.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review)) {
            reviews.add(this.services.getWorkItemFactory().getReview(reviewArt));
        }
        return reviews;
    }

    public IAtsPeerReviewRoleManager createPeerReviewRoleManager(IAtsPeerToPeerReview peerRev) {
        return new UserRoleManager(peerRev, this.services);
    }
}

