/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;

public abstract class AbstractAtsQueryService
implements IAtsQueryService {
    protected final JdbcService jdbcService;
    private final IAtsServices services;

    public AbstractAtsQueryService(JdbcService jdbcService, IAtsServices services) {
        this.jdbcService = jdbcService;
        this.services = services;
    }

    public Collection<IAtsWorkItem> getWorkItemsFromQuery(String query, Object ... data) {
        LinkedList<IAtsWorkItem> workItems = new LinkedList<IAtsWorkItem>();
        for (ArtifactId art : this.getArtifactsFromQuery(query, data)) {
            IAtsWorkItem workItem;
            if (!this.services.getStoreService().isOfType(art, new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact}) || (workItem = this.services.getWorkItemFactory().getWorkItem(art)) == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public Collection<ArtifactId> getArtifactsFromQuery(String query, Object ... data) {
        LinkedList<Integer> ids = new LinkedList<Integer>();
        try (JdbcStatement chStmt = this.jdbcService.getClient().getStatement();){
            chStmt.runPreparedQuery(query, data);
            while (chStmt.next()) {
                ids.add(chStmt.getInt("art_id"));
            }
        }
        return this.services.getQueryService().getArtifacts(ids, (BranchId)this.services.getAtsBranch());
    }

    public void runUpdate(String query, Object ... data) {
        this.jdbcService.getClient().runPreparedUpdate(query, data);
    }
}

