/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.query.IAtsQuery;
import org.eclipse.osee.ats.api.query.IAtsQueryFilter;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.ats.core.query.AtsWorkItemFilter;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsQueryImpl
implements IAtsQuery {
    protected final List<AtsAttributeQuery> andAttr;
    protected final List<AtsAttributeQuery> teamWorkflowAttr;
    protected final HashMap<RelationTypeSide, List<IAtsObject>> andRels;
    protected Collection<Long> teamDefUuids;
    protected Collection<StateType> stateTypes;
    protected Collection<WorkItemType> workItemTypes;
    protected Collection<IArtifactType> artifactTypes;
    protected Collection<Long> uuids;
    protected final IAtsServices services;
    protected Collection<Long> aiUuids;
    protected Long versionUuid;
    protected String stateName;
    protected String colorTeam;
    protected Long programUuid;
    protected Long insertionUuid;
    protected Long insertionActivityUuid;
    protected Long workPackageUuid;
    protected List<ArtifactId> onlyIds = null;
    private ReleasedOption releasedOption;
    protected final List<IAtsQueryFilter> queryFilters;

    public AbstractAtsQueryImpl(IAtsServices services) {
        this.services = services;
        this.andRels = new HashMap();
        this.andAttr = new ArrayList<AtsAttributeQuery>();
        this.stateTypes = new ArrayList<StateType>();
        this.workItemTypes = new ArrayList<WorkItemType>();
        this.artifactTypes = new ArrayList<IArtifactType>();
        this.teamDefUuids = new ArrayList<Long>();
        this.aiUuids = new ArrayList<Long>();
        this.uuids = new ArrayList<Long>();
        this.teamWorkflowAttr = new ArrayList<AtsAttributeQuery>();
        this.queryFilters = new ArrayList<IAtsQueryFilter>();
    }

    public Collection<ArtifactId> getItemIds() throws OseeCoreException {
        this.onlyIds = new LinkedList<ArtifactId>();
        this.getItems();
        return this.onlyIds;
    }

    public <T extends IAtsWorkItem> Collection<T> getItems() throws OseeCoreException {
        Set<IArtifactType> allArtTypes = this.getAllArtTypes();
        List<IArtifactType> teamWorkflowArtTypes = this.getTeamWorkflowArtTypes(allArtTypes);
        boolean teamsTypeDefOrAisOrVersionSearched = this.isTeamTypeDefAisOrVersionSearched(allArtTypes);
        Collection<Object> teamWfs = Collections.emptyList();
        Set allResults = new HashSet();
        if (!teamWorkflowArtTypes.isEmpty()) {
            teamWfs = this.getTeamWorkflows(teamWorkflowArtTypes, allResults, allArtTypes);
        }
        if (allArtTypes.contains(AtsArtifactTypes.AbstractWorkflowArtifact)) {
            teamWfs = this.getTeamWorkflows(allArtTypes, allResults, allArtTypes);
        }
        if (!teamWorkflowArtTypes.isEmpty() && teamsTypeDefOrAisOrVersionSearched) {
            this.getTasksAndReviewsFromResultingTeamWfs(teamWfs, allResults, allArtTypes);
        } else {
            this.getTasksFromSearchCriteria(allResults, allArtTypes);
            this.getReviewsFromSearchCriteria(allResults, allArtTypes);
        }
        this.getGoalsFromSearchCriteria(allResults, allArtTypes);
        this.getSprintsFromSearchCriteria(allResults, allArtTypes);
        for (IAtsQueryFilter filter : this.queryFilters) {
            allResults = filter.applyFilter(allResults);
        }
        return allResults;
    }

    public abstract Collection<ArtifactId> runQuery();

    private <T> Collection<T> collectResults(Set<T> allResults, Set<IArtifactType> allArtTypes) {
        HashSet<IAtsWorkItem> workItems = new HashSet<IAtsWorkItem>();
        if (this.isOnlyIds()) {
            this.onlyIds.addAll(this.handleReleaseOption(this.queryGetIds()));
        } else {
            Collection<ArtifactId> artifacts = this.runQuery();
            for (ArtifactId artifact : artifacts) {
                IAtsWorkItem workItem;
                if (!allArtTypes.isEmpty() && !this.isArtifactTypeMatch(artifact, allArtTypes) || (workItem = this.services.getWorkItemFactory().getWorkItem(artifact)) == null) continue;
                workItems.add(workItem);
            }
            this.addtoResultsWithNullCheck(allResults, this.handleReleasedOption(workItems));
        }
        return workItems;
    }

    private <T> void addtoResultsWithNullCheck(Set<T> allResults, Collection<? extends T> workItems) {
        if (workItems.contains(null)) {
            System.err.println("Null found in results.");
        } else {
            allResults.addAll(workItems);
        }
    }

    private Collection<ArtifactId> handleReleaseOption(List<ArtifactId> queryGetIds) {
        if (this.releasedOption != null && this.releasedOption != ReleasedOption.Both) {
            throw new UnsupportedOperationException("This option not supported");
        }
        return queryGetIds;
    }

    private <T> Collection<? extends T> handleReleasedOption(Set<T> workItems) {
        if (this.releasedOption == null) {
            return workItems;
        }
        HashSet<T> results = new HashSet<T>();
        if (this.isVersionSpecified()) {
            for (T workItem : workItems) {
                IAtsVersion version = this.services.getVersionService().getTargetedVersion((IAtsWorkItem)workItem);
                if (version == null) continue;
                if (this.releasedOption == ReleasedOption.Released && version.isReleased().booleanValue()) {
                    results.add(workItem);
                    continue;
                }
                if (this.releasedOption != ReleasedOption.UnReleased || version.isReleased().booleanValue()) continue;
                results.add(workItem);
            }
        }
        return results;
    }

    private boolean isArtifactTypeMatch(ArtifactId artifact, Collection<IArtifactType> artTypes) {
        if (artTypes.isEmpty()) {
            return true;
        }
        for (IArtifactType artType : artTypes) {
            if (!this.services.getArtifactResolver().isOfType(artifact, artType)) continue;
            return true;
        }
        return false;
    }

    private <T> void getTasksFromSearchCriteria(Set<T> allResults, Set<IArtifactType> allArtTypes) {
        LinkedList<IArtifactType> artTypes = new LinkedList<IArtifactType>();
        for (IArtifactType artType : allArtTypes) {
            if (!this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.Task)) continue;
            artTypes.add(artType);
        }
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            if (this.isTeamTypeDefAisOrVersionSearched(allArtTypes)) {
                List<ArtifactId> teamWfUuids = this.getRelatedTeamWorkflowUuidsBasedOnTeamDefsAisAndVersions(this.teamWorkflowAttr);
                this.queryAndRelatedTo(AtsRelationTypes.TeamWfToTask_TeamWf, teamWfUuids);
            }
            this.addEvConfigCriteria();
            this.collectResults(allResults, allArtTypes);
        }
    }

    private <T> void getReviewsFromSearchCriteria(Set<T> allResults, Set<IArtifactType> allArtTypes) {
        List<IArtifactType> artTypes = this.getReviewArtifactTypes(allArtTypes);
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            if (this.isTeamTypeDefAisOrVersionSearched(allArtTypes)) {
                List<ArtifactId> teamWfUuids = this.getRelatedTeamWorkflowUuidsBasedOnTeamDefsAisAndVersions(this.teamWorkflowAttr);
                this.queryAndRelatedTo(AtsRelationTypes.TeamWorkflowToReview_Team, teamWfUuids);
            }
            this.collectResults(allResults, allArtTypes);
        }
    }

    private <T> void getSprintsFromSearchCriteria(Set<T> allResults, Set<IArtifactType> allArtTypes) {
        LinkedList<IArtifactType> artTypes = new LinkedList<IArtifactType>();
        for (IArtifactType artType : allArtTypes) {
            if (!this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.AgileSprint)) continue;
            artTypes.add(artType);
        }
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            this.collectResults(allResults, allArtTypes);
        }
    }

    private <T> void getGoalsFromSearchCriteria(Set<T> allResults, Set<IArtifactType> allArtTypes) {
        LinkedList<IArtifactType> artTypes = new LinkedList<IArtifactType>();
        for (IArtifactType artType : allArtTypes) {
            if (!this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.Goal) && !this.workItemTypes.contains(WorkItemType.AgileBacklog)) continue;
            artTypes.add(artType);
        }
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            this.getBaseSearchCriteria(artTypes, true, allArtTypes);
            boolean isAgileSpecified = this.workItemTypes.contains(WorkItemType.AgileBacklog);
            boolean isGoalSpecified = this.workItemTypes.contains(WorkItemType.Goal);
            if (isAgileSpecified && !isGoalSpecified) {
                this.queryAndExists(AtsRelationTypes.AgileTeamToBacklog_Backlog);
            } else if (isGoalSpecified && !isAgileSpecified) {
                this.queryAndNotExists(AtsRelationTypes.AgileTeamToBacklog_Backlog);
            }
            this.collectResults(allResults, allArtTypes);
        }
    }

    public abstract void queryAndNotExists(RelationTypeSide var1);

    public abstract void queryAndExists(RelationTypeSide var1);

    private boolean typeIsSpecified(IArtifactType parentArtType, Set<IArtifactType> allArtTypes) {
        for (IArtifactType artifactType : allArtTypes) {
            if (!this.services.getArtifactResolver().inheritsFrom(artifactType, parentArtType)) continue;
            return true;
        }
        return false;
    }

    private List<IArtifactType> getReviewArtifactTypes(Set<IArtifactType> allArtTypes) {
        LinkedList<IArtifactType> artTypes = new LinkedList<IArtifactType>();
        boolean isReviewSpecified = this.workItemTypes.contains(WorkItemType.Review) || this.typeIsSpecified(AtsArtifactTypes.ReviewArtifact, allArtTypes);
        boolean isPeerSpecified = this.workItemTypes.contains(WorkItemType.PeerReview) || this.typeIsSpecified(AtsArtifactTypes.PeerToPeerReview, allArtTypes);
        boolean isDecisionSpecified = this.workItemTypes.contains(WorkItemType.DecisionReview) || this.typeIsSpecified(AtsArtifactTypes.DecisionReview, allArtTypes);
        for (IArtifactType artType : allArtTypes) {
            if (isReviewSpecified && this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.ReviewArtifact)) {
                artTypes.add(artType);
                continue;
            }
            if (isPeerSpecified && this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.PeerToPeerReview)) {
                artTypes.add(artType);
                continue;
            }
            if (!isDecisionSpecified || !this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.DecisionReview)) continue;
            artTypes.add(artType);
        }
        return artTypes;
    }

    private <T> void getTasksAndReviewsFromResultingTeamWfs(Collection<T> teamWfs, Set<T> allResults, Set<IArtifactType> allArtTypes) {
        LinkedList<IArtifactType> artTypes = new LinkedList<IArtifactType>();
        for (IArtifactType artType : allArtTypes) {
            if (!this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.Task)) continue;
            artTypes.add(artType);
        }
        artTypes.addAll(this.getReviewArtifactTypes(allArtTypes));
        if (!artTypes.isEmpty()) {
            this.createQueryBuilder();
            ArrayList<Long> taskReviewUuids = new ArrayList<Long>();
            for (T teamWf : teamWfs) {
                for (IAtsTask task : this.services.getTaskService().getTasks((IAtsTeamWorkflow)teamWf)) {
                    taskReviewUuids.add(task.getId());
                }
                for (IAtsAbstractReview review : this.services.getReviewService().getReviews((IAtsTeamWorkflow)teamWf)) {
                    taskReviewUuids.add(review.getId());
                }
            }
            this.getBaseSearchCriteria(artTypes, false, allArtTypes);
            this.addUuidCriteria(taskReviewUuids);
            this.addEvConfigCriteria();
            this.collectResults(allResults, allArtTypes);
        }
    }

    private <T extends IAtsWorkItem> Collection<T> getTeamWorkflows(Collection<IArtifactType> teamWorkflowArtTypes, Set<T> allResults, Set<IArtifactType> allArtTypes) {
        this.createQueryBuilder();
        this.getBaseSearchCriteria(teamWorkflowArtTypes, true, allArtTypes);
        this.addTeamWorkflowAttributeCriteria();
        this.addTeamDefCriteria();
        this.addAiCriteria();
        this.addVersionCriteria();
        this.addEvConfigCriteria();
        return this.collectResults(allResults, allArtTypes);
    }

    private void addEvConfigCriteria() {
        this.addColorTeamCriteria();
        this.addWorkPackageCriteria();
        this.addInsertionActivityCriteria();
        this.addInsertionCriteria();
        this.addProgramCriteria();
    }

    protected boolean isProgramSpecified() {
        return this.programUuid != null && this.programUuid > 0L;
    }

    protected boolean isInsertionSpecified() {
        return this.insertionUuid != null && this.insertionUuid > 0L;
    }

    protected boolean isColorTeamSpecified() {
        return Strings.isValid((String)this.colorTeam);
    }

    protected boolean isVersionSpecified() {
        return this.versionUuid != null && this.versionUuid > 0L;
    }

    protected boolean isInsertionActivitySpecified() {
        return this.insertionActivityUuid != null && this.insertionActivityUuid > 0L;
    }

    protected boolean isWorkPackageSpecified() {
        return this.workPackageUuid != null && this.workPackageUuid > 0L;
    }

    public abstract void createQueryBuilder();

    public abstract void queryAndIsOfType(IArtifactType var1);

    public boolean isOnlyIds() {
        return this.onlyIds != null;
    }

    public abstract List<ArtifactId> queryGetIds();

    public abstract List<ArtifactId> getRelatedTeamWorkflowUuidsBasedOnTeamDefsAisAndVersions(List<AtsAttributeQuery> var1);

    private Set<IArtifactType> getAllArtTypes() {
        HashSet<IArtifactType> allArtTypes = new HashSet();
        if (this.artifactTypes != null && !this.artifactTypes.isEmpty()) {
            allArtTypes.addAll(this.artifactTypes);
        } else {
            allArtTypes = this.getArtifactTypesFromWorkItemTypes();
        }
        return allArtTypes;
    }

    private List<IArtifactType> getTeamWorkflowArtTypes(Set<IArtifactType> allArtTypes) {
        LinkedList<IArtifactType> teamWorkflowArtTypes = new LinkedList<IArtifactType>();
        for (IArtifactType artType : allArtTypes) {
            if (!this.services.getArtifactResolver().inheritsFrom(artType, AtsArtifactTypes.TeamWorkflow)) continue;
            teamWorkflowArtTypes.add(artType);
        }
        return teamWorkflowArtTypes;
    }

    private boolean isTeamTypeDefAisOrVersionSearched(Set<IArtifactType> allArtTypes) {
        boolean teamDefsSearched = this.isTeamDefSpecified();
        boolean aisSearched = this.isActionableItemSpecified();
        boolean versionSearched = this.versionUuid != null && this.versionUuid > 0L;
        boolean teamWfAttrSpecified = this.isTeamWfAttrSpecified();
        return teamDefsSearched || teamWfAttrSpecified || aisSearched || versionSearched;
    }

    private boolean isActionableItemSpecified() {
        return this.aiUuids != null && !this.aiUuids.isEmpty();
    }

    private boolean isTeamDefSpecified() {
        return this.teamDefUuids != null && !this.teamDefUuids.isEmpty();
    }

    private boolean isTeamWfAttrSpecified() {
        return this.teamWorkflowAttr != null && !this.teamWorkflowAttr.isEmpty();
    }

    private boolean isArtifactTypesSpecified() {
        return !this.getAllArtTypes().isEmpty();
    }

    public IAtsQuery isOfType(IArtifactType ... artifactTypes) {
        this.artifactTypes = Arrays.asList(artifactTypes);
        return this;
    }

    public IAtsQuery isOfType(Collection<WorkItemType> workItemTypes) {
        for (WorkItemType type : workItemTypes) {
            this.workItemTypes.add(type);
        }
        return this;
    }

    public IAtsQuery isOfType(WorkItemType ... workItemType) {
        return this.isOfType(Arrays.asList(workItemType));
    }

    public IAtsQuery andTeam(IAtsTeamDefinition teamDef) throws OseeCoreException {
        this.teamDefUuids.add(teamDef.getId());
        return this;
    }

    public IAtsQuery andStateType(StateType ... stateType) throws OseeCoreException {
        this.stateTypes = Arrays.asList(stateType);
        return this;
    }

    public IAtsQuery andTeam(Collection<IAtsTeamDefinition> teamDefs) {
        return this.andTeam(AtsObjects.toUuids(teamDefs));
    }

    public IAtsQuery andAttr(AttributeTypeId attributeType, Collection<String> values, QueryOption ... queryOptions) throws OseeCoreException {
        this.andAttr.add(new AtsAttributeQuery(attributeType, values, queryOptions));
        return this;
    }

    public IAtsQuery andRelated(IAtsObject object, RelationTypeSide relation) {
        List<IAtsObject> list = this.andRels.get(relation);
        if (list == null) {
            list = new LinkedList<IAtsObject>();
            this.andRels.put(relation, list);
        }
        list.add(object);
        return this;
    }

    public IAtsQuery andUuids(Long ... uuids) {
        this.uuids = Arrays.asList(uuids);
        return this;
    }

    public IAtsQuery andAtsIds(Collection<String> atsIds) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.AtsId, atsIds, new QueryOption[0]);
    }

    public IAtsQuery andLegacyIds(Collection<String> legacyIds) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.LegacyPcrId, legacyIds, new QueryOption[0]);
    }

    public IAtsWorkItemFilter andFilter() throws OseeCoreException {
        return new AtsWorkItemFilter(this.getItems(), this.services);
    }

    protected Set<IArtifactType> getArtifactTypesFromWorkItemTypes() {
        HashSet<IArtifactType> artifactTypes = new HashSet<IArtifactType>();
        if (this.workItemTypes != null) {
            for (WorkItemType workItemType : this.workItemTypes) {
                artifactTypes.add(workItemType.getArtifactType());
            }
        }
        return artifactTypes;
    }

    public IAtsQuery andAttr(AttributeTypeId attributeType, String value, QueryOption ... queryOption) {
        return this.andAttr(attributeType, Collections.singleton(value), queryOption);
    }

    public <T extends IAtsWorkItem> ResultSet<T> getResults() {
        return ResultSets.newResultSet(this.getItems());
    }

    public IAtsQuery andAssignee(IAtsUser ... assignees) {
        ArrayList<String> userIds = new ArrayList<String>();
        IAtsUser[] iAtsUserArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            IAtsUser user = iAtsUserArray[n2];
            userIds.add("<" + user.getUserId() + ">");
            ++n2;
        }
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.CurrentState, userIds, QueryOption.CONTAINS_MATCH_OPTIONS);
    }

    public IAtsQuery andAssigneeWas(IAtsUser ... assignees) {
        ArrayList<String> userIds = new ArrayList<String>();
        IAtsUser[] iAtsUserArray = assignees;
        int n = assignees.length;
        int n2 = 0;
        while (n2 < n) {
            IAtsUser user = iAtsUserArray[n2];
            userIds.add("<" + user.getUserId() + ">");
            ++n2;
        }
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.State, userIds, QueryOption.CONTAINS_MATCH_OPTIONS);
    }

    public <T extends ArtifactId> ResultSet<T> getResultArtifacts() {
        ArrayList<ArtifactToken> items = new ArrayList<ArtifactToken>();
        for (IAtsWorkItem workItem : this.getResults()) {
            if (workItem == null) {
                System.err.println("Unexpected null workitem");
                continue;
            }
            items.add(workItem.getStoreObject());
        }
        LinkedList<ArtifactId> artifacts = new LinkedList<ArtifactId>();
        for (ArtifactId artifact : items) {
            boolean artifactTypeMatch = this.isArtifactTypeMatch(artifact, this.artifactTypes);
            boolean releaseOptionMatch = this.isReleaseOptionMatch(artifact);
            if (!artifactTypeMatch || !releaseOptionMatch) continue;
            artifacts.add(artifact);
        }
        return ResultSets.newResultSet(artifacts);
    }

    private boolean isReleaseOptionMatch(ArtifactId artifact) {
        if (this.releasedOption == null || this.releasedOption == ReleasedOption.Both) {
            return true;
        }
        boolean match = false;
        IAtsWorkItem workItem = this.services.getWorkItemFactory().getWorkItem(artifact);
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        if (teamWf != null) {
            boolean released = this.services.getVersionService().isReleased(teamWf);
            if (this.releasedOption == ReleasedOption.Released && released || this.releasedOption == ReleasedOption.UnReleased && !released) {
                match = true;
            }
        }
        return match;
    }

    public IAtsQuery andOriginator(IAtsUser atsUser) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.CreatedBy, atsUser.getUserId(), new QueryOption[0]);
    }

    public IAtsQuery andSubscribed(IAtsUser atsUser) {
        return this.andRelated((IAtsObject)atsUser, AtsRelationTypes.SubscribedUser_User);
    }

    public IAtsQuery andFavorite(IAtsUser atsUser) {
        return this.andRelated((IAtsObject)atsUser, AtsRelationTypes.FavoriteUser_User);
    }

    public IAtsQuery andTeam(List<Long> teamDefUuids) {
        this.teamDefUuids = teamDefUuids;
        return this;
    }

    public IAtsQuery andActionableItem(IAtsActionableItem actionableItem) {
        this.aiUuids.add(actionableItem.getId());
        return this;
    }

    public IAtsQuery andActionableItem(List<Long> aiUuids) {
        this.aiUuids = aiUuids;
        return this;
    }

    public IAtsQuery andVersion(Long versionUuid) {
        this.versionUuid = versionUuid;
        return this;
    }

    public IAtsQuery andState(String stateName) {
        this.stateName = stateName;
        return this;
    }

    public IAtsQuery andProgram(Long programUuid) {
        this.programUuid = programUuid;
        return this;
    }

    public IAtsQuery andInsertion(Long insertionUuid) {
        this.insertionUuid = insertionUuid;
        return this;
    }

    public IAtsQuery andInsertionActivity(Long insertionActivityUuid) {
        this.insertionActivityUuid = insertionActivityUuid;
        return this;
    }

    public IAtsQuery andWorkPackage(Long workPackageUuid) {
        this.workPackageUuid = workPackageUuid;
        return this;
    }

    public IAtsQuery andColorTeam(String colorTeam) {
        this.colorTeam = colorTeam;
        return this;
    }

    private List<String> getGuidsFromUuids(Collection<Long> uuids) {
        new LinkedList();
        LinkedList<String> guids = new LinkedList<String>();
        for (Long uuid : uuids) {
            guids.add(this.getGuidFromUuid(uuid));
        }
        return guids;
    }

    private String getGuidFromUuid(Long uuid) {
        String guid = AtsUtilCore.getGuid(uuid);
        if (!Strings.isValid((String)guid) && !Strings.isValid((String)(guid = AtsUtilCore.getGuid(uuid)))) {
            ArtifactToken artifact = this.services.getArtifact(uuid);
            if (artifact != null) {
                guid = (String)artifact.getGuid();
            } else {
                throw new OseeArgumentException("No artifact found with uuid %d", new Object[]{uuid});
            }
        }
        return guid;
    }

    private void getBaseSearchCriteria(Collection<IArtifactType> artTypes, boolean withUuids, Set<IArtifactType> allArtTypes) {
        boolean teamDefAndAiNotSpecified;
        this.createQueryBuilder();
        boolean bl = teamDefAndAiNotSpecified = !this.isTeamDefSpecified() && !this.isActionableItemSpecified();
        if (this.isArtifactTypesSpecified() && (this.isOnlyIds() || teamDefAndAiNotSpecified)) {
            this.queryAndIsOfType(artTypes);
        }
        if (withUuids && this.uuids != null && this.uuids.size() > 0) {
            this.addUuidCriteria(this.uuids);
        }
        this.addStateTypeNameAndAttributeCriteria();
    }

    public abstract void queryAndIsOfType(Collection<IArtifactType> var1);

    private void addColorTeamCriteria() {
        if (!(!Strings.isValid((String)this.colorTeam) || this.isWorkPackageSpecified() || this.isInsertionActivitySpecified() || this.isInsertionSpecified() || this.isProgramSpecified())) {
            List<String> workPackageGuids = this.getWorkPackagesForColorTeam(this.colorTeam);
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, workPackageGuids);
        }
    }

    public abstract List<String> getWorkPackagesForColorTeam(String var1);

    private void addWorkPackageCriteria() {
        ArtifactToken workPackArt;
        if (this.isWorkPackageSpecified() && this.isColorTeamMatch((ArtifactId)(workPackArt = this.services.getArtifact(this.workPackageUuid)))) {
            String guid = (String)workPackArt.getGuid();
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, guid);
        }
    }

    private boolean isColorTeamMatch(ArtifactId workPackArt) {
        return !this.isColorTeamSpecified() || this.isColorTeamSpecified() && this.colorTeam.equals(this.services.getAttributeResolver().getSoleAttributeValue(workPackArt, (AttributeTypeId)AtsAttributeTypes.ColorTeam, (Object)""));
    }

    public abstract void queryAnd(AttributeTypeId var1, String var2);

    private void addVersionCriteria() {
        if (this.versionUuid != null && this.versionUuid > 0L) {
            this.queryAndRelatedToLocalIds(AtsRelationTypes.TeamWorkflowTargetedForVersion_Version, ArtifactId.valueOf((long)this.versionUuid));
        }
    }

    public abstract void queryAndRelatedToLocalIds(RelationTypeSide var1, ArtifactId var2);

    private void addAiCriteria() {
        if (this.isActionableItemSpecified()) {
            List<String> guids = this.getGuidsFromUuids(this.aiUuids);
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.ActionableItem, guids);
        }
    }

    private void addTeamDefCriteria() {
        if (this.isTeamDefSpecified()) {
            List<String> guids = this.getGuidsFromUuids(this.teamDefUuids);
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.TeamDefinition, guids);
        }
    }

    private void addAttributeCriteria() {
        if (!this.andAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : this.andAttr) {
                this.queryAnd(attrQuery.getAttrType(), attrQuery.getValues(), attrQuery.getQueryOption());
            }
        }
    }

    private void addTeamWorkflowAttributeCriteria() {
        if (!this.teamWorkflowAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : this.teamWorkflowAttr) {
                this.queryAnd(attrQuery.getAttrType(), attrQuery.getValues(), attrQuery.getQueryOption());
            }
        }
    }

    public abstract void queryAnd(AttributeTypeId var1, Collection<String> var2, QueryOption[] var3);

    private void addRelationCriteria() {
        if (!this.andRels.isEmpty()) {
            for (Map.Entry<RelationTypeSide, List<IAtsObject>> entry : this.andRels.entrySet()) {
                LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
                for (IAtsObject object : entry.getValue()) {
                    artIds.add(ArtifactId.valueOf((long)object.getId()));
                }
                this.queryAndRelatedTo(entry.getKey(), artIds);
            }
        }
    }

    public abstract void queryAndRelatedTo(RelationTypeSide var1, List<ArtifactId> var2);

    private void addStateNameCriteria() {
        if (this.stateName != null) {
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.CurrentState, String.valueOf(this.stateName) + ";", QueryOption.CONTAINS_MATCH_OPTIONS);
        }
    }

    public abstract void queryAnd(AttributeTypeId var1, String var2, QueryOption[] var3);

    private void addStateTypeCriteria() {
        if (!this.stateTypes.isEmpty()) {
            ArrayList<String> stateTypeNames = new ArrayList<String>();
            for (StateType type : this.stateTypes) {
                stateTypeNames.add(type.name());
            }
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.CurrentStateType, stateTypeNames);
        }
    }

    private void addUuidCriteria(Collection<Long> uuids) {
        if (uuids != null) {
            LinkedList<Integer> artIds = new LinkedList<Integer>();
            for (Long uuid : uuids) {
                artIds.add(uuid.intValue());
            }
            this.queryAndLocalIds(artIds);
        }
    }

    public abstract void queryAndLocalIds(List<Integer> var1);

    public void addProgramCriteria() {
        if (!this.isInsertionSpecified() && this.programUuid != null && this.programUuid > 0L) {
            ArtifactToken programArt = this.services.getArtifact(this.programUuid);
            LinkedList<String> workPackageGuids = new LinkedList<String>();
            for (ArtifactId insertionArt : this.services.getRelationResolver().getRelated((ArtifactId)programArt, AtsRelationTypes.ProgramToInsertion_Insertion)) {
                for (ArtifactId insertionActivityArt : this.services.getRelationResolver().getRelated(insertionArt, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                    for (ArtifactId workPackageArt : this.services.getRelationResolver().getRelated(insertionActivityArt, AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                        if (!this.isColorTeamMatch(workPackageArt)) continue;
                        workPackageGuids.add((String)workPackageArt.getGuid());
                    }
                }
            }
            if (!workPackageGuids.isEmpty()) {
                this.queryAnd((AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, workPackageGuids);
            }
        }
    }

    public void addInsertionCriteria() {
        if (!this.isInsertionActivitySpecified() && this.insertionUuid != null && this.insertionUuid > 0L) {
            ArtifactToken insertionArt = this.services.getArtifact(this.insertionUuid);
            LinkedList<String> workPackageGuids = new LinkedList<String>();
            for (ArtifactId insertionActivityArt : this.services.getRelationResolver().getRelated((ArtifactId)insertionArt, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                for (ArtifactId workPackageArt : this.services.getRelationResolver().getRelated(insertionActivityArt, AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                    if (!this.isColorTeamMatch(workPackageArt)) continue;
                    workPackageGuids.add((String)workPackageArt.getGuid());
                }
            }
            if (!workPackageGuids.isEmpty()) {
                this.queryAnd((AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, workPackageGuids);
            }
        }
    }

    public abstract void queryAnd(AttributeTypeId var1, Collection<String> var2);

    public void addInsertionActivityCriteria() {
        List<String> workPackageGuids;
        if (!this.isWorkPackageSpecified() && this.insertionActivityUuid != null && this.insertionActivityUuid > 0L && !(workPackageGuids = this.getWorkPackageGuidsFromActivity()).isEmpty()) {
            this.queryAnd((AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, workPackageGuids);
        }
    }

    private List<String> getWorkPackageGuidsFromActivity() {
        LinkedList<String> guids = new LinkedList<String>();
        if (this.insertionActivityUuid != null && this.insertionActivityUuid > 0L) {
            ArtifactToken insertionActivityArt = this.services.getArtifact(this.insertionActivityUuid);
            for (ArtifactId workPackageArt : this.services.getRelationResolver().getRelated((ArtifactId)insertionActivityArt, AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage)) {
                if (!this.isColorTeamMatch(workPackageArt)) continue;
                guids.add((String)workPackageArt.getGuid());
            }
        }
        return guids;
    }

    private void addStateTypeNameAndAttributeCriteria() {
        this.addStateTypeCriteria();
        this.addStateNameCriteria();
        this.addAttributeCriteria();
        this.addRelationCriteria();
    }

    public IAtsWorkItemFilter createFilter() {
        return new AtsWorkItemFilter(this.getItems(), this.services);
    }

    public IAtsQuery andReleased(ReleasedOption releasedOption) {
        this.releasedOption = releasedOption;
        return this;
    }

    public List<AtsAttributeQuery> getTeamWorkflowAttr() {
        return this.teamWorkflowAttr;
    }

    public IAtsQuery andTeamWorkflowAttr(AttributeTypeId attributeType, List<String> values, QueryOption ... queryOptions) {
        this.teamWorkflowAttr.add(new AtsAttributeQuery(attributeType, values, queryOptions));
        return this;
    }

    public IAtsQuery andFilter(IAtsQueryFilter queryFilter) {
        this.queryFilters.add(queryFilter);
        return this;
    }

    public boolean exists() {
        return !this.getItemIds().isEmpty();
    }

    public IAtsQuery andTag(String ... tags) {
        List<String> values = Arrays.asList(tags);
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.StaticId, values, QueryOption.EXACT_MATCH_OPTIONS);
    }

    public IAtsQuery andActive(boolean active) {
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.Active, active ? "true" : "false", new QueryOption[0]);
    }

    public <T extends IAtsWorkItem> Collection<T> getItems(Class<T> clazz) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getItems());
    }

    public IAtsQuery andName(String name) {
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.Name, name, new QueryOption[0]);
    }
}

