/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.query.IAtsQueryFilter;
import org.eclipse.osee.ats.core.query.AtsAttributeQuery;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class AbstractAtsConfigQueryImpl
implements IAtsConfigQuery {
    protected final List<AtsAttributeQuery> andAttr;
    protected List<IArtifactType> artifactTypes;
    protected Collection<Long> uuids;
    protected final IAtsServices services;
    protected Collection<Long> aiUuids;
    protected List<ArtifactId> onlyIds = null;
    protected final List<IAtsQueryFilter> queryFilters;

    public AbstractAtsConfigQueryImpl(IAtsServices services) {
        this.services = services;
        this.andAttr = new ArrayList<AtsAttributeQuery>();
        this.aiUuids = new ArrayList<Long>();
        this.uuids = new ArrayList<Long>();
        this.queryFilters = new ArrayList<IAtsQueryFilter>();
    }

    public Collection<ArtifactId> getItemIds() throws OseeCoreException {
        this.onlyIds = new LinkedList<ArtifactId>();
        this.getItems();
        return this.onlyIds;
    }

    public abstract void createQueryBuilder();

    public <T extends IAtsConfigObject> Collection<T> getItems() {
        this.createQueryBuilder();
        if (this.artifactTypes != null) {
            this.queryAndIsOfType(this.artifactTypes);
        }
        if (this.uuids != null && this.uuids.size() > 0) {
            this.addUuidCriteria(this.uuids);
        }
        this.addAttributeCriteria();
        HashSet allResults = new HashSet();
        this.collectResults(allResults, this.artifactTypes);
        return allResults;
    }

    public abstract Collection<ArtifactId> runQuery();

    private <T> Collection<T> collectResults(Set<T> allResults, List<IArtifactType> artifactTypes) {
        HashSet<T> results = new HashSet<T>();
        if (this.isOnlyIds()) {
            this.onlyIds.addAll(this.queryGetIds());
        } else {
            Collection<ArtifactId> artifacts = this.runQuery();
            for (ArtifactId artifact : artifacts) {
                if (artifactTypes == null && !this.isArtifactTypeMatch(artifact, artifactTypes)) continue;
                results.add(this.createFromFactory(artifact));
            }
        }
        this.addtoResultsWithNullCheck(allResults, results);
        return results;
    }

    private <T> T createFromFactory(ArtifactId artifact) {
        return (T)this.services.getConfigItemFactory().getConfigObject(artifact);
    }

    private <T> void addtoResultsWithNullCheck(Set<T> allResults, Collection<? extends T> configObjects) {
        if (configObjects.contains(null)) {
            OseeLog.log(AbstractAtsConfigQueryImpl.class, (Level)Level.SEVERE, (String)"Null found in results");
        } else {
            allResults.addAll(configObjects);
        }
    }

    private boolean isArtifactTypeMatch(ArtifactId artifact, List<IArtifactType> artTypes) {
        if (artTypes == null || artTypes.isEmpty()) {
            return true;
        }
        for (IArtifactType artType : artTypes) {
            if (!this.services.getArtifactResolver().isOfType(artifact, artType)) continue;
            return true;
        }
        return false;
    }

    public abstract void queryAndNotExists(RelationTypeSide var1);

    public abstract void queryAndExists(RelationTypeSide var1);

    public abstract void queryAndIsOfType(IArtifactType var1);

    public boolean isOnlyIds() {
        return this.onlyIds != null;
    }

    public abstract List<? extends ArtifactId> queryGetIds();

    public IAtsConfigQuery isOfType(IArtifactType ... artifactType) {
        if (this.artifactTypes != null) {
            throw new OseeArgumentException("Can only specify one artifact type", new Object[0]);
        }
        this.artifactTypes = new LinkedList<IArtifactType>();
        IArtifactType[] iArtifactTypeArray = artifactType;
        int n = artifactType.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactType type = iArtifactTypeArray[n2];
            this.artifactTypes.add(type);
            ++n2;
        }
        return this;
    }

    public IAtsConfigQuery andAttr(AttributeTypeId attributeType, Collection<String> values, QueryOption ... queryOptions) throws OseeCoreException {
        this.andAttr.add(new AtsAttributeQuery(attributeType, values, queryOptions));
        return this;
    }

    public IAtsConfigQuery andUuids(Long ... uuids) {
        this.uuids = Arrays.asList(uuids);
        return this;
    }

    public IAtsConfigQuery andAttr(AttributeTypeId attributeType, String value, QueryOption ... queryOption) {
        return this.andAttr(attributeType, Collections.singleton(value), queryOption);
    }

    public <T extends IAtsConfigObject> ResultSet<T> getResults() {
        return ResultSets.newResultSet(this.getItems());
    }

    public <T extends ArtifactId> ResultSet<T> getResultArtifacts() {
        ArrayList<ArtifactToken> items = new ArrayList<ArtifactToken>();
        ResultSet<T> results = this.getResults();
        for (IAtsConfigObject configObject : results) {
            if (configObject == null) {
                OseeLog.log(AbstractAtsConfigQueryImpl.class, (Level)Level.SEVERE, (String)"Null found in results");
                continue;
            }
            items.add(this.services.getArtifact((IAtsObject)configObject));
        }
        LinkedList<ArtifactId> artifacts = new LinkedList<ArtifactId>();
        for (ArtifactId artifact : items) {
            boolean artifactTypeMatch = this.isArtifactTypeMatch(artifact, this.artifactTypes);
            if (!artifactTypeMatch) continue;
            artifacts.add(artifact);
        }
        return ResultSets.newResultSet(artifacts);
    }

    public abstract void queryAndIsOfType(List<IArtifactType> var1);

    public abstract void queryAnd(AttributeTypeId var1, String var2);

    private void addAttributeCriteria() {
        if (!this.andAttr.isEmpty()) {
            for (AtsAttributeQuery attrQuery : this.andAttr) {
                this.queryAnd(attrQuery.getAttrType(), attrQuery.getValues(), attrQuery.getQueryOption());
            }
        }
    }

    public abstract void queryAnd(AttributeTypeId var1, Collection<String> var2, QueryOption[] var3);

    public abstract void queryAnd(AttributeTypeId var1, String var2, QueryOption[] var3);

    private void addUuidCriteria(Collection<Long> uuids) {
        if (uuids != null) {
            LinkedList<Integer> artIds = new LinkedList<Integer>();
            for (Long uuid : uuids) {
                artIds.add(uuid.intValue());
            }
            this.queryAndLocalIds(artIds);
        }
    }

    public abstract void queryAndLocalIds(List<Integer> var1);

    public abstract void queryAnd(AttributeTypeId var1, Collection<String> var2);

    public Collection<IArtifactType> getArtifactTypes() {
        return this.artifactTypes;
    }

    public void setArtifactType(List<IArtifactType> artifactTypes) {
        this.artifactTypes = artifactTypes;
    }

    public IAtsConfigQuery andProgram(IAtsProgram program) {
        return this.andProgram(program.getId());
    }

    public IAtsConfigQuery andProgram(Long uuid) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.ProgramUuid, Collections.singleton(String.valueOf(uuid)), new QueryOption[0]);
    }

    public IAtsConfigQuery andWorkType(WorkType workType, WorkType ... workTypes) {
        LinkedList<String> workTypeStrs = new LinkedList<String>();
        workTypeStrs.add(workType.name());
        WorkType[] workTypeArray = workTypes;
        int n = workTypes.length;
        int n2 = 0;
        while (n2 < n) {
            WorkType workType2 = workTypeArray[n2];
            workTypeStrs.add(workType2.name());
            ++n2;
        }
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, workTypeStrs, new QueryOption[0]);
    }

    public IAtsConfigQuery andCsci(Collection<String> cscis) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.CSCI, cscis, new QueryOption[0]);
    }

    public IAtsConfigQuery andName(String name) {
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.Name, name, new QueryOption[0]);
    }

    public IAtsConfigQuery andWorkType(Collection<WorkType> workTypes) {
        LinkedList<String> workTypeStrs = new LinkedList<String>();
        for (WorkType workType2 : workTypes) {
            workTypeStrs.add(workType2.name());
        }
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, workTypeStrs, new QueryOption[0]);
    }

    public IAtsConfigQuery andTag(String ... tags) {
        List<String> values = Arrays.asList(tags);
        return this.andAttr((AttributeTypeId)CoreAttributeTypes.StaticId, values, QueryOption.EXACT_MATCH_OPTIONS);
    }

    public IAtsConfigQuery andActive(boolean active) {
        return this.andAttr((AttributeTypeId)AtsAttributeTypes.Active, active ? "true" : "false", new QueryOption[0]);
    }

    public <T extends IAtsConfigObject> Collection<T> getItems(Class<T> clazz) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll(this.getItems());
    }

    public <T extends IAtsConfigObject> T getOneOrNull(Class<T> clazz) {
        Collection<T> items = this.getItems(clazz);
        if (!items.isEmpty()) {
            return (T)((IAtsConfigObject)items.iterator().next());
        }
        return null;
    }
}

