/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.program;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.program.IAtsProgramService;
import org.eclipse.osee.ats.api.program.ProjectType;
import org.eclipse.osee.ats.api.query.IAtsConfigQuery;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsProgramService
implements IAtsProgramService {
    private static IAtsServices services;
    static CacheLoader<IAtsTeamDefinition, IAtsProgram> teamDefToAtsProgramCacheLoader;
    private static final LoadingCache<IAtsTeamDefinition, IAtsProgram> teamDefToAtsProgramCache;

    static {
        teamDefToAtsProgramCacheLoader = new CacheLoader<IAtsTeamDefinition, IAtsProgram>(){

            public IAtsProgram load(IAtsTeamDefinition teamDef) {
                return AtsProgramService.loadProgram(teamDef);
            }
        };
        teamDefToAtsProgramCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(teamDefToAtsProgramCacheLoader);
    }

    public AtsProgramService(IAtsServices services) {
        AtsProgramService.services = services;
    }

    public Collection<IAtsInsertionActivity> getInsertionActivities(IAtsInsertion insertion) {
        ArrayList<IAtsInsertionActivity> insertionActivitys = new ArrayList<IAtsInsertionActivity>();
        for (ArtifactId artifact : services.getRelationResolver().getRelated((ArtifactId)services.getArtifact(insertion.getId()), AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
            insertionActivitys.add(services.getConfigItemFactory().getInsertionActivity(artifact));
        }
        return insertionActivitys;
    }

    public IAtsInsertionActivity getInsertionActivity(Long insertionActivityUuid) {
        return services.getConfigItemFactory().getInsertionActivity((ArtifactId)services.getArtifact(insertionActivityUuid));
    }

    public IAtsWorkPackage getWorkPackage(Long workPackageUuid) {
        return services.getConfigItemFactory().getWorkPackage((ArtifactId)services.getArtifact(workPackageUuid));
    }

    public IAtsInsertionActivity getInsertionActivity(IAtsWorkPackage workPackage) {
        ArtifactToken wpArt = services.getArtifact(workPackage.getId());
        Collection related = services.getRelationResolver().getRelated((ArtifactId)wpArt, AtsRelationTypes.InsertionActivityToWorkPackage_InsertionActivity);
        if (related.size() > 0) {
            return services.getConfigItemFactory().getInsertionActivity((ArtifactId)related.iterator().next());
        }
        return null;
    }

    public IAtsInsertion getInsertion(IAtsInsertionActivity activity) {
        Collection related = services.getRelationResolver().getRelated((ArtifactId)activity.getStoreObject(), AtsRelationTypes.InsertionToInsertionActivity_Insertion);
        if (related.size() > 0) {
            return services.getConfigItemFactory().getInsertion((ArtifactId)related.iterator().next());
        }
        return null;
    }

    public IAtsProgram getProgram(IAtsInsertion insertion) {
        Collection related = services.getRelationResolver().getRelated((ArtifactId)insertion.getStoreObject(), AtsRelationTypes.ProgramToInsertion_Program);
        if (related.size() > 0) {
            return services.getConfigItemFactory().getProgram((ArtifactId)related.iterator().next());
        }
        return null;
    }

    public void setWorkPackage(IAtsWorkPackage workPackage, List<IAtsWorkItem> workItems, IAtsUser asUser) {
        IAtsChangeSet changes = services.getStoreService().createAtsChangeSet("Set Work Package", asUser);
        for (IAtsWorkItem workItem : workItems) {
            if (workPackage == null) {
                changes.deleteSoleAttribute(workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid);
                continue;
            }
            changes.setSoleAttributeValue(workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, workPackage.getGuid());
        }
        if (!changes.isEmpty()) {
            changes.execute();
        }
    }

    public IAtsInsertion getInsertion(Long insertionUuid) {
        return services.getConfigItemFactory().getInsertion((ArtifactId)services.getArtifact(insertionUuid));
    }

    public Collection<IAtsInsertion> getInsertions(IAtsProgram program) {
        ArrayList<IAtsInsertion> insertions = new ArrayList<IAtsInsertion>();
        for (ArtifactId artifact : services.getRelationResolver().getRelated((ArtifactId)services.getArtifact(program.getId()), AtsRelationTypes.ProgramToInsertion_Insertion)) {
            insertions.add(services.getConfigItemFactory().getInsertion(artifact));
        }
        return insertions;
    }

    public IAtsProgram getProgramByGuid(String guid) {
        ArtifactToken prgArt = services.getArtifactById(guid);
        return services.getConfigItemFactory().getProgram((ArtifactId)prgArt);
    }

    public Collection<IAtsProgram> getPrograms() {
        ArrayList<IAtsProgram> programs = new ArrayList<IAtsProgram>();
        for (ArtifactId artifact : services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.Program}).getResultArtifacts()) {
            programs.add(services.getConfigItemFactory().getProgram(artifact));
        }
        return programs;
    }

    public IAtsProgram getProgram(Long programUuid) {
        return services.getConfigItemFactory().getProgram((ArtifactId)services.getArtifact(programUuid));
    }

    public List<IAtsProgram> getPrograms(IAtsCountry atsCountry) {
        LinkedList<IAtsProgram> programs = new LinkedList<IAtsProgram>();
        ArtifactToken artifact = atsCountry.getStoreObject();
        if (artifact != null) {
            for (ArtifactId related : services.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.CountryToProgram_Program)) {
                programs.add(services.getConfigItemFactory().getProgram(related));
            }
        }
        return programs;
    }

    public IAtsCountry getCountry(IAtsProgram atsProgram) {
        ArtifactToken countryArt;
        IAtsCountry country = null;
        ArtifactToken artifact = atsProgram.getStoreObject();
        if (artifact != null && (countryArt = services.getRelationResolver().getRelatedOrNull((ArtifactId)artifact, AtsRelationTypes.CountryToProgram_Country)) != null) {
            country = services.getConfigItemFactory().getCountry((ArtifactId)countryArt);
        }
        return country;
    }

    public IAtsProgram getProgram(IAtsWorkItem workItem) {
        IAtsTeamDefinition teamDef = workItem.getParentTeamWorkflow().getTeamDefinition();
        return this.getProgram(teamDef);
    }

    public IAtsProgram getProgram(IAtsTeamDefinition teamDef) {
        try {
            return (IAtsProgram)teamDefToAtsProgramCache.get((Object)teamDef);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static IAtsProgram loadProgram(IAtsTeamDefinition teamDef) {
        IAtsTeamDefinition topTeamDef;
        IAtsProgram program = null;
        Object object = services.getAttributeResolver().getSoleAttributeValue((IAtsObject)teamDef, (AttributeTypeId)AtsAttributeTypes.ProgramUuid, null);
        if (object instanceof ArtifactId) {
            program = services.getConfigItemFactory().getProgram((ArtifactId)object);
        } else if (object instanceof String && Strings.isNumeric((String)((String)object))) {
            program = services.getProgramService().getProgram(Long.valueOf(Long.parseLong((String)object)));
        }
        if (program == null && (topTeamDef = teamDef.getTeamDefinitionHoldingVersions()) != null && !teamDef.equals(topTeamDef)) {
            program = AtsProgramService.loadProgram(teamDef.getParentTeamDef());
        }
        if (program == null) {
            program = (IAtsProgram)services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.Program}).andAttr((AttributeTypeId)AtsAttributeTypes.TeamDefinition, services.getStoreService().getGuid((IAtsObject)teamDef), new QueryOption[0]).getResults().getOneOrNull();
        }
        return program;
    }

    public String getDescription(IAtsProgram program) {
        return (String)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeId)AtsAttributeTypes.Description, (Object)"");
    }

    public IAtsTeamDefinition getTeamDefHoldingVersions(IAtsProgram program) throws OseeCoreException {
        return this.getTeamDefinition(program);
    }

    public IAtsTeamDefinition getTeamDefinition(IAtsProgram program) {
        IAtsTeamDefinition teamDefinition = null;
        String guid = (String)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeId)AtsAttributeTypes.TeamDefinition, (Object)"");
        if (Strings.isValid((String)guid)) {
            teamDefinition = (IAtsTeamDefinition)services.getConfigItem(guid);
        }
        return teamDefinition;
    }

    public Collection<IAtsActionableItem> getAis(IAtsProgram program) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.ActionableItem}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramUuid, String.valueOf(program.getId()), new QueryOption[0]).getResults().getList());
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(IAtsProgram program) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.TeamDefinition}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramUuid, String.valueOf(program.getId()), new QueryOption[0]).getResults().getList());
    }

    public Collection<IAtsProgram> getPrograms(IArtifactType artifactType) {
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)services.getQueryService().createQuery(new IArtifactType[]{artifactType}).getResults().getList());
    }

    public Collection<String> getCscis(IAtsProgram program) {
        return services.getAttributeResolver().getAttributesToStringList((IAtsObject)program, (AttributeTypeId)AtsAttributeTypes.CSCI);
    }

    public Collection<IAtsActionableItem> getAis(IAtsProgram program, WorkType workType) throws OseeCoreException {
        return this.getAis(program, Collections.singleton(workType));
    }

    public Collection<IAtsActionableItem> getAis(IAtsProgram program, Collection<WorkType> workTypes) throws OseeCoreException {
        IAtsConfigQuery query = services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.ActionableItem}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramUuid, String.valueOf(program.getId()), new QueryOption[0]);
        LinkedList<String> types = new LinkedList<String>();
        for (WorkType type : workTypes) {
            types.add(type.name());
        }
        query.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, types, QueryOption.EXACT_MATCH_OPTIONS);
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)query.getResults().getList());
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(IAtsProgram program, Collection<WorkType> workTypes) throws OseeCoreException {
        IAtsConfigQuery query = services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.TeamDefinition}).andAttr((AttributeTypeId)AtsAttributeTypes.ProgramUuid, String.valueOf(program.getId()), new QueryOption[0]);
        LinkedList<String> types = new LinkedList<String>();
        for (WorkType type : workTypes) {
            types.add(type.name());
        }
        query.andAttr((AttributeTypeId)AtsAttributeTypes.WorkType, types, QueryOption.EXACT_MATCH_OPTIONS);
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)query.getResults().getList());
    }

    public WorkType getWorkType(IAtsTeamWorkflow teamWf) {
        WorkType workType = WorkType.None;
        try {
            IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
            String typeStr = services.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)teamDef, (AttributeTypeId)AtsAttributeTypes.WorkType, "");
            if (Strings.isValid((String)typeStr)) {
                workType = WorkType.valueOf((String)typeStr);
            }
        }
        catch (Exception exception) {
            workType = WorkType.Custom;
        }
        return workType;
    }

    public ProjectType getProjectType(IAtsProgram program) {
        if (services.getAttributeResolver().getAttributeCount((IAtsObject)program, (AttributeTypeId)AtsAttributeTypes.CSCI) > 1) {
            return ProjectType.MultiProcessor;
        }
        return ProjectType.SingleProcessor;
    }

    public String getNamespace(IAtsProgram program) {
        return (String)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeId)AtsAttributeTypes.Namespace, (Object)"");
    }

    public long getCountryUuid(IAtsProgram program) {
        long countryUuid = 0L;
        ArtifactToken countryArt = services.getRelationResolver().getRelatedOrNull((IAtsObject)program, AtsRelationTypes.CountryToProgram_Country);
        if (countryArt != null) {
            countryUuid = countryArt.getId();
        }
        return countryUuid;
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, WorkType workType, IAtsWorkItem workItem) throws OseeCoreException {
        return this.getWorkflows(program, Collections.singleton(workType), workItem);
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program) throws OseeCoreException {
        Collection<IAtsTeamDefinition> workTypeTeamDefs = this.getTeamDefs(program);
        return services.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andTeam(workTypeTeamDefs).getItems(IAtsTeamWorkflow.class);
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, Collection<WorkType> workTypes, IAtsWorkItem workItem) throws OseeCoreException {
        if (workTypes.contains(WorkType.All)) {
            throw new OseeArgumentException("Invalid option ALL for getWorkflow", new Object[0]);
        }
        HashSet<IAtsTeamWorkflow> teamArts = new HashSet<IAtsTeamWorkflow>();
        Collection<IAtsTeamDefinition> workTypeTeamDefs = this.getTeamDefs(program, workTypes);
        if (workTypeTeamDefs.size() > 0) {
            IAtsWorkItem useWorkItem = workItem;
            if (useWorkItem instanceof IAtsTask) {
                useWorkItem = ((IAtsTask)useWorkItem).getParentAction();
            }
            if (useWorkItem instanceof IAtsTeamWorkflow) {
                useWorkItem = ((IAtsTeamWorkflow)useWorkItem).getParentAction();
            }
            if (useWorkItem != null && useWorkItem instanceof IAtsAction) {
                for (IAtsTeamWorkflow team : services.getWorkItemService().getTeams((Object)useWorkItem)) {
                    if (!workTypeTeamDefs.contains(team.getTeamDefinition())) continue;
                    teamArts.add(team);
                }
            }
        }
        return teamArts;
    }

    public boolean isActive(IAtsProgram program) {
        return (Boolean)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)program, (AttributeTypeId)AtsAttributeTypes.Active, (Object)true);
    }

    public Collection<IAtsTeamDefinition> getTeamDefs(IAtsProgram program, WorkType workType) {
        return this.getTeamDefs(program, Collections.singleton(workType));
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, Collection<WorkType> workTypes) {
        Collection teamDefs = services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.TeamDefinition}).andProgram(program).andWorkType(workTypes).getItems();
        return org.eclipse.osee.framework.jdk.core.util.Collections.castAll((Collection)services.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andTeam(teamDefs).getResults().getList());
    }

    public Collection<IAtsVersion> getVersions(IAtsProgram program) {
        IAtsTeamDefinition teamDefHoldingVersions = services.getProgramService().getTeamDefHoldingVersions(program);
        if (teamDefHoldingVersions != null) {
            return teamDefHoldingVersions.getVersions();
        }
        return Collections.emptyList();
    }

    public Collection<IAtsTeamWorkflow> getWorkflows(IAtsProgram program, WorkType workType) {
        return this.getWorkflows(program, Collections.singleton(workType));
    }

    public IAtsVersion getVersion(IAtsProgram program, String versionName) {
        for (IAtsVersion version : this.getVersions(program)) {
            if (!version.getName().equals(versionName)) continue;
            return version;
        }
        return null;
    }
}

