/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.model.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class WorkStateImpl
implements WorkState {
    private String name;
    private final List<IAtsUser> assignees = new LinkedList<IAtsUser>();
    private double hoursSpent = 0.0;
    private int percentComplete = 0;

    public WorkStateImpl(String name, List<? extends IAtsUser> assignees) {
        this(name, assignees, 0.0, 0);
    }

    public WorkStateImpl(String name, List<? extends IAtsUser> assignees, double hoursSpent, int percentComplete) {
        this.name = name;
        this.assignees.addAll(assignees);
        this.hoursSpent = hoursSpent;
        this.percentComplete = percentComplete;
    }

    public void setHoursSpent(double hoursSpent) {
        this.hoursSpent = hoursSpent;
    }

    public void setPercentComplete(int percentComplete) {
        this.percentComplete = percentComplete;
    }

    public WorkStateImpl(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<IAtsUser> getAssignees() {
        return this.assignees;
    }

    public double getHoursSpent() {
        return this.hoursSpent;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void addAssignee(IAtsUser user) {
        Conditions.checkNotNull((Object)user, (String)"user");
        if (!this.assignees.contains(user)) {
            this.assignees.add(user);
        }
    }

    public void setAssignees(List<? extends IAtsUser> users) {
        this.assignees.clear();
        for (IAtsUser iAtsUser : users) {
            this.addAssignee(iAtsUser);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void removeAssignee(IAtsUser assignee) {
        this.assignees.remove(assignee);
    }
}

