/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.core.model.impl.AtsObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;

public abstract class AtsConfigObject
extends AtsObject
implements IAtsConfigObject {
    protected final ArtifactToken artifact;
    protected final Log logger;
    protected final IAtsServices services;

    public AtsConfigObject(Log logger, IAtsServices services, ArtifactToken artifact) {
        super(artifact.getName(), artifact.getId());
        this.logger = logger;
        this.services = services;
        this.artifact = artifact;
        this.setStoreObject(artifact);
    }

    public Log getLogger() {
        return this.logger;
    }

    public IAtsServices getAtsServices() {
        return this.services;
    }

    public void setFullName(String fullName) {
        throw new UnsupportedOperationException("TeamDefinition.setFullName not implemented yet");
    }

    public abstract String getTypeName();

    public String getFullName() {
        return this.getTypeName();
    }

    public void setActionable(boolean actionable) {
        throw new UnsupportedOperationException("TeamDefinition.setActionable not implemented yet");
    }

    public boolean isActionable() {
        return (Boolean)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.Actionable, false);
    }

    protected <T> T getAttributeValue(AttributeTypeId attributeType, Object defaultValue) {
        Object value = null;
        try {
            value = this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, attributeType, defaultValue);
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting attribute value for - attributeType[%s]", new Object[]{attributeType});
        }
        return (T)value;
    }

    public boolean isActive() {
        return (Boolean)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, false);
    }

    public Collection<String> getStaticIds() {
        List<String> results = Collections.emptyList();
        try {
            results = this.services.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, (AttributeTypeId)CoreAttributeTypes.StaticId);
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting static Ids", new Object[0]);
        }
        return results;
    }

    public Collection<IAtsUser> getLeads() {
        return this.getRelatedUsers(AtsRelationTypes.TeamLead_Lead);
    }

    public Collection<IAtsUser> getSubscribed() {
        return this.getRelatedUsers(AtsRelationTypes.SubscribedUser_User);
    }

    protected Collection<IAtsUser> getRelatedUsers(RelationTypeSide relation) {
        HashSet<IAtsUser> results = new HashSet<IAtsUser>();
        try {
            for (Object userArt : this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, relation)) {
                IAtsUser lead = this.services.getUserService().getUserById((String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)userArt, (AttributeTypeId)CoreAttributeTypes.UserId, null));
                results.add(lead);
            }
        }
        catch (OseeCoreException ex) {
            this.logger.error((Throwable)ex, "Error getting related Users for relationTypeSide[%s]", new Object[]{relation});
        }
        return results;
    }

    @Override
    public ArtifactToken getStoreObject() {
        return this.artifact != null ? this.artifact : super.getStoreObject();
    }

    public Long getId() {
        return this.artifact.getId();
    }

    @Override
    public String getDescription() {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.Description, (Object)"");
    }
}

