/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.model;

import java.util.Date;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.AtsWorkPackageType;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.logger.Log;

public class WorkPackage
extends AtsConfigObject
implements IAtsWorkPackage {
    private ArtifactToken artifact;
    private final IAtsServices services;

    public WorkPackage(Log logger, ArtifactToken artifact, IAtsServices services) {
        super(logger, services, artifact);
        this.artifact = artifact;
        this.services = services;
    }

    public String getActivityId() throws OseeCoreException {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.ActivityId, (Object)"");
    }

    public String getActivityName() throws OseeCoreException {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.ActivityName, (Object)"");
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getGuid() {
        return (String)this.artifact.getGuid();
    }

    public String getWorkPackageId() throws OseeCoreException {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.WorkPackageId, (Object)"");
    }

    public String getWorkPackageProgram() throws OseeCoreException {
        return (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.WorkPackageProgram, (Object)"");
    }

    public AtsWorkPackageType getWorkPackageType() throws OseeCoreException {
        String value = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.WorkPackageType, (Object)"");
        AtsWorkPackageType type = AtsWorkPackageType.None;
        if (Strings.isValid((String)value)) {
            try {
                type = AtsWorkPackageType.valueOf((String)value);
                return type;
            }
            catch (Exception exception) {}
        }
        return type;
    }

    @Override
    public boolean isActive() throws OseeCoreException {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.Active, (Object)true);
    }

    public Date getStartDate() throws OseeCoreException {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.StartDate, null);
    }

    public Date getEndDate() throws OseeCoreException {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.EndDate, null);
    }

    public int getWorkPackagePercent() throws OseeCoreException {
        return (Integer)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.PercentComplete, (Object)0);
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder(this.getActivityId());
            this.addWithHypen(builder, this.getActivityName());
            this.addWithHypen(builder, this.getWorkPackageId());
            this.addWithHypen(builder, this.getName());
            return builder.toString();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(WorkPackage.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return String.format("%s - Exception (see log file)", this.getName());
        }
    }

    private void addWithHypen(StringBuilder builder, String value) {
        if (Strings.isValid((String)value)) {
            builder.append(" - ");
            builder.append(value);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getGuid() == null ? 0 : this.getGuid().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IAtsWorkPackage other = (IAtsWorkPackage)obj;
        return !(this.getGuid() == null ? other.getGuid() != null : !this.getGuid().equals(other.getGuid()));
    }

    @Override
    public Long getId() {
        return this.artifact.getId();
    }

    @Override
    public ArtifactToken getStoreObject() {
        return this.artifact;
    }

    @Override
    public void setStoreObject(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    public int compareTo(Named other) {
        return this.artifact.compareTo(other);
    }

    @Override
    public String getTypeName() {
        return this.artifact.getArtifactType().getName();
    }
}

