/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class UsersByIds {
    public Pattern userPattern = Pattern.compile("<(.*?)>");

    public String getStorageString(Collection<IAtsUser> users) throws OseeCoreException {
        StringBuffer sb = new StringBuffer();
        for (IAtsUser u : users) {
            sb.append("<" + u.getUserId() + ">");
        }
        return sb.toString();
    }

    public List<IAtsUser> getUsers(String sorageString, IAtsUserService userService) {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        Matcher m = this.userPattern.matcher(sorageString);
        while (m.find()) {
            String userId = m.group(1);
            if (!Strings.isValid((String)userId)) {
                throw new IllegalArgumentException("Blank userId specified.");
            }
            try {
                IAtsUser u = userService.getUserById(m.group(1));
                users.add(u);
            }
            catch (Exception ex) {
                OseeLog.log(UsersByIds.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return users;
    }
}

