/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.internal.state.StateManager;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class StateManagerReader {
    private final StateManager stateMgr;
    private final IAttributeResolver attrResolver;
    private final IAtsWorkItem workItem;
    private final IAtsWorkStateFactory workStateFactory;

    public StateManagerReader(IAtsWorkItem workItem, StateManager stateMgr, IAttributeResolver attrResolver, IAtsWorkStateFactory workStateFactory) {
        this.workItem = workItem;
        this.stateMgr = stateMgr;
        this.attrResolver = attrResolver;
        this.workStateFactory = workStateFactory;
    }

    public synchronized void load() throws OseeCoreException {
        String currentStateXml = (String)this.attrResolver.getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.CurrentState, (Object)"");
        if (Strings.isValid((String)currentStateXml)) {
            WorkState currentState = this.workStateFactory.fromStoreStr(currentStateXml);
            this.stateMgr.setCurrentStateName(currentState.getName());
            this.stateMgr.addState(currentState);
            for (String stateXml : this.attrResolver.getAttributesToStringList((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.State)) {
                WorkState state = this.workStateFactory.fromStoreStr(stateXml);
                if (state.getName().equals(currentState.getName()) || state.getName().equals(currentState.getName())) continue;
                this.stateMgr.addState(state);
            }
        }
        Integer percentComplete = (Integer)this.attrResolver.getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.PercentComplete, null);
        this.stateMgr.setPercentCompleteValue(percentComplete);
        this.stateMgr.setDirty(false);
        this.stateMgr.getInitialAssignees().addAll(this.stateMgr.getAssignees());
    }
}

