/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.WorkState;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.WorkStateFactory;
import org.eclipse.osee.ats.core.model.impl.WorkStateImpl;
import org.eclipse.osee.ats.core.users.AtsCoreUsers;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.util.AtsUtilCore;
import org.eclipse.osee.ats.core.util.HoursSpentUtil;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.core.workflow.state.SimpleTeamState;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.logging.OseeLog;

public class StateManager
implements IAtsStateManager {
    private final IAtsWorkItem workItem;
    private String currentStateName;
    private final List<WorkState> states = new CopyOnWriteArrayList<WorkState>();
    private final WorkStateFactory factory;
    private Integer percentCompleteValue = 0;
    private final List<IAtsUser> initialAssignees = new ArrayList<IAtsUser>();
    private boolean dirty = false;
    private final String instanceGuid;
    private final IAtsLogFactory logFactory;
    private final IAtsServices services;

    public StateManager(IAtsWorkItem workItem, IAtsLogFactory logFactory, IAtsServices services) {
        this.workItem = workItem;
        this.logFactory = logFactory;
        this.services = services;
        this.factory = this;
        this.instanceGuid = GUID.create();
    }

    public String getCurrentStateName() {
        return this.currentStateName;
    }

    public IStateToken getCurrentState() {
        return new SimpleTeamState(this.getCurrentStateName(), this.getCurrentStateType());
    }

    public StateType getCurrentStateType() {
        StateType type = StateType.valueOf((String)((String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.CurrentStateType, (Object)"Working")));
        return type;
    }

    public void updateMetrics(IStateToken state, double additionalHours, int percentComplete, boolean logMetrics, IAtsUser user) throws OseeCoreException {
        double hoursInCurrentState = this.getHoursSpent(state.getName());
        double remaining = hoursInCurrentState + additionalHours;
        if (remaining < 0.0) {
            this.setHoursSpent(state.getName(), 0.0);
            for (String stateName : this.getVisitedStateNames()) {
                hoursInCurrentState = this.getHoursSpent(stateName);
                if ((remaining += hoursInCurrentState) < 0.0) {
                    this.setHoursSpent(stateName, 0.0);
                    continue;
                }
                this.setHoursSpent(stateName, remaining);
                break;
            }
        } else {
            this.setHoursSpent(state.getName(), remaining);
        }
        if (this.services.getWorkDefService().isStateWeightingEnabled(this.workItem.getWorkDefinition())) {
            this.setPercentComplete(state.getName(), percentComplete);
        } else {
            this.percentCompleteValue = percentComplete;
        }
        if (logMetrics) {
            this.logMetrics(this.workItem.getStateMgr().getCurrentState(), user, new Date());
        }
        this.setDirty(true);
    }

    protected void logMetrics(IStateToken state, IAtsUser user, Date date) throws OseeCoreException {
        String hoursSpent = AtsUtilCore.doubleToI18nString(HoursSpentUtil.getHoursSpentTotal((IAtsObject)this.workItem, this.services));
        StateManager.logMetrics(this.services, this.logFactory, this.workItem, String.valueOf(PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)this.workItem, this.services)), hoursSpent, state, user, date);
    }

    public static void logMetrics(IAtsServices services, IAtsLogFactory logFactory, IAtsWorkItem workItem, String percent, String hours, IStateToken state, IAtsUser user, Date date) throws OseeCoreException {
        IAtsLogItem logItem = logFactory.newLogItem(LogType.Metrics, date, user, state.getName(), String.format("Percent %s Hours %s", PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)workItem, services), Double.parseDouble(hours)));
        workItem.getLog().addLogItem(logItem);
    }

    public void setMetrics(double hours, int percentComplete, boolean logMetrics, IAtsUser user, Date date) throws OseeCoreException {
        this.setMetrics(this.getCurrentState(), hours, percentComplete, logMetrics, user, date);
    }

    protected boolean isHoursEqual(double hours1, double hours2) {
        return Math.abs(hours2 - hours1) < 0.01;
    }

    public void setMetrics(IStateToken state, double hours, int percentComplete, boolean logMetrics, IAtsUser user, Date date) throws OseeCoreException {
        boolean changed = this.setMetricsIfChanged(state, hours, percentComplete);
        if (changed) {
            if (logMetrics) {
                this.logMetrics(this.workItem.getStateMgr().getCurrentState(), user, new Date());
            }
            this.setDirty(true);
        }
    }

    protected boolean setMetricsIfChanged(IStateToken state, double hours, int percentComplete) throws OseeCoreException {
        boolean changed = false;
        if (!this.isHoursEqual(this.getHoursSpent(state.getName()), hours)) {
            this.setHoursSpent(state.getName(), hours);
            changed = true;
        }
        if (percentComplete != this.getPercentComplete(state.getName())) {
            this.setPercentComplete(state.getName(), percentComplete);
            changed = true;
        }
        return changed;
    }

    public StateType getStateType() throws OseeCoreException {
        return StateType.valueOf((String)((String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeId)AtsAttributeTypes.CurrentStateType, (Object)StateType.Working.name())));
    }

    public void addAssignees(String stateName, Collection<? extends IAtsUser> assignees) throws OseeCoreException {
        if (assignees == null || assignees.isEmpty()) {
            return;
        }
        for (IAtsUser iAtsUser : assignees) {
            if (AtsCoreUsers.isGuestUser(iAtsUser)) {
                throw new OseeArgumentException("Can not assign workflow to Guest", new Object[0]);
            }
            if (!AtsCoreUsers.isSystemUser(iAtsUser)) continue;
            throw new OseeArgumentException("Can not assign workflow to System User", new Object[0]);
        }
        WorkState workState = this.getState(stateName);
        List currentAssignees = workState.getAssignees();
        for (IAtsUser iAtsUser : assignees) {
            if (currentAssignees.contains(iAtsUser)) continue;
            workState.addAssignee(iAtsUser);
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER)) {
            this.removeAssignee(this.getCurrentStateName(), AtsCoreUsers.UNASSIGNED_USER);
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.SYSTEM_USER)) {
            this.removeAssignee(this.getCurrentStateName(), AtsCoreUsers.SYSTEM_USER);
        }
        this.setDirty(true);
    }

    public String getHoursSpentStr(String stateName) {
        return AtsUtilCore.doubleToI18nString(this.getHoursSpent(stateName), true);
    }

    public void setAssignee(IAtsUser assignee) throws OseeCoreException {
        if (assignee != null) {
            this.setAssignees(Arrays.asList(assignee));
        }
    }

    public void setAssignees(Collection<? extends IAtsUser> assignees) throws OseeCoreException {
        this.setAssignees(this.getCurrentStateName(), new LinkedList<IAtsUser>(assignees));
    }

    public void setAssignees(String stateName, List<? extends IAtsUser> assignees) throws OseeCoreException {
        if (assignees == null) {
            return;
        }
        IAtsStateDefinition stateDef = this.workItem.getWorkDefinition().getStateByName(stateName);
        StateType stateType = stateDef.getStateType();
        if (stateType.isCompletedOrCancelledState()) {
            if (assignees.isEmpty()) {
                return;
            }
            throw new OseeStateException("Can't assign completed/cancelled states.", new Object[0]);
        }
        for (IAtsUser iAtsUser : assignees) {
            if (AtsCoreUsers.isGuestUser(iAtsUser)) {
                throw new OseeArgumentException("Can not assign workflow to Guest", new Object[0]);
            }
            if (!AtsCoreUsers.isSystemUser(iAtsUser)) continue;
            throw new OseeArgumentException("Can not assign workflow to System User", new Object[0]);
        }
        WorkState workState = this.getState(this.getCurrentStateName());
        List currAssignees = workState.getAssignees();
        WorkState nextState = this.getState(stateName);
        ArrayList<? extends IAtsUser> nextAssignees = new ArrayList<IAtsUser>(assignees);
        ArrayList<? extends IAtsUser> notifyNewAssignees = new ArrayList<IAtsUser>(nextAssignees);
        notifyNewAssignees.removeAll(currAssignees);
        nextState.setAssignees(nextAssignees);
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER)) {
            this.removeAssignee(this.getCurrentStateName(), AtsCoreUsers.UNASSIGNED_USER);
        }
        if (this.getAssignees().size() > 1 && this.getAssignees().contains(AtsCoreUsers.SYSTEM_USER)) {
            this.removeAssignee(this.getCurrentStateName(), AtsCoreUsers.SYSTEM_USER);
        }
        this.setDirty(true);
    }

    public void transitionHelper(List<? extends IAtsUser> toAssignees, IStateToken fromState, IStateToken toState, String cancelReason) throws OseeCoreException {
        this.createState(toState);
        this.setAssignees(toState.getName(), toAssignees);
        this.setCurrentStateName(toState.getName());
        this.setDirty(true);
    }

    public long getTimeInState() throws OseeCoreException {
        return this.getTimeInState(this.getCurrentState());
    }

    public long getTimeInState(IStateToken state) throws OseeCoreException {
        if (state == null) {
            return 0L;
        }
        IAtsLogItem logItem = this.getStateStartedData(state);
        if (logItem == null) {
            return 0L;
        }
        return new Date().getTime() - logItem.getDate().getTime();
    }

    public IAtsLogItem getStateStartedData(IStateToken state) throws OseeCoreException {
        return this.getStateStartedData(state.getName());
    }

    public IAtsLogItem getStateStartedData(String stateName) throws OseeCoreException {
        return this.workItem.getLog().getStateEvent(LogType.StateEntered, stateName);
    }

    public void addAssignee(String stateName, IAtsUser assignee) throws OseeCoreException {
        this.addAssignees(stateName, Arrays.asList(assignee));
    }

    public void addState(String stateName, List<? extends IAtsUser> assignees, double hoursSpent, int percentComplete) {
        this.addState(stateName, assignees, hoursSpent, percentComplete, true);
    }

    protected void addState(String name, List<? extends IAtsUser> assignees, double hoursSpent, int percentComplete, boolean logError) {
        if (this.getVisitedStateNames().contains(name)) {
            String errorStr = String.format("Error: Duplicate state [%s] for [%s]", name, this.factory.getId());
            if (logError) {
                OseeLog.log(StateManager.class, (Level)Level.SEVERE, (String)errorStr);
            }
            return;
        }
        this.addState(this.factory.createStateData(name, assignees, hoursSpent, percentComplete));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public WorkState getState(String string) {
        for (WorkState state : this.states) {
            if (!state.getName().equals(string)) continue;
            return state;
        }
        return null;
    }

    public List<IAtsUser> getAssignees(String stateName) {
        return this.getAssigneesForState(stateName);
    }

    public List<IAtsUser> getAssigneesForState(String fromStateName) {
        WorkState state = this.getState(fromStateName);
        if (state != null) {
            return state.getAssignees();
        }
        return Collections.emptyList();
    }

    public List<IAtsUser> getAssignees() throws OseeStateException {
        WorkState state = this.getState(this.getCurrentStateName());
        if (state != null) {
            return state.getAssignees();
        }
        throw new OseeStateException("State not found for %s", new Object[]{this.workItem.toStringWithId()});
    }

    public void setCurrentStateName(String currentStateName) {
        Conditions.assertNotNull((Object)currentStateName, (String)"currentStateName", (Object[])new Object[0]);
        this.currentStateName = currentStateName;
        this.setDirty(true);
    }

    public void addAssignee(IAtsUser assignee) throws OseeCoreException {
        this.addAssignee(this.getCurrentStateName(), assignee);
    }

    public void addState(String stateName, List<? extends IAtsUser> assignees) {
        this.addState(stateName, assignees, 0.0, 0);
    }

    public void setAssignees(List<? extends IAtsUser> assignees) throws OseeCoreException {
        this.setAssignees(this.getCurrentStateName(), assignees);
    }

    public void createState(String stateName) {
        WorkState state = this.getState(stateName);
        if (state == null) {
            state = this.factory.createStateData(stateName);
            this.addState(state);
        }
    }

    public void setPercentComplete(String stateName, int percentComplete) throws OseeStateException {
        WorkState state = this.getState(stateName);
        if (state == null) {
            throw new OseeStateException("State [%s] not found for %s", new Object[]{stateName, this.workItem.toStringWithId()});
        }
        state.setPercentComplete(percentComplete);
        this.setDirty(true);
    }

    public void setHoursSpent(String stateName, double hoursSpent) throws OseeStateException {
        WorkState state = this.getState(stateName);
        if (state == null) {
            throw new OseeStateException("State [%s] not found for %s", new Object[]{stateName, this.workItem.toStringWithId()});
        }
        state.setHoursSpent(hoursSpent);
        this.setDirty(true);
    }

    public double getHoursSpent(String stateName) {
        WorkState state = this.getState(stateName);
        if (state != null) {
            return state.getHoursSpent();
        }
        return 0.0;
    }

    public int getPercentComplete(String stateName) {
        WorkState state = this.getState(stateName);
        if (state != null) {
            return state.getPercentComplete();
        }
        return 0;
    }

    public List<String> getVisitedStateNames() {
        LinkedList<String> stateNames = new LinkedList<String>();
        for (WorkState state : this.states) {
            stateNames.add(state.getName());
        }
        return stateNames;
    }

    public void removeAssignee(String stateName, IAtsUser assignee) throws OseeCoreException {
        WorkState state = this.getState(stateName);
        if (state == null) {
            throw new OseeStateException("State [%s] not found for %s", new Object[]{stateName, this.workItem.toStringWithId()});
        }
        state.removeAssignee(assignee);
        this.setDirty(true);
    }

    public void setAssignee(IStateToken state, IAtsUser assignee) throws OseeCoreException {
        this.setAssignee(state.getName(), assignee);
    }

    public void createState(IStateToken state) {
        this.createState(state.getName());
    }

    public boolean isUnAssignedSolely() throws OseeCoreException {
        return this.getAssignees().size() == 1 && this.isUnAssigned();
    }

    public String getAssigneesStr() {
        return this.getAssigneesStr(this.getCurrentStateName());
    }

    public void removeAssignee(IAtsUser assignee) throws OseeCoreException {
        this.removeAssignee(this.getCurrentStateName(), assignee);
    }

    public boolean isUnAssigned() throws OseeCoreException {
        return this.getAssignees().contains(AtsCoreUsers.UNASSIGNED_USER);
    }

    public void clearAssignees() throws OseeCoreException {
        this.setAssignees(this.getCurrentStateName(), new LinkedList());
    }

    public Collection<IAtsUser> getAssignees(IStateToken state) {
        return this.getAssignees(state.getName());
    }

    public boolean isStateVisited(IStateToken state) {
        return this.isStateVisited(state.getName());
    }

    public String getAssigneesStr(int length) {
        return this.getAssigneesStr(this.getCurrentStateName(), length);
    }

    public String getAssigneesStr(String stateName, int length) {
        String str = this.getAssigneesStr(stateName);
        if (str.length() > length) {
            return String.valueOf(str.substring(0, length - 1)) + "...";
        }
        return str;
    }

    public String getAssigneesStr(String stateName) {
        return AtsObjects.toString("; ", this.getAssignees(stateName));
    }

    public void addAssignees(Collection<? extends IAtsUser> assignees) throws OseeCoreException {
        this.addAssignees(this.getCurrentStateName(), assignees);
    }

    public void setAssignee(String stateName, IAtsUser assignee) throws OseeCoreException {
        if (assignee != null) {
            this.setAssignees(stateName, Arrays.asList(assignee));
        }
    }

    public boolean isStateVisited(String stateName) {
        return this.getVisitedStateNames().contains(stateName);
    }

    public WorkState createStateData(String name, List<? extends IAtsUser> assignees) {
        Conditions.checkNotNullOrContainNull(assignees, (String)"assignees");
        return new WorkStateImpl(name, assignees);
    }

    public WorkState createStateData(String name) {
        return new WorkStateImpl(name);
    }

    public WorkState createStateData(String name, List<? extends IAtsUser> assignees, double hoursSpent, int percentComplete) {
        Conditions.checkNotNullOrContainNull(assignees, (String)"assignees");
        return new WorkStateImpl(name, assignees, hoursSpent, percentComplete);
    }

    public void addState(WorkState workState) {
        this.addState(workState, true);
    }

    protected void addState(WorkState state, boolean logError) {
        if (this.getVisitedStateNames().contains(state.getName())) {
            String errorStr = String.format("Error: Duplicate state [%s] for [%s]", state.getName(), this.factory.getId());
            if (logError) {
                OseeLog.log(StateManager.class, (Level)Level.SEVERE, (String)errorStr);
            }
            return;
        }
        this.states.add(state);
        this.setDirty(true);
    }

    public void validateNoBootstrapUser() throws OseeCoreException {
        for (IAtsUser user : this.getAssignees()) {
            if (!SystemUser.BootStrap.getUserId().equals(user.getUserId())) continue;
            throw new OseeStateException("Assignee can't be bootstrap user for %s", new Object[]{this.workItem.toStringWithId()});
        }
    }

    public String getId() {
        return this.workItem.getAtsId();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setPercentCompleteValue(Integer percentComplete) {
        this.percentCompleteValue = percentComplete;
        this.setDirty(true);
    }

    public Integer getPercentCompleteValue() {
        return this.percentCompleteValue;
    }

    public List<IAtsUser> getInitialAssignees() {
        return this.initialAssignees;
    }

    public List<IAtsUser> getAssigneesAdded() throws OseeCoreException {
        ArrayList<IAtsUser> added = new ArrayList<IAtsUser>();
        List<IAtsUser> current = this.getAssignees();
        for (IAtsUser user : current) {
            if (this.initialAssignees.contains(user)) continue;
            added.add(user);
        }
        return added;
    }

    public void clear() {
        this.initialAssignees.clear();
        this.states.clear();
        this.percentCompleteValue = null;
        this.currentStateName = null;
    }

    public String toString() {
        return String.format("StateManager id[%s] for workitem [%s]", this.instanceGuid, this.workItem);
    }

    public boolean isInState(IStateToken state) {
        return this.getCurrentStateName().equals(state.getName());
    }
}

