/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.model.impl.WorkStateImpl;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public class AtsWorkStateFactory
implements IAtsWorkStateFactory {
    public Pattern storagePattern = Pattern.compile("^(.*?);(.*?);(.*?);(.*?)$");
    public Pattern userPattern = Pattern.compile("<(.*?)>");
    private final IAtsUserService userService;

    public AtsWorkStateFactory(IAtsUserService userService) {
        this.userService = userService;
    }

    public String toStoreStr(IAtsStateManager stateMgr, String stateName) throws OseeCoreException {
        StringBuffer sb = new StringBuffer(stateName);
        sb.append(";");
        sb.append(this.getStorageString(stateMgr.getAssignees(stateName)));
        sb.append(";");
        double hoursSpent = stateMgr.getHoursSpent(stateName);
        if (hoursSpent > 0.0) {
            sb.append(stateMgr.getHoursSpentStr(stateName));
        }
        sb.append(";");
        int percentComplete = stateMgr.getPercentComplete(stateName);
        if (percentComplete > 0) {
            sb.append(percentComplete);
        }
        return sb.toString();
    }

    public WorkStateImpl fromStoreStr(String xml) throws OseeCoreException {
        WorkStateImpl state = new WorkStateImpl("Unknown");
        if (Strings.isValid((String)xml)) {
            Matcher m = this.storagePattern.matcher(xml);
            if (m.find()) {
                state.setName(m.group(1));
                if (!m.group(3).equals("")) {
                    state.setHoursSpent(new Float(m.group(3)).doubleValue());
                }
                if (!m.group(4).equals("")) {
                    state.setPercentComplete(Integer.valueOf(m.group(4)));
                }
                String userStr = m.group(2);
                List<IAtsUser> users = this.getUsers(userStr);
                state.setAssignees(users);
            } else {
                throw new OseeArgumentException("Can't unpack state data [%s]", new Object[]{xml});
            }
        }
        return state;
    }

    public String getStorageString(Collection<IAtsUser> users) throws OseeCoreException {
        StringBuffer sb = new StringBuffer();
        for (IAtsUser u : users) {
            sb.append("<" + u.getUserId() + ">");
        }
        return sb.toString();
    }

    public List<IAtsUser> getUsers(String sorageString) {
        ArrayList<IAtsUser> users = new ArrayList<IAtsUser>();
        Matcher m = this.userPattern.matcher(sorageString);
        while (m.find()) {
            String userId = m.group(1);
            if (!Strings.isValid((String)userId)) {
                throw new IllegalArgumentException("Blank userId specified.");
            }
            try {
                String uId = m.group(1);
                IAtsUser u = this.userService.getUserById(uId);
                Conditions.checkNotNull((Object)u, (String)("userById " + uId));
                users.add(u);
            }
            catch (Exception ex) {
                OseeLog.log(AtsWorkStateFactory.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return users;
    }
}

