/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.state;

import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.api.workflow.state.IAtsWorkStateFactory;
import org.eclipse.osee.ats.core.internal.state.StateManager;
import org.eclipse.osee.ats.core.internal.state.StateManagerStore;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class AtsStateFactory
implements IAtsStateFactory {
    private final IAtsWorkStateFactory workStateFactory;
    private final IAtsLogFactory logFactory;
    private final IAtsServices services;

    public AtsStateFactory(IAtsServices services, IAtsWorkStateFactory workStateFactory, IAtsLogFactory logFactory) {
        this.services = services;
        this.workStateFactory = workStateFactory;
        this.logFactory = logFactory;
    }

    public IAtsStateManager getStateManager(IAtsWorkItem workItem) {
        StateManager stateMgr = new StateManager(workItem, this.logFactory, this.services);
        return stateMgr;
    }

    public IAtsStateManager getStateManager(IAtsWorkItem workItem, boolean load) throws OseeCoreException {
        IAtsStateManager stateMgr = this.getStateManager(workItem);
        if (load) {
            StateManagerStore.load(workItem, stateMgr, this.services.getAttributeResolver(), this.workStateFactory);
        }
        return stateMgr;
    }

    public void writeToStore(IAtsUser asUser, IAtsWorkItem workItem, IAtsChangeSet changes) throws OseeCoreException {
        StateManagerStore.writeToStore(asUser, workItem, (StateManager)workItem.getStateMgr(), this.services.getAttributeResolver(), changes, this.workStateFactory);
    }

    public void load(IAtsWorkItem workItem, IAtsStateManager stateMgr) {
        StateManagerStore.load(workItem, stateMgr, this.services.getAttributeResolver(), this.workStateFactory);
    }
}

