/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.workflow.log.AtsLogUtility;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class LogItem
implements IAtsLogItem {
    private Date date;
    private String msg;
    private String state;
    private String userId;
    private LogType type = LogType.None;

    public LogItem(LogType type, Date date, String userId, String state, String msg) throws OseeCoreException {
        this(type.name(), String.valueOf(date.getTime()), userId, state, msg);
    }

    public LogItem(LogType type, String date, String userId, String state, String msg) throws OseeCoreException {
        Long dateLong = Long.valueOf(date);
        this.date = new Date(dateLong);
        this.msg = msg;
        this.state = Strings.intern((String)state);
        this.userId = Strings.intern((String)userId);
        this.type = type;
    }

    public LogItem(String type, String date, String userId, String state, String msg) throws OseeCoreException {
        this(LogType.getType((String)type), date, userId, state, msg);
    }

    public Date getDate() {
        return this.date;
    }

    public String getDate(String pattern) {
        if (pattern != null) {
            return new SimpleDateFormat(pattern, Locale.US).format(this.date);
        }
        return this.date.toString();
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return String.format("%s (%s)%s by %s on %s", AtsLogUtility.getToStringMsg(this), this.type, AtsLogUtility.getToStringState(this), this.getUserId(), DateUtil.getMMDDYYHHMM((Date)this.date));
    }

    public LogType getType() {
        return this.type;
    }

    public void setType(LogType type) {
        this.type = type;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String setUserId(String userId) {
        this.userId = userId;
        return this.userId;
    }
}

