/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.AtsWorkPackageType;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.core.internal.column.ev.AbstractRelatedWorkPackageColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class WorkPackageTypeColumn
extends AbstractRelatedWorkPackageColumn {
    public WorkPackageTypeColumn(IAtsEarnedValueServiceProvider earnedValueServiceProvider, IAtsServices services) {
        super(earnedValueServiceProvider, services);
    }

    @Override
    protected String getColumnValue(IAtsWorkPackage workPkg) {
        try {
            return workPkg.getWorkPackageType().name();
        }
        catch (OseeCoreException ex) {
            return "!Error - " + ex.getLocalizedMessage();
        }
    }

    @Override
    protected String getColumnValue(ArtifactToken wpArt) {
        if (this.services == null) {
            return "";
        }
        String value = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)wpArt, (AttributeTypeId)AtsAttributeTypes.WorkPackageType, (Object)"");
        AtsWorkPackageType type = AtsWorkPackageType.None;
        if (Strings.isValid((String)value)) {
            try {
                type = AtsWorkPackageType.valueOf((String)value);
                return type.name();
            }
            catch (Exception exception) {}
        }
        return type.name();
    }
}

