/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import java.util.Map;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IWorkPackageColumn;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.core.column.IWorkPackageUtility;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class WorkPackageColumn
implements IWorkPackageUtility,
IWorkPackageColumn {
    private final IAtsEarnedValueServiceProvider earnedValueServiceProvider;
    private Map<String, ArtifactToken> guidToWorkPackage;

    public WorkPackageColumn(IAtsEarnedValueServiceProvider earnedValueServiceProvider) {
        this.earnedValueServiceProvider = earnedValueServiceProvider;
    }

    @Override
    public String getWorkPackageId(Object object) {
        return this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)object);
    }

    public void setIdToWorkPackageCache(Map<String, ArtifactToken> guidToWorkPackage) {
        this.guidToWorkPackage = guidToWorkPackage;
    }

    public String getColumnText(IAtsObject atsObject) {
        String result = "";
        try {
            IAtsWorkPackage workPackage = null;
            if (atsObject instanceof IAtsWorkItem) {
                String workPackageId = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)atsObject);
                if (this.guidToWorkPackage != null && Strings.isValid((String)workPackageId)) {
                    ArtifactToken wpArt = this.guidToWorkPackage.get(workPackageId);
                    workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage(wpArt);
                }
                if (workPackage == null && (workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((IAtsWorkItem)atsObject)) != null && this.guidToWorkPackage != null) {
                    this.guidToWorkPackage.put(workPackageId, workPackage.getStoreObject());
                }
                if (workPackage != null) {
                    result = this.getText(workPackage);
                }
            }
        }
        catch (OseeCoreException ex) {
            return "!Error - " + ex.getLocalizedMessage();
        }
        return result;
    }

    private String getText(IAtsWorkPackage workPackage) {
        String result = "";
        if (workPackage != null) {
            String activityId = Strings.isValid((String)workPackage.getActivityId()) ? workPackage.getActivityId() : "";
            String activityName = Strings.isValid((String)workPackage.getActivityName()) ? workPackage.getActivityName() : "";
            result = String.format("%s - %s", activityId, activityName);
        }
        return result;
    }

    @Override
    public String getColumnText(IAtsWorkPackage workPackage) {
        return this.getText(workPackage);
    }

    @Override
    public IAtsWorkPackage getWorkPackage(IAtsObject atsObject) throws OseeCoreException {
        IAtsWorkPackage workPackage = null;
        String workPackageId = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)atsObject);
        if (this.guidToWorkPackage != null && Strings.isValid((String)workPackageId)) {
            ArtifactToken wpArt = this.guidToWorkPackage.get(workPackageId);
            workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage(wpArt);
            if (workPackage != null) {
                return workPackage;
            }
        }
        if (atsObject instanceof IAtsWorkItem) {
            workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((IAtsWorkItem)atsObject);
        }
        return workPackage;
    }
}

