/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.column.IAtsColumn;
import org.eclipse.osee.ats.api.column.IAtsColumnId;
import org.eclipse.osee.ats.api.column.IAtsColumnService;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.core.column.ActionableItemsColumn;
import org.eclipse.osee.ats.core.column.AgileFeatureGroupColumn;
import org.eclipse.osee.ats.core.column.AgileTeamPointsColumn;
import org.eclipse.osee.ats.core.column.AssigneeColumn;
import org.eclipse.osee.ats.core.column.AtsAttributeValueColumnHandler;
import org.eclipse.osee.ats.core.column.AtsColumnId;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.core.column.AtsIdColumn;
import org.eclipse.osee.ats.core.column.AttributeColumn;
import org.eclipse.osee.ats.core.column.CancelledByColumn;
import org.eclipse.osee.ats.core.column.CancelledDateColumn;
import org.eclipse.osee.ats.core.column.CompletedByColumn;
import org.eclipse.osee.ats.core.column.CompletedCancelledByColumn;
import org.eclipse.osee.ats.core.column.CompletedCancelledDateColumn;
import org.eclipse.osee.ats.core.column.CompletedDateColumn;
import org.eclipse.osee.ats.core.column.CreatedDateColumn;
import org.eclipse.osee.ats.core.column.IAtsColumnProvider;
import org.eclipse.osee.ats.core.column.ImplementerColumn;
import org.eclipse.osee.ats.core.column.InsertionActivityColumn;
import org.eclipse.osee.ats.core.column.InsertionColumn;
import org.eclipse.osee.ats.core.column.PercentCompleteTasksColumn;
import org.eclipse.osee.ats.core.column.SprintOrderColumn;
import org.eclipse.osee.ats.core.column.StateColumn;
import org.eclipse.osee.ats.core.column.TargetedVersionColumn;
import org.eclipse.osee.ats.core.column.TaskRelatedArtifactTypeColumn;
import org.eclipse.osee.ats.core.column.TeamColumn;
import org.eclipse.osee.ats.core.column.TitleColumn;
import org.eclipse.osee.ats.core.column.TypeColumn;
import org.eclipse.osee.ats.core.column.UuidColumn;
import org.eclipse.osee.ats.core.internal.column.ev.AtsColumnProviderCollector;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageGuidColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageIdColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageNameColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageProgramColumn;
import org.eclipse.osee.ats.core.internal.column.ev.WorkPackageTypeColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeId;

public class AtsColumnService
implements IAtsColumnService {
    public static final String CELL_ERROR_PREFIX = "!Error";
    private Map<String, IAtsColumn> columnIdToAtsColumn;
    private final IAtsServices services;

    public AtsColumnService(IAtsServices services) {
        this.services = services;
    }

    public IAtsColumn getColumn(String id) {
        IAtsColumn column;
        if (this.columnIdToAtsColumn == null) {
            this.columnIdToAtsColumn = new HashMap<String, IAtsColumn>();
        }
        if ((column = this.columnIdToAtsColumn.get(id)) != null) {
            return column;
        }
        for (AtsAttributeValueColumn attrCol : this.services.getConfigurations().getViews().getAttrColumns()) {
            if (!id.equals(attrCol.getId())) continue;
            column = new AtsAttributeValueColumnHandler(attrCol, this.services);
            break;
        }
        if (column == null) {
            if (id.equals(AtsColumnId.ActionableItem.getId())) {
                column = new ActionableItemsColumn(this.services);
            } else if (id.equals(AtsColumnId.LegacyPcrId.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnToken.LegacyPcrIdColumn, this.services);
            } else if (id.equals(AtsColumnId.Team.getId())) {
                column = new TeamColumn(this.services);
            } else if (id.equals(AtsColumnId.Assignees.getId())) {
                column = new AssigneeColumn(this.services);
            } else if (id.equals(AtsColumnId.AtsId.getId())) {
                column = new AtsIdColumn(this.services);
            } else if (id.equals(AtsColumnId.ActivityId.getId())) {
                column = new WorkPackageColumn(this.services.getEarnedValueServiceProvider());
            } else if (id.equals(AtsColumnId.Implementers.getId())) {
                column = new ImplementerColumn(this.services);
            } else if (id.equals(AtsColumnId.ChangeType.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnToken.ChangeTypeColumn, this.services);
            } else if (id.equals(AtsColumnId.CreatedDate.getId())) {
                column = new CreatedDateColumn(this.services);
            } else if (id.equals(AtsColumnId.CompletedDate.getId())) {
                column = new CompletedDateColumn(this.services);
            } else if (id.equals(AtsColumnId.CancelledDate.getId())) {
                column = new CancelledDateColumn(this.services);
            } else if (id.equals(AtsColumnId.CancelledBy.getId())) {
                column = new CancelledByColumn(this.services);
            } else if (id.equals(AtsColumnId.CompletedBy.getId())) {
                column = new CompletedByColumn(this.services);
            } else if (id.equals(AtsColumnId.CompletedCancelledBy.getId())) {
                column = new CompletedCancelledByColumn(this.services);
            } else if (id.equals(AtsColumnId.CompletedCancelledDate.getId())) {
                column = new CompletedCancelledDateColumn(this.services);
            } else if (id.equals(AtsColumnId.Notes.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnToken.NotesColumn, this.services);
            } else if (id.equals(AtsColumnId.State.getId())) {
                column = new StateColumn(this.services);
            } else if (id.equals(AtsColumnId.Name.getId()) || id.equals(AtsColumnId.Title.getId())) {
                column = new TitleColumn(this.services);
            } else if (id.equals(AtsColumnId.Type.getId())) {
                column = new TypeColumn(this.services);
            } else if (id.equals(AtsColumnId.PercentCompleteWorkflow.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnToken.PercentCompleteWorkflowColumn, this.services);
            } else if (id.equals(AtsColumnId.PercentCompleteTasks.getId())) {
                column = new PercentCompleteTasksColumn(this.services);
            } else if (id.equals(AtsColumnId.Uuid.getId())) {
                column = new UuidColumn(this.services);
            } else if (id.equals(AtsColumnId.Priority.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnToken.PriorityColumn, this.services);
            } else if (id.equals(AtsColumnId.WorkPackageName.getId())) {
                column = new WorkPackageNameColumn(this.services.getEarnedValueServiceProvider(), this.services);
            } else if (id.equals(AtsColumnId.WorkPackageId.getId())) {
                column = new WorkPackageIdColumn(this.services.getEarnedValueServiceProvider(), this.services);
            } else if (id.equals(AtsColumnId.WorkPackageType.getId())) {
                column = new WorkPackageTypeColumn(this.services.getEarnedValueServiceProvider(), this.services);
            } else if (id.equals(AtsColumnId.WorkPackageProgram.getId())) {
                column = new WorkPackageProgramColumn(this.services.getEarnedValueServiceProvider(), this.services);
            } else if (id.equals(AtsColumnId.WorkPackageGuid.getId())) {
                column = new WorkPackageGuidColumn(this.services.getEarnedValueServiceProvider(), this.services);
            } else if (id.equals(AtsColumnId.State.getId())) {
                column = new StateColumn(this.services);
            } else if (id.equals(AtsColumnId.Uuid.getId())) {
                column = new UuidColumn(this.services);
            } else if (id.equals(AtsColumnId.Insertion.getId())) {
                column = new InsertionColumn(this.services);
            } else if (id.equals(AtsColumnId.InsertionActivity.getId())) {
                column = new InsertionActivityColumn(this.services);
            } else if (id.equals(AtsColumnId.TargetedVersion.getId())) {
                column = new TargetedVersionColumn(this.services);
            } else if (id.equals(AtsColumnId.UnPlannedWork.getId())) {
                column = new AtsAttributeValueColumnHandler(AtsColumnToken.UnPlannedWorkColumn, this.services);
            } else if (id.equals(AtsColumnId.SprintOrder.getId())) {
                column = new SprintOrderColumn(this.services);
            } else if (id.equals(AtsColumnId.AgileTeamPoints.getId())) {
                column = new AgileTeamPointsColumn(this.services);
            } else if (id.equals(AtsColumnId.CompletedCancelledDate.getId())) {
                column = new CompletedCancelledDateColumn(this.services);
            } else if (id.equals(AtsColumnId.AgileFeatureGroup.getId())) {
                column = new AgileFeatureGroupColumn(this.services);
            } else if (id.equals(AtsColumnId.TaskToRelatedArtifactType.getId())) {
                column = new TaskRelatedArtifactTypeColumn(this.services);
            }
        }
        if (column == null) {
            for (IAtsColumnProvider provider : AtsColumnProviderCollector.getColumnProviders()) {
                column = provider.getColumn(id, this.services);
                if (column != null) break;
            }
        }
        if (column == null) {
            AttributeTypeId attrType;
            if (id.startsWith("attribute.") && (attrType = this.services.getStoreService().getAttributeType(id.replaceFirst("attribute\\.", ""))) != null) {
                column = new AttributeColumn(this.services, attrType);
            }
            if (id.startsWith("ats.") && (attrType = this.services.getStoreService().getAttributeType(id)) != null) {
                column = new AttributeColumn(this.services, attrType);
            }
        }
        this.add(id, column);
        return column;
    }

    public String getColumnText(IAtsColumnId column, IAtsObject atsObject) {
        return this.getColumnText(column.getId(), atsObject);
    }

    public String getColumnText(String id, IAtsObject atsObject) {
        String result = "";
        IAtsColumn column = this.getColumn(id);
        result = column == null ? "column not supported" : column.getColumnText(atsObject);
        return result;
    }

    public String getColumnText(AtsConfigurations configurations, IAtsColumnId column, IAtsObject atsObject) {
        return this.getColumnText(configurations, column.getId(), atsObject);
    }

    public String getColumnText(AtsConfigurations configurations, String id, IAtsObject atsObject) {
        String result = "";
        IAtsColumn column = this.getColumn(id);
        result = column == null ? "column not supported" : column.getColumnText(atsObject);
        return result;
    }

    public void add(String id, IAtsColumn column) {
        this.columnIdToAtsColumn.put(id, column);
    }

    public IAtsColumn getColumn(IAtsColumnId columnId) {
        return this.getColumn(columnId.getId());
    }
}

