/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import java.util.Map;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IAtsColumn;
import org.eclipse.osee.ats.api.column.IWorkPackageColumn;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractRelatedWorkPackageColumn
implements IAtsColumn,
IWorkPackageColumn {
    private final IAtsEarnedValueServiceProvider earnedValueServiceProvider;
    private Map<String, ArtifactToken> guidToWorkPackage;
    protected final IAtsServices services;

    public AbstractRelatedWorkPackageColumn(IAtsEarnedValueServiceProvider earnedValueServiceProvider, IAtsServices services) {
        this.earnedValueServiceProvider = earnedValueServiceProvider;
        this.services = services;
    }

    public void setIdToWorkPackageCache(Map<String, ArtifactToken> guidToWorkPackage) {
        this.guidToWorkPackage = guidToWorkPackage;
    }

    public String getColumnText(IAtsObject atsObject) {
        String result = "";
        try {
            String workPackageId;
            if (atsObject instanceof IAtsWorkItem && (workPackageId = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)atsObject)) != null) {
                IAtsWorkPackage workPkg;
                IAtsWorkPackage workPkg2;
                ArtifactToken wpArt;
                if (this.guidToWorkPackage != null && Strings.isValid((String)workPackageId) && Strings.isInValid((String)(result = this.getColumnValue(wpArt = this.guidToWorkPackage.get(workPackageId)))) && (workPkg2 = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage(wpArt)) != null) {
                    result = this.getColumnValue(workPkg2);
                }
                if (Strings.isInValid((String)result) && (workPkg = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((IAtsWorkItem)atsObject)) != null) {
                    result = this.getColumnValue(workPkg);
                    if (this.guidToWorkPackage != null) {
                        this.guidToWorkPackage.put(workPackageId, workPkg.getStoreObject());
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            result = "!Error - " + ex.getLocalizedMessage();
        }
        return result;
    }

    protected abstract String getColumnValue(ArtifactToken var1);

    protected abstract String getColumnValue(IAtsWorkPackage var1);
}

