/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.cpa;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.cpa.CpaBuild;
import org.eclipse.osee.ats.api.cpa.CpaDecision;
import org.eclipse.osee.ats.api.cpa.CpaProgram;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;

public class CpaFactory {
    private static final Map<String, Object> idToStoreObject = new HashMap<String, Object>(500);
    public static final String CPA_BASEPATH_KEY = "CpaBasepath";

    public static CpaProgram get(IAtsProgram program) {
        return CpaFactory.getProgram(program, null);
    }

    public static CpaProgram getProgram(IAtsProgram program, Object storeObject) {
        CpaProgram prog = new CpaProgram(program.getId(), program.getName());
        CpaFactory.setStoreObject(program.getIdString(), storeObject);
        return prog;
    }

    private static void setStoreObject(String key, Object object) {
        idToStoreObject.put(key, object);
    }

    public static CpaDecision getDecision(IAtsTeamWorkflow teamWf) {
        return CpaFactory.getDecision(teamWf, null);
    }

    public static CpaDecision getDecision(IAtsTeamWorkflow teamWf, Object storeObject) {
        CpaDecision decision = new CpaDecision(teamWf.getAtsId(), teamWf.getName());
        CpaFactory.setStoreObject(teamWf.getAtsId(), storeObject);
        return decision;
    }

    public static CpaBuild getVersion(IAtsVersion version, Object storeObject) {
        Long uuid = version.getId();
        CpaBuild build = new CpaBuild(uuid, version.getName());
        CpaFactory.setStoreObject(String.valueOf(uuid), storeObject);
        return build;
    }
}

