/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class WorkPackageUtility {
    public Pair<IAtsCountry, Boolean> getCountry(IAtsServices services, IAtsWorkItem workItem) {
        IAtsCountry country;
        Pair result = new Pair(null, (Object)false);
        Pair<IAtsProgram, Boolean> programResult = this.getProgram(services, workItem);
        if (programResult.getFirst() != null && (country = (IAtsCountry)services.getRelationResolver().getRelatedOrNull((IAtsObject)programResult.getFirst(), AtsRelationTypes.CountryToProgram_Country, IAtsCountry.class)) != null) {
            result.setFirst((Object)country);
            result.setSecond((Object)((Boolean)programResult.getSecond()));
        }
        return result;
    }

    public Pair<IAtsProgram, Boolean> getProgram(IAtsServices services, IAtsWorkItem workItem) {
        IAtsProgram program;
        Pair result = new Pair(null, (Object)false);
        Pair<IAtsInsertion, Boolean> insertionResult = this.getInsertion(services, workItem);
        if (insertionResult.getFirst() != null && (program = (IAtsProgram)services.getRelationResolver().getRelatedOrNull((IAtsObject)insertionResult.getFirst(), AtsRelationTypes.ProgramToInsertion_Program, IAtsProgram.class)) != null) {
            result.setFirst((Object)program);
            result.setSecond((Object)((Boolean)insertionResult.getSecond()));
        }
        return result;
    }

    public Pair<IAtsInsertion, Boolean> getInsertion(IAtsServices services, IAtsWorkItem workItem) {
        IAtsInsertion insertion;
        Pair result = new Pair(null, (Object)false);
        Pair<IAtsInsertionActivity, Boolean> insertionActivityResult = this.getInsertionActivity(services, workItem);
        if (insertionActivityResult.getFirst() != null && (insertion = (IAtsInsertion)services.getRelationResolver().getRelatedOrNull((IAtsObject)insertionActivityResult.getFirst(), AtsRelationTypes.InsertionToInsertionActivity_Insertion, IAtsInsertion.class)) != null) {
            result.setFirst((Object)insertion);
            result.setSecond((Object)((Boolean)insertionActivityResult.getSecond()));
        }
        return result;
    }

    public Pair<IAtsInsertionActivity, Boolean> getInsertionActivity(IAtsServices services, IAtsWorkItem workItem) {
        ArtifactToken activityArt;
        Pair result = new Pair(null, (Object)false);
        Pair<ArtifactId, Boolean> workPackageResult = this.getWorkPackageArtifact(services, workItem);
        if (workPackageResult.getFirst() != null && (activityArt = services.getRelationResolver().getRelatedOrNull((ArtifactId)workPackageResult.getFirst(), AtsRelationTypes.InsertionActivityToWorkPackage_InsertionActivity)) != null) {
            IAtsInsertionActivity activity = services.getConfigItemFactory().getInsertionActivity((ArtifactId)activityArt);
            result.setFirst((Object)activity);
            result.setSecond((Object)((Boolean)workPackageResult.getSecond()));
        }
        return result;
    }

    public Pair<ArtifactId, Boolean> getWorkPackageArtifact(IAtsServices services, IAtsWorkItem workItem) {
        IAtsTeamWorkflow teamWf;
        Pair<ArtifactId, Boolean> teamResult;
        ArtifactToken workPackageArt;
        Pair result = new Pair(null, (Object)false);
        String workPackageGuid = (String)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, null);
        if (Strings.isValid((String)workPackageGuid) && (workPackageArt = services.getArtifactByGuid(workPackageGuid)) != null) {
            result.setFirst((Object)workPackageArt);
        }
        if (result.getFirst() == null && !workItem.isTeamWorkflow() && (teamResult = this.getWorkPackageArtifact(services, (IAtsWorkItem)(teamWf = workItem.getParentTeamWorkflow()))).getFirst() != null) {
            result.setSecond((Object)true);
            result.setFirst((Object)((ArtifactId)teamResult.getFirst()));
        }
        return result;
    }
}

