/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.commit.ICommitConfigItem;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.IAtsVersionService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class Versions {
    public static Collection<String> getNames(Collection<? extends IAtsVersion> versions) {
        ArrayList<String> names = new ArrayList<String>();
        for (IAtsVersion iAtsVersion : versions) {
            names.add(iAtsVersion.getName());
        }
        return names;
    }

    public static String getTargetedVersionStr(IAtsWorkItem workItem, IAtsVersionService versionService) throws OseeCoreException {
        IAtsVersion version;
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        if (teamWf != null && (version = versionService.getTargetedVersion(workItem)) != null) {
            if (!teamWf.getStateMgr().getStateType().isCompletedOrCancelled() && versionService.isReleased(teamWf)) {
                String errStr = "Workflow " + teamWf.getAtsId() + " targeted for released version, but not completed: " + version;
                return "!Error " + errStr;
            }
            return version.getName();
        }
        return "";
    }

    public static List<IAtsVersion> getParallelVersions(IAtsVersion version, IAtsServices services) {
        ArrayList<IAtsVersion> parallelVersions = new ArrayList<IAtsVersion>();
        for (ArtifactId parallelVersion : services.getRelationResolver().getRelated((ArtifactId)services.getArtifact((IAtsObject)version), AtsRelationTypes.ParallelVersion_Child)) {
            IAtsVersion parallelVer = services.getConfigItemFactory().getVersion(parallelVersion);
            parallelVersions.add(parallelVer);
        }
        return parallelVersions;
    }

    public static void getParallelVersions(IAtsVersion version, Set<ICommitConfigItem> configArts, IAtsServices services) {
        configArts.add((ICommitConfigItem)version);
        for (IAtsVersion childArt : Versions.getParallelVersions(version, services)) {
            if (configArts.contains(childArt)) continue;
            Versions.getParallelVersions(childArt, configArts, services);
        }
    }
}

