/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.commit.ICommitConfigItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class Version
extends AtsConfigObject
implements IAtsVersion {
    public Version(Log logger, IAtsServices services, ArtifactToken artifact) {
        super(logger, services, artifact);
    }

    public String getCommitFullDisplayName() {
        String description;
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(this.getName());
        String fullName = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.FullName, (Object)"");
        if (Strings.isValid((String)fullName)) {
            strs.add(fullName);
        }
        if (Strings.isValid((String)(description = (String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.Description, (Object)"")))) {
            strs.add(description);
        }
        return Collections.toString((String)" - ", strs);
    }

    public Result isAllowCreateBranchInherited() {
        if (!this.isAllowCreateBranch()) {
            return new Result(false, "Branch creation disabled for Version [" + (Object)((Object)this) + "]");
        }
        if (!this.services.getBranchService().isBranchValid((ICommitConfigItem)this)) {
            return new Result(false, "Parent Branch not configured for Version [" + (Object)((Object)this) + "]");
        }
        return Result.TrueResult;
    }

    public boolean isAllowCreateBranch() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AllowCreateBranch, (Object)false);
    }

    public boolean isAllowCommitBranch() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AllowCommitBranch, (Object)false);
    }

    public Result isAllowCommitBranchInherited() {
        if (!this.isAllowCommitBranch()) {
            return new Result(false, "Version [" + (Object)((Object)this) + "] not configured to allow branch commit.");
        }
        if (!this.services.getBranchService().isBranchValid((ICommitConfigItem)this)) {
            return new Result(false, "Parent Branch not configured for Version [" + (Object)((Object)this) + "]");
        }
        return Result.TrueResult;
    }

    public Date getReleaseDate() {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.ReleaseDate, null);
    }

    public Boolean isReleased() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.Released, (Object)false);
    }

    public Date getEstimatedReleaseDate() {
        return (Date)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.EstimatedReleaseDate, null);
    }

    public boolean isLocked() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.VersionLocked, (Object)false);
    }

    public Boolean isVersionLocked() {
        return this.isLocked();
    }

    public Boolean isNextVersion() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.NextVersion, (Object)false);
    }

    @Override
    public String getTypeName() {
        return "Version";
    }

    public BranchId getBaselineBranchIdInherited() {
        if (this.getBaselineBranchId().isValid()) {
            return this.getBaselineBranchId();
        }
        try {
            IAtsTeamDefinition teamDef = this.services.getVersionService().getTeamDefinition((IAtsVersion)this);
            if (teamDef != null) {
                return teamDef.getTeamBranchId();
            }
            return BranchId.SENTINEL;
        }
        catch (OseeCoreException oseeCoreException) {
            return BranchId.SENTINEL;
        }
    }

    public BranchId getBaselineBranchId() {
        return BranchId.valueOf((String)((String)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.BaselineBranchUuid, (Object)"-1")));
    }
}

