/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class TeamDefinitions {
    public static Collection<String> getNames(Collection<? extends IAtsTeamDefinition> teamDefs) {
        ArrayList<String> names = new ArrayList<String>();
        for (IAtsTeamDefinition iAtsTeamDefinition : teamDefs) {
            names.add(iAtsTeamDefinition.getName());
        }
        return names;
    }

    public static List<IAtsTeamDefinition> getTopLevelTeamDefinitions(Active active, IAtsQueryService queryService) throws OseeCoreException {
        IAtsTeamDefinition topTeamDef = TeamDefinitions.getTopTeamDefinition(queryService);
        if (topTeamDef == null) {
            return java.util.Collections.emptyList();
        }
        return Collections.castAll(TeamDefinitions.getActive(TeamDefinitions.getChildren(topTeamDef, false), active));
    }

    public static List<IAtsTeamDefinition> getActive(Collection<IAtsTeamDefinition> teamDefs, Active active) {
        ArrayList<IAtsTeamDefinition> results = new ArrayList<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : teamDefs) {
            if (active == Active.Both) {
                results.add(teamDef);
                continue;
            }
            boolean attributeActive = teamDef.isActive();
            if (active == Active.Active && attributeActive) {
                results.add(teamDef);
                continue;
            }
            if (active != Active.InActive || attributeActive) continue;
            results.add(teamDef);
        }
        return results;
    }

    public static Set<IAtsTeamDefinition> getChildren(IAtsTeamDefinition topTeamDef, boolean recurse) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> children = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition child : topTeamDef.getChildrenTeamDefinitions()) {
            children.add(child);
            if (!recurse) continue;
            children.addAll(TeamDefinitions.getChildren(child, recurse));
        }
        return children;
    }

    public static List<IAtsTeamDefinition> getTeamDefinitions(Active active, IAtsQueryService queryService) throws OseeCoreException {
        return Collections.castAll(TeamDefinitions.getActive(queryService.createQuery(new IArtifactType[]{AtsArtifactTypes.TeamDefinition}).getItems(), active));
    }

    public static List<IAtsTeamDefinition> getTeamTopLevelDefinitions(Active active, IAtsQueryService queryService) throws OseeCoreException {
        IAtsTeamDefinition topTeamDef = TeamDefinitions.getTopTeamDefinition(queryService);
        if (topTeamDef == null) {
            return java.util.Collections.emptyList();
        }
        return Collections.castAll(TeamDefinitions.getActive(TeamDefinitions.getChildren(topTeamDef, false), active));
    }

    public static IAtsTeamDefinition getTopTeamDefinition(IAtsQueryService queryService) throws OseeCoreException {
        return (IAtsTeamDefinition)queryService.createQuery(new IArtifactType[]{AtsArtifactTypes.TeamDefinition}).andUuids(new Long[]{AtsArtifactToken.TopTeamDefinition.getId()}).getOneOrNull(IAtsTeamDefinition.class);
    }

    public static Set<IAtsTeamDefinition> getTeamReleaseableDefinitions(Active active, IAtsQueryService queryService) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : TeamDefinitions.getTeamDefinitions(active, queryService)) {
            if (teamDef.getVersions().size() <= 0) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public static Set<IAtsTeamDefinition> getTeamsFromItemAndChildren(IAtsActionableItem ai) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> aiTeams = new HashSet<IAtsTeamDefinition>();
        TeamDefinitions.getTeamFromItemAndChildren(ai, aiTeams);
        return aiTeams;
    }

    public static Set<IAtsTeamDefinition> getTeamsFromItemAndChildren(IAtsTeamDefinition teamDef) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        teamDefs.add(teamDef);
        for (IAtsTeamDefinition child : teamDef.getChildrenTeamDefinitions()) {
            teamDefs.addAll(TeamDefinitions.getTeamsFromItemAndChildren(child));
        }
        return teamDefs;
    }

    private static void getTeamFromItemAndChildren(IAtsActionableItem ai, Set<IAtsTeamDefinition> aiTeams) throws OseeCoreException {
        aiTeams.add(ai.getTeamDefinition());
        for (IAtsActionableItem childArt : ai.getChildrenActionableItems()) {
            TeamDefinitions.getTeamFromItemAndChildren(childArt, aiTeams);
        }
    }

    public static Set<IAtsTeamDefinition> getTeamDefinitions(Collection<String> teamDefNames, IAtsQueryService queryService) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : TeamDefinitions.getTeamDefinitions(Active.Both, queryService)) {
            if (!teamDefNames.contains(teamDef.getName())) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public static Set<IAtsTeamDefinition> getTeamDefinitionsNameStartsWith(String prefix, IAtsQueryService queryService) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
        for (IAtsTeamDefinition teamDef : TeamDefinitions.getTeamDefinitions(Active.Both, queryService)) {
            if (!teamDef.getName().startsWith(prefix)) continue;
            teamDefs.add(teamDef);
        }
        return teamDefs;
    }

    public static Collection<IAtsTeamDefinition> getImpactedTeamDefs(Collection<IAtsActionableItem> ais) throws OseeCoreException {
        HashSet<IAtsTeamDefinition> resultTeams = new HashSet<IAtsTeamDefinition>();
        for (IAtsActionableItem ai : ais) {
            resultTeams.addAll(TeamDefinitions.getImpactedTeamDefInherited(ai));
        }
        return resultTeams;
    }

    public static IAtsTeamDefinition getImpactedTeamDef(IAtsActionableItem ai) {
        if (ai.getTeamDefinition() != null) {
            return ai.getTeamDefinition();
        }
        if (ai.getParentActionableItem() != null) {
            return TeamDefinitions.getImpactedTeamDef(ai.getParentActionableItem());
        }
        return null;
    }

    private static Collection<IAtsTeamDefinition> getImpactedTeamDefInherited(IAtsActionableItem ai) throws OseeCoreException {
        if (ai == null) {
            return java.util.Collections.emptyList();
        }
        if (ai.getTeamDefinition() != null) {
            return java.util.Collections.singleton(ai.getTeamDefinition());
        }
        IAtsActionableItem parentArt = ai.getParentActionableItem();
        return TeamDefinitions.getImpactedTeamDefInherited(parentArt);
    }
}

