/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinitionService;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TeamDefinitionService
implements IAtsTeamDefinitionService {
    protected final IAtsServices services;

    public TeamDefinitionService(IAtsServices services) {
        this.services = services;
    }

    public IAtsTeamDefinition getTeamDefinition(IAtsWorkItem workItem) throws OseeCoreException {
        IAtsTeamDefinition teamDef = null;
        String teamDefGuid = (String)this.services.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.TeamDefinition, (Object)"");
        if (Strings.isValid((String)teamDefGuid)) {
            teamDef = (IAtsTeamDefinition)this.services.getConfigItem(teamDefGuid);
        }
        return teamDef;
    }

    public Collection<IAtsVersion> getVersions(IAtsTeamDefinition teamDef) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        for (ArtifactId verArt : this.services.getRelationResolver().getRelated((IAtsObject)teamDef, AtsRelationTypes.TeamDefinitionToVersion_Version)) {
            versions.add(this.services.getConfigItemFactory().getVersion(verArt));
        }
        return versions;
    }

    public IAtsTeamDefinition getTeamDefHoldingVersions(IAtsTeamDefinition teamDef) {
        return teamDef.getTeamDefinitionHoldingVersions();
    }

    public IAtsTeamDefinition getTeamDefHoldingVersions(IAtsProgram program) {
        return this.services.getProgramService().getTeamDefHoldingVersions(program);
    }

    public IAtsTeamDefinition getTeamDefinition(String name) {
        IAtsTeamDefinition teamDef = null;
        ArtifactToken teamDefArt = this.services.getArtifactByName(AtsArtifactTypes.TeamDefinition, name);
        if (teamDefArt != null) {
            teamDef = this.services.getConfigItemFactory().getTeamDef((ArtifactId)teamDefArt);
        }
        return teamDef;
    }

    public Collection<IAtsTeamDefinition> getTeamDefinitions(IAgileTeam agileTeam) {
        LinkedList<IAtsTeamDefinition> teamDefs = new LinkedList<IAtsTeamDefinition>();
        for (ArtifactId atsTeamArt : this.services.getRelationResolver().getRelated((IAtsObject)agileTeam, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam)) {
            teamDefs.add(this.services.getConfigItemFactory().getTeamDef(atsTeamArt));
        }
        return teamDefs;
    }
}

