/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.VersionLockedType;
import org.eclipse.osee.ats.api.version.VersionReleaseType;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.logger.Log;

public class TeamDefinition
extends AtsConfigObject
implements IAtsTeamDefinition {
    private final IAtsServices services;

    public TeamDefinition(Log logger, IAtsServices services, ArtifactToken artifact) {
        super(logger, services, artifact);
        this.services = services;
    }

    @Override
    public String getTypeName() {
        return "Team Definition";
    }

    public Collection<IAtsActionableItem> getActionableItems() {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        try {
            for (ArtifactId aiArt : this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.TeamActionableItem_ActionableItem)) {
                IAtsActionableItem ai = this.services.getConfigItemFactory().getActionableItem(aiArt);
                ais.add(ai);
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getActionableItems", new Object[0]);
        }
        return ais;
    }

    public IAtsTeamDefinition getParentTeamDef() {
        IAtsTeamDefinition parent = null;
        try {
            Collection related = this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, CoreRelationTypes.Default_Hierarchical__Parent);
            if (!related.isEmpty()) {
                parent = this.services.getConfigItemFactory().getTeamDef((ArtifactId)related.iterator().next());
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getParentTeamDef", new Object[0]);
        }
        return parent;
    }

    public Collection<IAtsTeamDefinition> getChildrenTeamDefinitions() {
        HashSet<IAtsTeamDefinition> children = new HashSet<IAtsTeamDefinition>();
        try {
            for (ArtifactId childArt : this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, CoreRelationTypes.Default_Hierarchical__Child)) {
                IAtsTeamDefinition childTeamDef = this.services.getConfigItemFactory().getTeamDef(childArt);
                if (childTeamDef == null) continue;
                children.add(childTeamDef);
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getChildrenTeamDefinitions", new Object[0]);
        }
        return children;
    }

    public Collection<IAtsUser> getLeads(Collection<IAtsActionableItem> actionableItems) {
        HashSet<IAtsUser> leads = new HashSet<IAtsUser>();
        for (IAtsActionableItem aia : actionableItems) {
            if (!this.equals(aia.getTeamDefinitionInherited())) continue;
            Collection leads2 = aia.getLeads();
            if (leads2.size() > 0) {
                leads.addAll(leads2);
                continue;
            }
            if (aia.getTeamDefinitionInherited() == null) continue;
            Collection leads3 = aia.getTeamDefinitionInherited().getLeads();
            leads.addAll(leads3);
        }
        if (leads.isEmpty()) {
            Collection<IAtsUser> leads2 = this.getLeads();
            leads.addAll(leads2);
        }
        return leads;
    }

    public Collection<IAtsUser> getMembers() {
        return this.getRelatedUsers(AtsRelationTypes.TeamMember_Member);
    }

    public Collection<IAtsUser> getMembersAndLeads() {
        HashSet<IAtsUser> results = new HashSet<IAtsUser>();
        results.addAll(this.getLeads());
        results.addAll(this.getMembers());
        return results;
    }

    public Collection<IAtsUser> getPrivilegedMembers() {
        return this.getRelatedUsers(AtsRelationTypes.PrivilegedMember_Member);
    }

    public boolean isAllowCommitBranch() {
        boolean set = false;
        try {
            set = (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AllowCommitBranch, (Object)false);
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error is allow commit branch", new Object[0]);
        }
        return set;
    }

    public Result isAllowCommitBranchInherited() {
        if (!this.isAllowCommitBranch()) {
            return new Result(false, "Team Definition [" + (Object)((Object)this) + "] not configured to allow branch commit.");
        }
        if (this.getBaselineBranchId().isInvalid()) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + (Object)((Object)this) + "]");
        }
        return Result.TrueResult;
    }

    public boolean isAllowCreateBranch() {
        boolean set = false;
        try {
            set = (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AllowCreateBranch, (Object)false);
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error get allow create branch", new Object[0]);
        }
        return set;
    }

    public Result isAllowCreateBranchInherited() {
        if (!this.isAllowCreateBranch()) {
            return new Result(false, "Branch creation disabled for Team Definition [" + (Object)((Object)this) + "]");
        }
        if (this.getBaselineBranchId().isInvalid()) {
            return new Result(false, "Parent Branch not configured for Team Definition [" + (Object)((Object)this) + "]");
        }
        return Result.TrueResult;
    }

    public BranchId getBaselineBranchId() {
        return BranchId.valueOf((String)((String)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.BaselineBranchUuid, "0")));
    }

    public BranchId getTeamBranchId() {
        BranchId branch = this.getBaselineBranchId();
        if (branch.isValid()) {
            return branch;
        }
        IAtsTeamDefinition parentTeamDef = this.getParentTeamDef();
        if (parentTeamDef instanceof TeamDefinition) {
            return parentTeamDef.getTeamBranchId();
        }
        return BranchId.SENTINEL;
    }

    public String getCommitFullDisplayName() {
        return this.getName();
    }

    public boolean isTeamUsesVersions() throws OseeCoreException {
        return this.getTeamDefinitionHoldingVersions() != null;
    }

    public IAtsVersion getNextReleaseVersion() {
        IAtsVersion result = null;
        for (IAtsVersion version : this.getVersions()) {
            if (!version.isNextVersion().booleanValue()) continue;
            result = version;
            break;
        }
        return result;
    }

    public IAtsTeamDefinition getTeamDefinitionHoldingVersions() throws OseeCoreException {
        TeamDefinition teamDef = null;
        if (this.getVersions().size() > 0) {
            teamDef = this;
        } else {
            IAtsTeamDefinition parentTda = this.getParentTeamDef();
            if (parentTda != null) {
                teamDef = parentTda.getTeamDefinitionHoldingVersions();
            }
        }
        return teamDef;
    }

    public IAtsVersion getVersion(String name) {
        IAtsVersion result = null;
        for (IAtsVersion version : this.getVersions()) {
            if (!version.getName().equals(name)) continue;
            result = version;
            break;
        }
        return result;
    }

    public Collection<IAtsVersion> getVersions() {
        HashSet<IAtsVersion> results = new HashSet<IAtsVersion>();
        try {
            for (ArtifactId verArt : this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.TeamDefinitionToVersion_Version)) {
                IAtsVersion version = this.services.getConfigItemFactory().getVersion(verArt);
                results.add(version);
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getting versions", new Object[0]);
        }
        return results;
    }

    public Collection<IAtsVersion> getVersions(VersionReleaseType releaseType, VersionLockedType lockedType) {
        return Collections.setIntersection(this.getVersionsReleased(releaseType), this.getVersionsLocked(lockedType));
    }

    public Collection<IAtsVersion> getVersionsFromTeamDefHoldingVersions(VersionReleaseType releaseType, VersionLockedType lockedType) throws OseeCoreException {
        IAtsTeamDefinition teamDef = this.getTeamDefinitionHoldingVersions();
        if (teamDef == null) {
            return new ArrayList<IAtsVersion>();
        }
        return teamDef.getVersions(releaseType, lockedType);
    }

    public Collection<IAtsVersion> getVersionsLocked(VersionLockedType lockType) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        for (IAtsVersion version : this.getVersions()) {
            if (version.isVersionLocked().booleanValue() && (lockType == VersionLockedType.Locked || lockType == VersionLockedType.Both)) {
                versions.add(version);
                continue;
            }
            if ((version.isVersionLocked().booleanValue() || lockType != VersionLockedType.UnLocked) && lockType != VersionLockedType.Both) continue;
            versions.add(version);
        }
        return versions;
    }

    public Collection<IAtsVersion> getVersionsReleased(VersionReleaseType releaseType) {
        ArrayList<IAtsVersion> versions = new ArrayList<IAtsVersion>();
        for (IAtsVersion version : this.getVersions()) {
            if (version.isReleased().booleanValue() && (releaseType == VersionReleaseType.Released || releaseType == VersionReleaseType.Both)) {
                versions.add(version);
                continue;
            }
            if ((version.isReleased().booleanValue() || releaseType != VersionReleaseType.UnReleased) && releaseType != VersionReleaseType.Both) continue;
            versions.add(version);
        }
        return versions;
    }

    public String getWorkflowDefinition() {
        return (String)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.WorkflowDefinition, "");
    }

    public String getRelatedTaskWorkDefinition() {
        return (String)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.RelatedTaskWorkDefinition, "");
    }

    public String getRelatedPeerWorkDefinition() {
        return (String)this.getAttributeValue((AttributeTypeId)AtsAttributeTypes.RelatedPeerWorkflowDefinition, "");
    }

    public Collection<String> getRules() {
        ArrayList<String> rules = new ArrayList();
        try {
            rules = this.services.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.RuleDefinition);
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getting rules", new Object[0]);
        }
        return rules;
    }

    public boolean hasRule(String rule) {
        boolean result = false;
        for (String rule2 : this.getRules()) {
            if (!rule.equals(rule2)) continue;
            result = true;
            break;
        }
        return result;
    }
}

