/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.config.IAtsCache;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;

public class AtsCache
implements IAtsCache {
    private static IAtsServices services;
    private final LoadingCache<Long, IAtsObject> uuidToAtsObjectCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(uuidToAtsObjectCacheLoader);
    private final LoadingCache<Long, ArtifactId> uuidToArtifactIdCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(uuidToArtifactIdCacheLoader);
    private final LoadingCache<String, IAtsObject> guidToAtsObjectCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(tagToAtsObjectCacheLoader);
    static CacheLoader<Long, IAtsObject> uuidToAtsObjectCacheLoader;
    static CacheLoader<Long, ArtifactId> uuidToArtifactIdCacheLoader;
    static CacheLoader<String, IAtsObject> tagToAtsObjectCacheLoader;
    static CacheLoader<String, ArtifactId> tagToArtifactIdCacheLoader;

    static {
        uuidToAtsObjectCacheLoader = new CacheLoader<Long, IAtsObject>(){

            public IAtsObject load(Long uuid) {
                return services.getConfigItemFactory().getConfigObject((ArtifactId)services.getArtifact(uuid));
            }
        };
        uuidToArtifactIdCacheLoader = new CacheLoader<Long, ArtifactId>(){

            public ArtifactId load(Long uuid) {
                return services.getArtifact(uuid);
            }
        };
        tagToAtsObjectCacheLoader = new CacheLoader<String, IAtsObject>(){

            public IAtsObject load(String tag) {
                if (GUID.isValid((String)tag)) {
                    return services.getConfigItemFactory().getConfigObject((ArtifactId)services.getArtifactByGuid(tag));
                }
                throw new IllegalStateException(String.format("IAtsObject not tagged with tag [%s]", tag));
            }
        };
        tagToArtifactIdCacheLoader = new CacheLoader<String, ArtifactId>(){

            public ArtifactId load(String tag) {
                if (GUID.isValid((String)tag)) {
                    return services.getArtifactByGuid(tag);
                }
                throw new IllegalStateException(String.format("ArtifactId not tagged with tag [%s]", tag));
            }
        };
    }

    public AtsCache(IAtsServices services) {
        AtsCache.services = services;
    }

    public <T extends IAtsObject> T getAtsObject(Long uuid) {
        Conditions.checkNotNull((Object)uuid, (String)"uuid");
        try {
            return (T)((IAtsObject)this.uuidToAtsObjectCache.get((Object)uuid));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T extends IAtsObject> T getAtsObject(ArtifactId artifact) {
        return this.getAtsObject(artifact.getId());
    }

    public <T extends IAtsObject> T getAtsObjectByGuid(String guid) {
        Conditions.checkNotNullOrEmpty((String)guid, (String)"guid");
        try {
            return (T)((IAtsObject)this.guidToAtsObjectCache.get((Object)guid));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void cacheAtsObject(IAtsObject atsObject) {
        Conditions.checkNotNull((Object)atsObject, (String)"atsObject");
        ArtifactToken storeObject = services.getArtifact((ArtifactId)atsObject.getStoreObject());
        if (storeObject != null) {
            this.guidToAtsObjectCache.put((Object)((String)storeObject.getGuid()), (Object)atsObject);
            this.uuidToArtifactIdCache.put((Object)atsObject.getId(), (Object)storeObject);
        }
        this.uuidToAtsObjectCache.put((Object)atsObject.getId(), (Object)atsObject);
    }

    public void cacheArtifact(ArtifactId artifact) {
        Conditions.checkNotNull((Object)artifact, (String)"artifact");
        this.uuidToArtifactIdCache.put((Object)artifact.getId(), (Object)artifact);
    }

    public void invalidate() {
        this.guidToAtsObjectCache.invalidateAll();
        this.uuidToAtsObjectCache.invalidateAll();
        this.uuidToArtifactIdCache.invalidateAll();
    }

    public void deCacheAtsObject(IAtsObject atsObject) {
        Conditions.checkNotNull((Object)atsObject, (String)"atsObject");
        if (services.getArtifact(atsObject) != null) {
            this.guidToAtsObjectCache.invalidate(services.getArtifact(atsObject).getGuid());
        }
        this.uuidToAtsObjectCache.invalidate((Object)atsObject.getId());
        this.uuidToArtifactIdCache.invalidate((Object)atsObject.getId());
    }
}

