/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.query.IAtsQueryService;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.core.config.TeamDefinitions;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class ActionableItems {
    public static Set<IAtsActionableItem> getAIsFromItemAndChildren(IAtsActionableItem ai) throws OseeCoreException {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        ais.add(ai);
        for (IAtsActionableItem art : ai.getChildrenActionableItems()) {
            ais.addAll(ActionableItems.getAIsFromItemAndChildren(art));
        }
        return ais;
    }

    public static Set<IAtsActionableItem> getActionableItemsFromItemAndChildren(IAtsActionableItem ai) throws OseeCoreException {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        ActionableItems.getActionableItemsFromItemAndChildren(ai, ais);
        return ais;
    }

    public static void getActionableItemsFromItemAndChildren(IAtsActionableItem ai, Set<IAtsActionableItem> aiTeams) throws OseeCoreException {
        for (IAtsActionableItem art : ai.getChildrenActionableItems()) {
            aiTeams.add(art);
            for (IAtsActionableItem childArt : ai.getChildrenActionableItems()) {
                ActionableItems.getActionableItemsFromItemAndChildren(childArt, aiTeams);
            }
        }
    }

    public static Set<IAtsActionableItem> getActionableItems(Collection<String> actionableItemNames, IAtsServices services) throws OseeCoreException {
        HashSet<IAtsActionableItem> ais = new HashSet<IAtsActionableItem>();
        for (String actionableItemName : actionableItemNames) {
            for (IAtsActionableItem ai : services.getQueryService().createQuery(new IArtifactType[]{AtsArtifactTypes.ActionableItem}).getItems(IAtsActionableItem.class)) {
                if (!ai.getName().equals(actionableItemName)) continue;
                ais.add(ai);
            }
        }
        return ais;
    }

    public static Collection<IAtsTeamDefinition> getImpactedTeamDefs(Collection<IAtsActionableItem> ais) throws OseeCoreException {
        return TeamDefinitions.getImpactedTeamDefs(ais);
    }

    public static List<IAtsActionableItem> getActionableItems(Active active, IAtsQueryService queryService) throws OseeCoreException {
        return Collections.castAll(ActionableItems.getActive(queryService.createQuery(new IArtifactType[]{AtsArtifactTypes.ActionableItem}).getItems(), active));
    }

    public static String getNotActionableItemError(IAtsConfigObject configObject) {
        return "Action can not be written against " + configObject.getName() + " \"" + configObject + "\" (" + configObject.getId() + ").\n\nChoose another item.";
    }

    public static IAtsActionableItem getTopActionableItem(IAtsServices services) throws OseeCoreException {
        ArtifactToken artifact = services.getArtifact(AtsArtifactToken.TopActionableItem.getId());
        return (IAtsActionableItem)services.getConfigItem((ArtifactId)artifact);
    }

    public static List<IAtsActionableItem> getActionableItemsAll(IAtsQueryService queryService) throws OseeCoreException {
        return ActionableItems.getActionableItems(Active.Both, queryService);
    }

    public static List<IAtsActionableItem> getTopLevelActionableItems(Active active, IAtsServices services) throws OseeCoreException {
        IAtsActionableItem topAi = ActionableItems.getTopActionableItem(services);
        if (topAi == null) {
            return java.util.Collections.emptyList();
        }
        return Collections.castAll(ActionableItems.getActive(ActionableItems.getChildren(topAi, false), active));
    }

    public static List<IAtsActionableItem> getActive(Collection<IAtsActionableItem> ais, Active active) {
        ArrayList<IAtsActionableItem> results = new ArrayList<IAtsActionableItem>();
        for (IAtsActionableItem ai : ais) {
            if (active == Active.Both) {
                results.add(ai);
                continue;
            }
            boolean attributeActive = ai.isActive();
            if (active == Active.Active && attributeActive) {
                results.add(ai);
                continue;
            }
            if (active != Active.InActive || attributeActive) continue;
            results.add(ai);
        }
        return results;
    }

    public static Set<IAtsActionableItem> getChildren(IAtsActionableItem topActionableItem, boolean recurse) throws OseeCoreException {
        HashSet<IAtsActionableItem> children = new HashSet<IAtsActionableItem>();
        for (IAtsActionableItem child : topActionableItem.getChildrenActionableItems()) {
            children.add(child);
            if (!recurse) continue;
            children.addAll(ActionableItems.getChildren(child, recurse));
        }
        return children;
    }

    public static Collection<IAtsActionableItem> getUserEditableActionableItems(Collection<IAtsActionableItem> actionableItems) {
        LinkedList<IAtsActionableItem> ais = new LinkedList<IAtsActionableItem>();
        for (IAtsActionableItem ai : actionableItems) {
            if (!ai.isAllowUserActionCreation()) continue;
            ais.add(ai);
        }
        return ais;
    }
}

