/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.core.config.TeamDefinitions;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;

public class ActionableItem2
extends AtsConfigObject
implements IAtsActionableItem {
    private final JaxActionableItem jaxAI;

    public ActionableItem2(Log logger, IAtsServices services, JaxActionableItem jaxAI) {
        super(logger, services, ArtifactToken.valueOf((long)jaxAI.getUuid(), (String)jaxAI.getGuid(), (String)jaxAI.getName(), (BranchId)services.getAtsBranch(), (IArtifactType)AtsArtifactTypes.ActionableItem));
        this.jaxAI = jaxAI;
    }

    @Override
    public String getTypeName() {
        return "Actionable Item";
    }

    public Collection<String> getRules() throws OseeCoreException {
        ArrayList<String> rules = new ArrayList();
        try {
            rules = this.services.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.RuleDefinition);
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getting rules", new Object[0]);
        }
        return rules;
    }

    public boolean hasRule(String rule) throws OseeCoreException {
        return this.getRules().contains(rule);
    }

    public Collection<IAtsActionableItem> getChildrenActionableItems() {
        LinkedList<IAtsActionableItem> children = new LinkedList<IAtsActionableItem>();
        for (Long childId : this.jaxAI.getChildren()) {
            children.add(new ActionableItem2(this.logger, this.services, (JaxActionableItem)this.services.getConfigurations().getIdToAi().get(childId)));
        }
        return children;
    }

    public IAtsActionableItem getParentActionableItem() {
        IAtsActionableItem parent = null;
        try {
            if (this.jaxAI.getParentId() != null) {
                parent = this.services.getConfigItemFactory().getActionableItem((ArtifactId)this.services.getArtifact(this.jaxAI.getParentId()));
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getParentActionableItem", new Object[0]);
        }
        return parent;
    }

    public IAtsTeamDefinition getTeamDefinition() {
        IAtsTeamDefinition teamDef = null;
        try {
            if (this.jaxAI.getTeamDefId() != null) {
                teamDef = this.services.getConfigItemFactory().getTeamDef((ArtifactId)this.services.getArtifact(this.jaxAI.getTeamDefId()));
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getTeamDefinition", new Object[0]);
        }
        return teamDef;
    }

    public IAtsTeamDefinition getTeamDefinitionInherited() {
        return TeamDefinitions.getImpactedTeamDef(this);
    }

    public boolean isAllowUserActionCreation() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AllowUserActionCreation, (Object)true);
    }

    @Override
    public boolean isActive() {
        return this.jaxAI.isActive();
    }
}

