/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.core.config.TeamDefinitions;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.logger.Log;

public class ActionableItem
extends AtsConfigObject
implements IAtsActionableItem {
    public ActionableItem(Log logger, IAtsServices services, ArtifactToken artifact) {
        super(logger, services, artifact);
    }

    public Collection<IAtsActionableItem> getChildrenActionableItems() {
        HashSet<IAtsActionableItem> children = new HashSet<IAtsActionableItem>();
        try {
            for (ArtifactId childArt : this.services.getRelationResolver().getChildren((ArtifactId)this.artifact, AtsArtifactTypes.ActionableItem)) {
                IAtsActionableItem childTeamDef = this.services.getConfigItemFactory().getActionableItem(childArt);
                children.add(childTeamDef);
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getting Children Actionable Items", new Object[0]);
        }
        return children;
    }

    public IAtsActionableItem getParentActionableItem() {
        IAtsActionableItem parent = null;
        try {
            Collection related = this.services.getRelationResolver().getRelated((ArtifactId)this.artifact, CoreRelationTypes.Default_Hierarchical__Parent);
            if (!related.isEmpty()) {
                parent = this.services.getConfigItemFactory().getActionableItem((ArtifactId)related.iterator().next());
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getParentActionableItem", new Object[0]);
        }
        return parent;
    }

    public IAtsTeamDefinition getTeamDefinition() {
        IAtsTeamDefinition teamDef = null;
        try {
            ArtifactToken related = this.services.getRelationResolver().getRelatedOrNull((ArtifactId)this.artifact, AtsRelationTypes.TeamActionableItem_Team);
            if (related != null) {
                teamDef = this.services.getConfigItemFactory().getTeamDef((ArtifactId)related);
            }
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getTeamDefinition", new Object[0]);
        }
        return teamDef;
    }

    public IAtsTeamDefinition getTeamDefinitionInherited() {
        return TeamDefinitions.getImpactedTeamDef(this);
    }

    @Override
    public void setActionable(boolean actionable) {
        throw new UnsupportedOperationException("Error ActionableItem.setActionable not implemented");
    }

    @Override
    public String getTypeName() {
        return "Actionable Item";
    }

    public boolean isAllowUserActionCreation() {
        return (Boolean)this.services.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.AllowUserActionCreation, (Object)true);
    }

    public Collection<String> getRules() {
        ArrayList<String> rules = new ArrayList();
        try {
            rules = this.services.getAttributeResolver().getAttributeValues((ArtifactId)this.artifact, (AttributeTypeId)AtsAttributeTypes.RuleDefinition);
        }
        catch (OseeCoreException ex) {
            this.getLogger().error((Throwable)ex, "Error getting rules", new Object[0]);
        }
        return rules;
    }

    public boolean hasRule(String rule) {
        return this.getRules().contains(rule);
    }
}

