/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TeamColumn
extends AbstractServicesColumn {
    public TeamColumn(IAtsServices services) {
        super(services);
    }

    @Override
    public String getText(IAtsObject atsObject) {
        String result = "";
        if (atsObject instanceof IAtsTeamWorkflow) {
            result = ((IAtsTeamWorkflow)atsObject).getTeamDefinition().getName();
        } else if (atsObject instanceof IAtsWorkItem) {
            result = this.getColumnText((IAtsObject)((IAtsWorkItem)atsObject).getParentTeamWorkflow());
        }
        if (!Strings.isValid((String)result) && atsObject instanceof IAtsAbstractReview) {
            IAtsAbstractReview review = (IAtsAbstractReview)atsObject;
            if (this.services.getReviewService().isStandAloneReview(review)) {
                ArrayList<IAtsTeamDefinition> teams = new ArrayList<IAtsTeamDefinition>();
                for (IAtsActionableItem ai : review.getActionableItems()) {
                    if (ai.getTeamDefinitionInherited() == null) continue;
                    teams.add(ai.getTeamDefinition());
                }
                if (!teams.isEmpty()) {
                    result = Collections.toString((String)", ", teams);
                }
            }
        }
        return result;
    }
}

