/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.IArtifactType;
import org.eclipse.osee.framework.core.data.TokenFactory;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class TaskRelatedArtifactTypeColumn
extends AbstractServicesColumn {
    private static IAtsServices services;
    private static final IArtifactType nullArtifactType;
    private static final LoadingCache<IAtsWorkItem, IArtifactType> artIdToRelatedArtTypeCache;

    static {
        nullArtifactType = TokenFactory.createArtifactType((long)3824729235692L, (String)"");
        artIdToRelatedArtTypeCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<IAtsWorkItem, IArtifactType>(){

            public IArtifactType load(IAtsWorkItem workItem) throws Exception {
                Long relatedArtId = TaskRelatedArtifactTypeColumn.getRelatedArtId(workItem);
                if (relatedArtId != null) {
                    Map results = services.getStoreService().getArtifactTypes(Collections.singleton(relatedArtId));
                    if (results.isEmpty()) {
                        return nullArtifactType;
                    }
                    return (IArtifactType)results.values().iterator().next();
                }
                return nullArtifactType;
            }
        });
    }

    public TaskRelatedArtifactTypeColumn(IAtsServices services) {
        super(services);
        TaskRelatedArtifactTypeColumn.services = services;
    }

    @Override
    String getText(IAtsObject atsObject) throws Exception {
        Object obj;
        if (atsObject instanceof IAtsWorkItem && (obj = artIdToRelatedArtTypeCache.get((Object)((IAtsWorkItem)atsObject))) != null) {
            return obj.toString();
        }
        return "";
    }

    public void populateCache(List<IAtsWorkItem> workItems) {
        LinkedList<Long> relatedArtIds = new LinkedList<Long>();
        for (IAtsWorkItem workItem : workItems) {
            try {
                Long relatedArtId;
                if (artIdToRelatedArtTypeCache.get((Object)workItem) != null || (relatedArtId = TaskRelatedArtifactTypeColumn.getRelatedArtId(workItem)) == null) continue;
                relatedArtIds.add(relatedArtId);
            }
            catch (Exception exception) {}
        }
        if (!relatedArtIds.isEmpty()) {
            Map results = services.getStoreService().getArtifactTypes(relatedArtIds);
            for (IAtsWorkItem workItem : workItems) {
                Long relatedArtId = TaskRelatedArtifactTypeColumn.getRelatedArtId(workItem);
                if (relatedArtId == null) continue;
                IArtifactType artifactType = (IArtifactType)results.get(relatedArtId);
                artIdToRelatedArtTypeCache.put((Object)workItem, (Object)artifactType);
            }
        }
    }

    private static Long getRelatedArtId(IAtsWorkItem workItem) {
        String relatedArtIdStr = services.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.TaskToChangedArtifactReference, null);
        if (Strings.isNumeric((String)relatedArtIdStr)) {
            return Long.valueOf(relatedArtIdStr);
        }
        return null;
    }
}

