/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;

public class PercentCompleteTasksColumn
extends AbstractServicesColumn {
    public PercentCompleteTasksColumn(IAtsServices services) {
        super(services);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        if (IAtsAction.isOfType((Object)atsObject) || IAtsTeamWorkflow.isOfType((Object)atsObject)) {
            return String.valueOf(PercentCompleteTasksColumn.getPercentCompleteFromTasks(atsObject, this.services));
        }
        return "";
    }

    public static int getPercentCompleteFromTasks(IAtsObject atsObject, IAtsServices services) throws OseeCoreException {
        if (IAtsAction.isOfType((Object)atsObject)) {
            IAtsAction action = (IAtsAction)atsObject;
            double percent = 0.0;
            for (IAtsTeamWorkflow teamWf : action.getTeamWorkflows()) {
                if (teamWf.isCancelled()) continue;
                percent += (double)PercentCompleteTasksColumn.getPercentCompleteFromTasks(teamWf, services);
            }
            if (percent == 0.0) {
                return 0;
            }
            Double rollPercent = percent / (double)action.getTeamWorkflows().size();
            return rollPercent.intValue();
        }
        if (IAtsTeamWorkflow.isOfType((Object)atsObject)) {
            return PercentCompleteTasksColumn.getPercentCompleteFromTasks((IAtsTeamWorkflow)atsObject, services);
        }
        return 0;
    }

    public static int getPercentCompleteFromTasks(IAtsTeamWorkflow teamWf, IAtsServices services) {
        int spent = 0;
        int result = 0;
        Collection tasks = services.getTaskService().getTasks(teamWf);
        for (IAtsTask task : tasks) {
            spent += PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)task, services);
        }
        if (spent > 0) {
            result = spent / tasks.size();
        }
        return result;
    }
}

