/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CompletedCancelledByColumn
extends AbstractServicesColumn {
    public CompletedCancelledByColumn(IAtsServices services) {
        super(services);
    }

    @Override
    String getText(IAtsObject atsObject) throws Exception {
        IAtsUser user;
        if (atsObject instanceof IAtsWorkItem && (user = CompletedCancelledByColumn.getCompletedCancelledBy(atsObject, this.services)) != null) {
            return user.getName();
        }
        return null;
    }

    public static IAtsUser getCompletedCancelledBy(Object obj, IAtsServices services) {
        String userId = null;
        if (obj instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)obj;
            AttributeTypeToken type = null;
            if (workItem.isCompleted()) {
                type = AtsAttributeTypes.CompletedBy;
            } else if (workItem.isCancelled()) {
                type = AtsAttributeTypes.CancelledBy;
            }
            if (type != null && Strings.isValid((String)(userId = (String)services.getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsWorkItem)obj), (AttributeTypeId)type, null)))) {
                return services.getUserService().getUserById(userId);
            }
        }
        return null;
    }
}

