/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.ColorColumn;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class ColorTeamColumn {
    private static final String WHITE_HEX = "#FFFFFF";
    private static final String BLACK_HEX = "#000000";
    public static final String ATS_COLOR_TEAM_COLUMN_ID = "ats.Color Team";

    public static Pair<String, Boolean> getWorkItemColorTeam(IAtsWorkItem workItem, IAtsServices atsServices) {
        ArtifactToken workPackageArt;
        IAtsTeamWorkflow teamWf;
        Pair result = new Pair(null, (Object)false);
        IAttributeResolver attributeResolver = atsServices.getAttributeResolver();
        String workPackageGuid = (String)attributeResolver.getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, null);
        if (workPackageGuid == null && !(workItem instanceof IAtsTeamWorkflow) && (teamWf = workItem.getParentTeamWorkflow()) != null) {
            workPackageGuid = (String)attributeResolver.getSoleAttributeValue((IAtsObject)teamWf, (AttributeTypeId)AtsAttributeTypes.WorkPackageGuid, null);
            result.setSecond((Object)true);
        }
        if (workPackageGuid != null && (workPackageArt = atsServices.getArtifactById(workPackageGuid)) != null) {
            String colorTeam = (String)attributeResolver.getSoleAttributeValue((ArtifactId)workPackageArt, (AttributeTypeId)AtsAttributeTypes.ColorTeam, (Object)"");
            result.setFirst((Object)colorTeam);
        }
        if (result.getFirst() == null) {
            result.setFirst((Object)"");
        }
        return result;
    }

    public static ColorColumn getColor() {
        ColorColumn color = new ColorColumn();
        color.setColumnId(ATS_COLOR_TEAM_COLUMN_ID);
        color.setColor("Blood Red Team", WHITE_HEX, "#CC0000");
        color.setColor("Blue Crew Team", WHITE_HEX, "#0000CC");
        color.setColor("Mean Green Team", WHITE_HEX, "#003300");
        color.setColor("Purple Team", WHITE_HEX, "#2E002E");
        color.setColor("Burnt Orange Team", BLACK_HEX, "#CC5200");
        color.setColor("Bronze Team", BLACK_HEX, "#754719");
        color.setColor("Silver Team", BLACK_HEX, "#828268");
        color.setColor("Pirate Black Team", WHITE_HEX, BLACK_HEX);
        color.setColor("Gold Team", BLACK_HEX, "#CC9900");
        color.setColor("Plaid Team", BLACK_HEX, "#33CCFF");
        return color;
    }
}

