/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;

public class BacklogColumn {
    public static String getColumnText(Object element, IAtsServices services, boolean forBacklog) {
        if (element instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)element;
            Collection related = services.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal, IAtsWorkItem.class);
            if (!related.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (IAtsWorkItem relatedWorkItem : related) {
                    if (forBacklog) {
                        if (!BacklogColumn.isBacklog(relatedWorkItem, services)) continue;
                        sb.append(relatedWorkItem.getName());
                        sb.append("; ");
                        continue;
                    }
                    if (BacklogColumn.isBacklog(relatedWorkItem, services)) continue;
                    sb.append(relatedWorkItem.getName());
                    sb.append("; ");
                }
                return sb.toString().replaceFirst("; $", "");
            }
        }
        return "";
    }

    public static boolean isBacklog(IAtsWorkItem workItem, IAtsServices services) {
        if (services.getStoreService().isOfType((ArtifactId)workItem.getStoreObject(), new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog})) {
            return true;
        }
        return services.getRelationResolver().getRelatedCount(workItem, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) == 1;
    }
}

