/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IAtsColumn;
import org.eclipse.osee.ats.api.config.AtsAttributeValueColumn;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsAttributeValueColumnHandler
implements IAtsColumn {
    private final AtsAttributeValueColumn column;
    private final IAtsServices services;

    public AtsAttributeValueColumnHandler(AtsAttributeValueColumn column, IAtsServices services) {
        this.column = column;
        this.services = services;
    }

    public String getColumnText(IAtsObject atsObject) {
        return AtsAttributeValueColumnHandler.getColumnText(atsObject, this.column.getAttrTypeId(), (boolean)this.isActionRollup(), (boolean)this.isInheritParent(), this.services);
    }

    private Boolean isInheritParent() {
        Boolean inheritParent = this.column.isInheritParent();
        return inheritParent == null ? false : inheritParent;
    }

    private Boolean isActionRollup() {
        Boolean actionRollup = this.column.isActionRollup();
        return actionRollup == null ? false : actionRollup;
    }

    public static String getColumnText(IAtsObject atsObject, long attrTypeId, boolean isActionRollup, boolean isInheritParent, IAtsServices services) {
        block8: {
            if (!services.getStoreService().isDeleted(atsObject)) break block8;
            return "<deleted>";
        }
        try {
            if (atsObject instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
                AttributeTypeId attributeType = AttributeTypeId.valueOf((Long)attrTypeId);
                String result = services.getAttributeResolver().getAttributesToStringUniqueList((IAtsObject)workItem, attributeType, ";");
                if (Strings.isValid((String)result)) {
                    return result;
                }
                if (isInheritParent && !workItem.isTeamWorkflow() && workItem.getParentTeamWorkflow() != null && Strings.isValid((String)(result = Collections.toString((String)"; ", (Object[])new Object[]{services.getAttributeResolver().getAttributesToStringUniqueList((IAtsObject)workItem.getParentTeamWorkflow(), attributeType, ";")})))) {
                    return result;
                }
            }
            if (atsObject instanceof IAtsAction && isActionRollup) {
                Collection teams = ((IAtsAction)atsObject).getTeamWorkflows();
                HashSet<String> strs = new HashSet<String>();
                strs.add(atsObject.getName());
                for (IAtsTeamWorkflow team : teams) {
                    String str = AtsAttributeValueColumnHandler.getColumnText((IAtsObject)team, attrTypeId, isActionRollup, isInheritParent, services);
                    if (!Strings.isValid((String)str)) continue;
                    strs.add(str);
                }
                return Collections.toString((String)"; ", strs);
            }
        }
        catch (Exception ex) {
            return "!Error - " + ex.getLocalizedMessage();
        }
        return "";
    }

    public static String getColumnText(IAtsObject atsObject, AttributeTypeId attributeType, boolean isActionRollup, boolean inheritParent, IAtsServices services) {
        return AtsAttributeValueColumnHandler.getColumnText(atsObject, attributeType.getId(), isActionRollup, inheritParent, services);
    }

    public String toString() {
        return "AtsAttributeValueColumnHandler [attrType=" + this.column.getAttrTypeName() + "]";
    }
}

