/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsServices;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.IAtsUser;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workflow.HasActions;
import org.eclipse.osee.ats.api.workflow.HasAssignees;
import org.eclipse.osee.ats.api.workflow.IAtsImplementerService;
import org.eclipse.osee.ats.core.column.AbstractServicesColumn;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.AtsImplementersService;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AssigneeColumn
extends AbstractServicesColumn {
    private static IAtsImplementerService implementStrProvider;

    public AssigneeColumn(IAtsServices services) {
        super(services);
    }

    @Override
    public String getText(IAtsObject atsObject) {
        return this.getAssigneeStr(atsObject);
    }

    public String getAssigneeStr(IAtsObject atsObject) throws OseeCoreException {
        if (atsObject instanceof HasActions) {
            HasActions hasActions = (HasActions)atsObject;
            ArrayList<IAtsUser> pocs = new ArrayList<IAtsUser>();
            ArrayList<IAtsUser> implementers = new ArrayList<IAtsUser>();
            for (IAtsWorkItem workItem : hasActions.getActions()) {
                StateType stateType = workItem.getStateMgr().getStateType();
                if (stateType == null) continue;
                if (stateType.isCompletedOrCancelled()) {
                    for (IAtsUser user : workItem.getImplementers()) {
                        if (implementers.contains(user)) continue;
                        implementers.add(user);
                    }
                    continue;
                }
                for (IAtsUser user : workItem.getAssignees()) {
                    if (pocs.contains(user)) continue;
                    pocs.add(user);
                }
            }
            Collections.sort(pocs);
            Collections.sort(implementers);
            return String.valueOf(AtsObjects.toString("; ", pocs)) + (implementers.isEmpty() ? "" : "(" + AtsObjects.toString("; ", implementers) + ")");
        }
        if (atsObject instanceof IAtsWorkItem) {
            String implementers;
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            StateType stateType = workItem.getStateMgr().getStateType();
            if (stateType != null && stateType.isCompletedOrCancelled() && Strings.isValid((String)(implementers = this.getImplementersStringProvider().getImplementersStr((IAtsObject)workItem)))) {
                return "(" + implementers + ")";
            }
            if (atsObject instanceof HasAssignees) {
                return AtsObjects.toString("; ", ((HasAssignees)atsObject).getAssignees());
            }
        }
        return "";
    }

    private IAtsImplementerService getImplementersStringProvider() {
        if (implementStrProvider == null) {
            implementStrProvider = new AtsImplementersService(this.services);
        }
        return implementStrProvider;
    }
}

